/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.locks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.CCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.locks.LockRuntimeCCTNode;
import org.graalvm.visualvm.lib.ui.locks.LockContentionPanel;
import org.openide.util.Lookup;

public class LiveLocksViewUpdater {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private CCTHandler handler;
    private final LockContentionPanel jdbcView;
    private final ProfilerClient client;
    private volatile boolean paused;
    private volatile boolean forceRefresh;

    public LiveLocksViewUpdater(LockContentionPanel jdbcView, ProfilerClient client) {
        this.jdbcView = jdbcView;
        this.client = client;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    public void update() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.handler == null) {
            this.handler = CCTHandler.registerUpdater(this);
        }
        if (this.forceRefresh || !this.paused && this.jdbcView.getLastUpdate() + 1400L < System.currentTimeMillis()) {
            this.client.forceObtainedResultsDump(true);
        }
    }

    public void cleanup() {
        if (this.handler != null) {
            this.handler.unregisterUpdater(this);
        }
        this.handler = null;
    }

    private void updateData(LockRuntimeCCTNode root) throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.forceRefresh && (this.paused || this.jdbcView.getLastUpdate() + 900L > System.currentTimeMillis())) {
            return;
        }
        this.jdbcView.setData(root);
        this.forceRefresh = false;
    }

    private void resetData() {
        this.jdbcView.resetData();
    }

    public static class CCTHandler
    implements LockCCTProvider.Listener {
        private final List<LiveLocksViewUpdater> updaters = new ArrayList<LiveLocksViewUpdater>();

        public static CCTHandler registerUpdater(LiveLocksViewUpdater updater) {
            CCTHandler handler = (CCTHandler)Lookup.getDefault().lookup(CCTHandler.class);
            if (handler.updaters.isEmpty()) {
                Collection locksCCTProviders = Lookup.getDefault().lookupAll(LockCCTProvider.class);
                assert (!locksCCTProviders.isEmpty());
                for (LockCCTProvider provider : locksCCTProviders) {
                    provider.addListener((CCTProvider.Listener)handler);
                }
            }
            handler.updaters.add(updater);
            return handler;
        }

        public void unregisterUpdater(LiveLocksViewUpdater updater) {
            this.updaters.remove(updater);
            if (this.updaters.isEmpty()) {
                Collection jdbcCCTProviders = Lookup.getDefault().lookupAll(LockCCTProvider.class);
                assert (!jdbcCCTProviders.isEmpty());
                for (LockCCTProvider provider : jdbcCCTProviders) {
                    provider.removeListener((CCTProvider.Listener)this);
                }
            }
        }

        public final void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
            if (!empty) {
                for (LiveLocksViewUpdater updater : this.updaters) {
                    try {
                        if (!(appRootNode instanceof LockRuntimeCCTNode)) continue;
                        updater.updateData((LockRuntimeCCTNode)appRootNode);
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated ex) {
                        Logger.getLogger(LiveLocksViewUpdater.class.getName()).log(Level.FINE, null, ex);
                    }
                }
            }
        }

        public final void cctReset() {
            for (LiveLocksViewUpdater updater : this.updaters) {
                updater.resetData();
            }
        }
    }
}

