/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.custompages;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.custompages.CustomPage;
import org.zaproxy.zap.extension.custompages.CustomPageTableModel;
import org.zaproxy.zap.extension.custompages.DialogAddCustomPage;
import org.zaproxy.zap.extension.custompages.DialogModifyCustomPage;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;
import org.zaproxy.zap.view.LayoutHelper;

class ContextCustomPagePanel
extends AbstractContextPropertiesPanel {
    protected static final String PREFIX = "custompages";
    private static final long serialVersionUID = -3920598166129639573L;
    private static final String PANEL_NAME = Constant.messages.getString("custompages.panel.title");
    private CustomPagesMultipleOptionsPanel customPagesOptionsPanel;
    private Context context;
    private CustomPageTableModel customPageTableModel;

    public ContextCustomPagePanel(int contextId) {
        super(contextId);
        this.context = Model.getSingleton().getSession().getContext(contextId);
        this.initialize();
    }

    public static String getPanelName(int contextId) {
        return contextId + ": " + PANEL_NAME;
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setName(ContextCustomPagePanel.getPanelName(this.getContextId()));
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel(Constant.messages.getString("custompages.panel.description")), LayoutHelper.getGBC(0, 0, 1, 1.0, 0.0));
        this.customPageTableModel = new CustomPageTableModel();
        this.customPagesOptionsPanel = new CustomPagesMultipleOptionsPanel(this.customPageTableModel);
        this.add((Component)this.customPagesOptionsPanel, LayoutHelper.getGBC(0, 1, 1, 1.0, 1.0));
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.contexts";
    }

    @Override
    public void initContextData(Session session, Context uiCommonContext) {
        this.customPagesOptionsPanel.setWorkingContext(uiCommonContext);
        this.getCustomPagesTableModel().setCustomPages(uiCommonContext.getCustomPages());
    }

    @Override
    public void validateContextData(Session session) throws Exception {
    }

    @Override
    public void saveContextData(Session session) throws Exception {
        this.context.setCustomPages(this.customPageTableModel.getCustomPages());
    }

    @Override
    public void saveTemporaryContextData(Context uiSharedContext) {
    }

    protected CustomPageTableModel getCustomPagesTableModel() {
        return this.customPageTableModel;
    }

    private static class CustomPagesMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<CustomPage> {
        private static final long serialVersionUID = -7216673905642941770L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("custompages.dialog.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("custompages.dialog.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("custompages.dialog.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("custompages.dialog.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("custompages.dialog.remove.checkbox.label");
        private DialogAddCustomPage addDialog = null;
        private DialogModifyCustomPage modifyDialog = null;
        private Context uiSharedContext;

        public CustomPagesMultipleOptionsPanel(CustomPageTableModel model) {
            super(model);
            Component rendererComponent = this.getTable().getColumnExt(0).getHeaderRenderer() == null ? this.getTable().getTableHeader().getDefaultRenderer().getTableCellRendererComponent(null, this.getTable().getColumnExt(0).getHeaderValue(), false, false, 0, 0) : this.getTable().getColumnExt(0).getHeaderRenderer().getTableCellRendererComponent(null, this.getTable().getColumnExt(0).getHeaderValue(), false, false, 0, 0);
            this.getTable().getColumnExt(0).setMaxWidth(rendererComponent.getMaximumSize().width);
            this.getTable().packAll();
        }

        @Override
        public CustomPage showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddCustomPage((Window)View.getSingleton().getSessionDialog());
            }
            this.addDialog.setWorkingContext(this.uiSharedContext);
            this.addDialog.setVisible(true);
            CustomPage customPage = this.addDialog.getCustomPage();
            this.addDialog.clear();
            return customPage;
        }

        @Override
        public CustomPage showModifyDialogue(CustomPage customPage) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyCustomPage(View.getSingleton().getSessionDialog());
            }
            this.modifyDialog.setWorkingContext(this.uiSharedContext);
            this.modifyDialog.setCustomPage(customPage);
            this.modifyDialog.setVisible(true);
            customPage = this.modifyDialog.getCustomPage();
            this.modifyDialog.clear();
            return customPage;
        }

        @Override
        public boolean showRemoveDialogue(CustomPage customPage) {
            JCheckBox removeWithoutConfirmationCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] messages = new Object[]{REMOVE_DIALOG_TEXT, " ", removeWithoutConfirmationCheckBox};
            int option = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), messages, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (option == 0) {
                this.setRemoveWithoutConfirmation(removeWithoutConfirmationCheckBox.isSelected());
                return true;
            }
            return false;
        }

        protected void setWorkingContext(Context context) {
            this.uiSharedContext = context;
        }
    }
}

