##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# https://www.morningstarsecurity.com/research/whatweb
##
Plugin.define do
name "BloofoxCMS"
authors [
  "Brendan Coles <bcoles@gmail.com>", # 2011-02-27
]
version "0.1"
description "bloofoxCMS is a free open source content management system (CMS). bloofoxCMS is a small and easy to use CMS."
website "http://bloofox.com/"

# Google results as at 2011-02-27 #
# 167 for "Powered by bloofoxCMS"

# Dorks #
dorks [
'"Powered by bloofoxCMS"'
]



# Matches #
matches [

# Version Detection # Meta Generator
{ :version=>/<meta name="generator" content="bloofoxCMS ([\d\.]+)" \/>/ },

# Default HTML comment
{ :regexp=>/<!--[\r\n\s]+This Website was generated by bloofoxCMS.[\r\n\s]+bloofoxCMS is open source published under the gnu gpl. Visit www.bloofox.com for more details![\r\n\s]+Copyrights \(c\) 2006-2007 by Alexander Lang[\r\n\s]+\/\/-->/ },

# Powered by text # Case insensitive because older versions use capitalized tags
{ :regexp=>/Powered by <a href="http:\/\/www.bloofox.com">bloofoxCMS<\/a>/i },

]

end


