/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import twitter4j.AccountSettings;
import twitter4j.Category;
import twitter4j.DirectMessage;
import twitter4j.Friendship;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.IDs;
import twitter4j.Location;
import twitter4j.OEmbed;
import twitter4j.OEmbedRequest;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.RelatedResults;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.SavedSearch;
import twitter4j.SimilarPlaces;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Trends;
import twitter4j.Twitter;
import twitter4j.TwitterAPIConfiguration;
import twitter4j.TwitterAPIMonitor;
import twitter4j.TwitterBaseImpl;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.api.HelpResources;
import twitter4j.auth.Authorization;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpParameter;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.util.z_T4JInternalStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TwitterImpl
extends TwitterBaseImpl
implements Twitter {
    private static final long serialVersionUID = -1486360080128882436L;
    private final String IMPLICIT_PARAMS_STR;
    private final HttpParameter[] IMPLICIT_PARAMS;
    private final HttpParameter INCLUDE_MY_RETWEET;
    private static final Map<Configuration, HttpParameter[]> implicitParamsMap = new HashMap<Configuration, HttpParameter[]>();
    private static final Map<Configuration, String> implicitParamsStrMap = new HashMap<Configuration, String>();

    TwitterImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.INCLUDE_MY_RETWEET = new HttpParameter("include_my_retweet", conf.isIncludeMyRetweetEnabled());
        HttpParameter[] implicitParams = implicitParamsMap.get(conf);
        String implicitParamsStr = implicitParamsStrMap.get(conf);
        if (implicitParams == null) {
            String includeEntities = conf.isIncludeEntitiesEnabled() ? "1" : "0";
            String includeRTs = conf.isIncludeRTsEnabled() ? "1" : "0";
            boolean contributorsEnabled = conf.getContributingTo() != -1L;
            implicitParamsStr = "include_entities=" + includeEntities + "&include_rts=" + includeRTs + (contributorsEnabled ? "&contributingto=" + conf.getContributingTo() : "");
            implicitParamsStrMap.put(conf, implicitParamsStr);
            ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
            params.add(new HttpParameter("include_entities", includeEntities));
            params.add(new HttpParameter("include_rts", includeRTs));
            if (contributorsEnabled) {
                params.add(new HttpParameter("contributingto", conf.getContributingTo()));
            }
            implicitParams = params.toArray(new HttpParameter[params.size()]);
            implicitParamsMap.put(conf, implicitParams);
        }
        this.IMPLICIT_PARAMS = implicitParams;
        this.IMPLICIT_PARAMS_STR = implicitParamsStr;
    }

    @Override
    public ResponseList<Status> getMentions() throws TwitterException {
        return this.getMentionsTimeline();
    }

    @Override
    public ResponseList<Status> getMentionsTimeline() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/mentions_timeline.json"));
    }

    @Override
    public ResponseList<Status> getMentions(Paging paging) throws TwitterException {
        return this.getMentionsTimeline(paging);
    }

    @Override
    public ResponseList<Status> getMentionsTimeline(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/mentions_timeline.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getHomeTimeline() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/home_timeline.json", new HttpParameter[]{this.INCLUDE_MY_RETWEET}));
    }

    @Override
    public ResponseList<Status> getHomeTimeline(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/home_timeline.json", this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{this.INCLUDE_MY_RETWEET})));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets_of_me.json"));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets_of_me.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", screenName), this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getUserTimeline(long userId, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId), this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName) throws TwitterException {
        return this.getUserTimeline(screenName, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(long userId) throws TwitterException {
        return this.getUserTimeline(userId, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline() throws TwitterException {
        return this.getUserTimeline(new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getRetweets(long statusId) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets/" + statusId + ".json?count=100"));
    }

    @Override
    public Status showStatus(long id) throws TwitterException {
        return this.factory.createStatus(this.get(this.conf.getRestBaseURL() + "statuses/show/" + id + ".json"));
    }

    @Override
    public Status destroyStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/destroy/" + statusId + ".json"));
    }

    @Override
    public Status updateStatus(String status) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/update.json", new HttpParameter[]{new HttpParameter("status", status)}));
    }

    @Override
    public Status updateStatus(StatusUpdate status) throws TwitterException {
        String url = this.conf.getRestBaseURL() + (status.isWithMedia() ? "statuses/update_with_media.json" : "statuses/update.json");
        return this.factory.createStatus(this.post(url, status.asHttpParameterArray()));
    }

    @Override
    public Status retweetStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/retweet/" + statusId + ".json"));
    }

    @Override
    public OEmbed getOEmbed(OEmbedRequest req) throws TwitterException {
        return this.factory.createOEmbed(this.get(this.conf.getRestBaseURL() + "statuses/oembed.json", req.asHttpParameterArray()));
    }

    @Override
    public QueryResult search(Query query) throws TwitterException {
        if (query.nextPage() != null) {
            return this.factory.createQueryResult(this.get(this.conf.getRestBaseURL() + "search/tweets.json" + query.nextPage()), query);
        }
        return this.factory.createQueryResult(this.get(this.conf.getRestBaseURL() + "search/tweets.json", query.asHttpParameterArray()), query);
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages() throws TwitterException {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages.json"));
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages(Paging paging) throws TwitterException {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages() throws TwitterException {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages/sent.json"));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages(Paging paging) throws TwitterException {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages/sent.json", paging.asPostParameterArray()));
    }

    @Override
    public DirectMessage showDirectMessage(long id) throws TwitterException {
        return this.factory.createDirectMessage(this.get(this.conf.getRestBaseURL() + "direct_messages/show.json?id=" + id));
    }

    @Override
    public DirectMessage destroyDirectMessage(long id) throws TwitterException {
        return this.factory.createDirectMessage(this.post(this.conf.getRestBaseURL() + "direct_messages/destroy.json?id=" + id));
    }

    @Override
    public DirectMessage sendDirectMessage(long userId, String text) throws TwitterException {
        return this.factory.createDirectMessage(this.post(this.conf.getRestBaseURL() + "direct_messages/new.json", new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("text", text)}));
    }

    @Override
    public DirectMessage sendDirectMessage(String screenName, String text) throws TwitterException {
        return this.factory.createDirectMessage(this.post(this.conf.getRestBaseURL() + "direct_messages/new.json", new HttpParameter[]{new HttpParameter("screen_name", screenName), new HttpParameter("text", text)}));
    }

    @Override
    public IDs getFriendsIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?cursor=" + cursor));
    }

    @Override
    public IDs getFriendsIDs(long userId, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?user_id=" + userId + "&cursor=" + cursor));
    }

    @Override
    public IDs getFriendsIDs(String screenName, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?screen_name=" + screenName + "&cursor=" + cursor));
    }

    @Override
    public IDs getFollowersIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?cursor=" + cursor));
    }

    @Override
    public IDs getFollowersIDs(long userId, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?user_id=" + userId + "&cursor=" + cursor));
    }

    @Override
    public IDs getFollowersIDs(String screenName, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?screen_name=" + screenName + "&cursor=" + cursor));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(long[] ids) throws TwitterException {
        return this.factory.createFriendshipList(this.get(this.conf.getRestBaseURL() + "friendships/lookup.json?user_id=" + z_T4JInternalStringUtil.join(ids)));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(String[] screenNames) throws TwitterException {
        return this.factory.createFriendshipList(this.get(this.conf.getRestBaseURL() + "friendships/lookup.json?screen_name=" + z_T4JInternalStringUtil.join(screenNames)));
    }

    @Override
    public IDs getIncomingFriendships(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friendships/incoming.json?cursor=" + cursor));
    }

    @Override
    public IDs getOutgoingFriendships(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friendships/outgoing.json?cursor=" + cursor));
    }

    @Override
    public User createFriendship(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json?user_id=" + userId));
    }

    @Override
    public User createFriendship(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json?screen_name=" + screenName));
    }

    @Override
    public User createFriendship(long userId, boolean follow) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json?user_id=" + userId + "&follow=" + follow));
    }

    @Override
    public User createFriendship(String screenName, boolean follow) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json?screen_name=" + screenName + "&follow=" + follow));
    }

    @Override
    public User destroyFriendship(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyFriendship(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/destroy.json?screen_name=" + screenName));
    }

    @Override
    public Relationship updateFriendship(long userId, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        return this.factory.createRelationship(this.post(this.conf.getRestBaseURL() + "friendships/update.json", new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", retweets)}));
    }

    @Override
    public Relationship updateFriendship(String screenName, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        return this.factory.createRelationship(this.post(this.conf.getRestBaseURL() + "friendships/update.json", new HttpParameter[]{new HttpParameter("screen_name", screenName), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", enableDeviceNotification)}));
    }

    @Override
    public Relationship showFriendship(long sourceId, long targetId) throws TwitterException {
        return this.factory.createRelationship(this.get(this.conf.getRestBaseURL() + "friendships/show.json", new HttpParameter[]{new HttpParameter("source_id", sourceId), new HttpParameter("target_id", targetId)}));
    }

    @Override
    public Relationship showFriendship(String sourceScreenName, String targetScreenName) throws TwitterException {
        return this.factory.createRelationship(this.get(this.conf.getRestBaseURL() + "friendships/show.json", HttpParameter.getParameterArray("source_screen_name", sourceScreenName, "target_screen_name", targetScreenName)));
    }

    @Override
    public PagableResponseList<User> getFriendsList(long userId, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json?user_id=" + userId + "&cursor=" + cursor));
    }

    @Override
    public PagableResponseList<User> getFriendsList(String screenName, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json?screen_name=" + screenName + "&cursor=" + cursor));
    }

    @Override
    public PagableResponseList<User> getFollowersList(long userId, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json?user_id=" + userId + "&cursor=" + cursor));
    }

    @Override
    public PagableResponseList<User> getFollowersList(String screenName, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json?screen_name=" + screenName + "&cursor=" + cursor));
    }

    @Override
    public AccountSettings getAccountSettings() throws TwitterException {
        return this.factory.createAccountSettings(this.get(this.conf.getRestBaseURL() + "account/settings.json"));
    }

    @Override
    public User verifyCredentials() throws TwitterException {
        return super.fillInIDAndScreenName();
    }

    @Override
    public AccountSettings updateAccountSettings(Integer trend_locationWoeid, Boolean sleep_timeEnabled, String start_sleepTime, String end_sleepTime, String time_zone, String lang) throws TwitterException {
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(6);
        if (trend_locationWoeid != null) {
            profile.add(new HttpParameter("trend_location_woeid", trend_locationWoeid));
        }
        if (sleep_timeEnabled != null) {
            profile.add(new HttpParameter("sleep_time_enabled", sleep_timeEnabled.toString()));
        }
        if (start_sleepTime != null) {
            profile.add(new HttpParameter("start_sleep_time", start_sleepTime));
        }
        if (end_sleepTime != null) {
            profile.add(new HttpParameter("end_sleep_time", end_sleepTime));
        }
        if (time_zone != null) {
            profile.add(new HttpParameter("time_zone", time_zone));
        }
        if (lang != null) {
            profile.add(new HttpParameter("lang", lang));
        }
        return this.factory.createAccountSettings(this.post(this.conf.getRestBaseURL() + "account/settings.json", profile.toArray(new HttpParameter[profile.size()])));
    }

    @Override
    public User updateProfile(String name, String url, String location, String description) throws TwitterException {
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(4);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile.json", profile.toArray(new HttpParameter[profile.size()])));
    }

    @Override
    public User updateProfileBackgroundImage(File image, boolean tile) throws TwitterException {
        this.checkFileValidity(image);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_background_image.json", new HttpParameter[]{new HttpParameter("image", image), new HttpParameter("tile", tile)}));
    }

    @Override
    public User updateProfileBackgroundImage(InputStream image, boolean tile) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_background_image.json", new HttpParameter[]{new HttpParameter("image", "image", image), new HttpParameter("tile", tile)}));
    }

    @Override
    public User updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) throws TwitterException {
        ArrayList<HttpParameter> colors = new ArrayList<HttpParameter>(6);
        this.addParameterToList(colors, "profile_background_color", profileBackgroundColor);
        this.addParameterToList(colors, "profile_text_color", profileTextColor);
        this.addParameterToList(colors, "profile_link_color", profileLinkColor);
        this.addParameterToList(colors, "profile_sidebar_fill_color", profileSidebarFillColor);
        this.addParameterToList(colors, "profile_sidebar_border_color", profileSidebarBorderColor);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_colors.json", colors.toArray(new HttpParameter[colors.size()])));
    }

    private void addParameterToList(List<HttpParameter> colors, String paramName, String color) {
        if (color != null) {
            colors.add(new HttpParameter(paramName, color));
        }
    }

    @Override
    public User updateProfileImage(File image) throws TwitterException {
        this.checkFileValidity(image);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_image.json", new HttpParameter[]{new HttpParameter("image", image)}));
    }

    @Override
    public User updateProfileImage(InputStream image) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_image.json", new HttpParameter[]{new HttpParameter("image", "image", image)}));
    }

    private void checkFileValidity(File image) throws TwitterException {
        if (!image.exists()) {
            throw new TwitterException(new FileNotFoundException(image + " is not found."));
        }
        if (!image.isFile()) {
            throw new TwitterException(new IOException(image + " is not a file."));
        }
    }

    @Override
    public PagableResponseList<User> getBlocksList() throws TwitterException {
        return this.getBlocksList(-1L);
    }

    @Override
    public PagableResponseList<User> getBlocksList(long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "blocks/list.json?cursor=" + cursor));
    }

    @Override
    public IDs getBlocksIDs() throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "blocks/ids.json"));
    }

    @Override
    public IDs getBlocksIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "blocks/ids.json?cursor=" + cursor));
    }

    @Override
    public User createBlock(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/create.json?user_id=" + userId));
    }

    @Override
    public User createBlock(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/create.json?screen_name=" + screenName));
    }

    @Override
    public User destroyBlock(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyBlock(String screen_name) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/destroy.json?screen_name=" + screen_name));
    }

    @Override
    public ResponseList<User> lookupUsers(long[] ids) throws TwitterException {
        return this.factory.createUserList(this.post(this.conf.getRestBaseURL() + "users/lookup.json", new HttpParameter[]{new HttpParameter("user_id", z_T4JInternalStringUtil.join(ids))}));
    }

    @Override
    public ResponseList<User> lookupUsers(String[] screenNames) throws TwitterException {
        return this.factory.createUserList(this.post(this.conf.getRestBaseURL() + "users/lookup.json", new HttpParameter[]{new HttpParameter("screen_name", z_T4JInternalStringUtil.join(screenNames))}));
    }

    @Override
    public User showUser(long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "users/show.json?user_id=" + userId));
    }

    @Override
    public User showUser(String screenName) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "users/show.json?screen_name=" + screenName));
    }

    @Override
    public ResponseList<User> searchUsers(String query, int page) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/search.json", new HttpParameter[]{new HttpParameter("q", query), new HttpParameter("per_page", 20), new HttpParameter("page", page)}));
    }

    @Override
    public ResponseList<User> getContributees(long userId) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributees.json?user_id=" + userId));
    }

    @Override
    public ResponseList<User> getContributees(String screenName) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributees.json?screen_name=" + screenName));
    }

    @Override
    public ResponseList<User> getContributors(long userId) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributors.json?user_id=" + userId));
    }

    @Override
    public ResponseList<User> getContributors(String screenName) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributors.json?screen_name=" + screenName));
    }

    @Override
    public void removeProfileBanner() throws TwitterException {
        this.post(this.conf.getRestBaseURL() + "account/remove_profile_banner.json");
    }

    @Override
    public void updateProfileBanner(File image) throws TwitterException {
        this.checkFileValidity(image);
        this.post(this.conf.getRestBaseURL() + "account/update_profile_banner.json", new HttpParameter[]{new HttpParameter("banner", image)});
    }

    @Override
    public void updateProfileBanner(InputStream image) throws TwitterException {
        this.post(this.conf.getRestBaseURL() + "account/update_profile_banner.json", new HttpParameter[]{new HttpParameter("banner", "banner", image)});
    }

    @Override
    public ResponseList<User> getUserSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res = null;
        try {
            res = this.get(this.conf.getRestBaseURL() + "users/suggestions/" + URLEncoder.encode(categorySlug, "UTF-8") + ".json");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.factory.createUserListFromJSONArray_Users(res);
    }

    @Override
    public ResponseList<Category> getSuggestedUserCategories() throws TwitterException {
        return this.factory.createCategoryList(this.get(this.conf.getRestBaseURL() + "users/suggestions.json"));
    }

    @Override
    public ResponseList<User> getMemberSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res = null;
        try {
            res = this.get(this.conf.getRestBaseURL() + "users/suggestions/" + URLEncoder.encode(categorySlug, "UTF-8") + "/members.json");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.factory.createUserListFromJSONArray(res);
    }

    @Override
    public ResponseList<Status> getFavorites() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json"));
    }

    @Override
    public ResponseList<Status> getFavorites(long userId) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json?user_id=" + userId));
    }

    @Override
    public ResponseList<Status> getFavorites(String screenName) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json?screen_name=" + screenName));
    }

    @Override
    public ResponseList<Status> getFavorites(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getFavorites(long userId, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId)}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getFavorites(String screenName, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", screenName)}, paging.asPostParameterArray())));
    }

    @Override
    public Status destroyFavorite(long id) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "favorites/destroy.json?id=" + id));
    }

    @Override
    public Status createFavorite(long id) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "favorites/create.json?id=" + id));
    }

    @Override
    public ResponseList<UserList> getUserLists(String listOwnerScreenName) throws TwitterException {
        return this.factory.createUserListList(this.get(this.conf.getRestBaseURL() + "lists/list.json?screen_name=" + listOwnerScreenName));
    }

    @Override
    public ResponseList<UserList> getUserLists(long listOwnerUserId) throws TwitterException {
        return this.factory.createUserListList(this.get(this.conf.getRestBaseURL() + "lists/list.json?user_id=" + listOwnerUserId));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(int listId, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter("list_id", listId))));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(long ownerId, String slug, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter[]{new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)})));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(String ownerScreenName, String slug, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter[]{new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)})));
    }

    @Override
    public UserList destroyUserListMember(int listId, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter[]{new HttpParameter("list_id", listId), new HttpParameter("user_id", userId)}));
    }

    @Override
    public UserList deleteUserListMember(int listId, long userId) throws TwitterException {
        return this.destroyUserListMember(listId, userId);
    }

    @Override
    public UserList destroyUserListMember(long ownerId, String slug, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter[]{new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug), new HttpParameter("user_id", userId)}));
    }

    @Override
    public UserList destroyUserListMember(String ownerScreenName, String slug, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter[]{new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("user_id", userId)}));
    }

    @Override
    public UserList deleteUserListMember(long ownerId, String slug, long userId) throws TwitterException {
        return this.destroyUserListMember(ownerId, slug, userId);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long cursor) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json?cursor=" + cursor));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listMemberScreenName, long cursor) throws TwitterException {
        return this.getUserListMemberships(listMemberScreenName, cursor, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long listMemberId, long cursor) throws TwitterException {
        return this.getUserListMemberships(listMemberId, cursor, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long listMemberId, long cursor, boolean filterToOwnedLists) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json?user_id=" + listMemberId + "&cursor=" + cursor + "&filter_to_owned_lists=" + filterToOwnedLists));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listMemberScreenName, long cursor, boolean filterToOwnedLists) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json?screen_name=" + listMemberScreenName + "&cursor=" + cursor + "&filter_to_owned_lists=" + filterToOwnedLists));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(int listId, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json?list_id=" + listId + "&cursor=" + cursor));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long ownerId, String slug, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json?owner_id=" + ownerId + "&slug=" + slug + "&cursor=" + cursor));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String ownerScreenName, String slug, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json?owner_screen_name=" + ownerScreenName + "&slug=" + slug + "&cursor=" + cursor));
    }

    @Override
    public UserList createUserListSubscription(int listId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter[]{new HttpParameter("list_id", listId)}));
    }

    @Override
    public UserList createUserListSubscription(long ownerId, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter[]{new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)}));
    }

    @Override
    public UserList createUserListSubscription(String ownerScreenName, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter[]{new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)}));
    }

    @Override
    public User showUserListSubscription(int listId, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json?list_id=" + listId + "&user_id=" + userId));
    }

    @Override
    public User showUserListSubscription(long ownerId, String slug, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json?owner_id=" + ownerId + "&slug=" + slug + "&user_id=" + userId));
    }

    @Override
    public User showUserListSubscription(String ownerScreenName, String slug, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json?owner_screen_name=" + ownerScreenName + "&slug=" + slug + "&user_id=" + userId));
    }

    @Override
    public UserList destroyUserListSubscription(int listId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter[]{new HttpParameter("list_id", listId)}));
    }

    @Override
    public UserList destroyUserListSubscription(long ownerId, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter[]{new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)}));
    }

    @Override
    public UserList destroyUserListSubscription(String ownerScreenName, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter[]{new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)}));
    }

    @Override
    public UserList createUserListMembers(int listId, long[] userIds) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter[]{new HttpParameter("list_id", listId), new HttpParameter("user_id", z_T4JInternalStringUtil.join(userIds))}));
    }

    @Override
    public UserList addUserListMembers(int listId, long[] userIds) throws TwitterException {
        return this.createUserListMembers(listId, userIds);
    }

    @Override
    public UserList createUserListMembers(long ownerId, String slug, long[] userIds) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter[]{new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug), new HttpParameter("user_id", z_T4JInternalStringUtil.join(userIds))}));
    }

    @Override
    public UserList createUserListMembers(String ownerScreenName, String slug, long[] userIds) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter[]{new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("user_id", z_T4JInternalStringUtil.join(userIds))}));
    }

    @Override
    public UserList addUserListMembers(long ownerId, String slug, long[] userIds) throws TwitterException {
        return this.createUserListMembers(ownerId, slug, userIds);
    }

    @Override
    public UserList createUserListMembers(int listId, String[] screenNames) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter[]{new HttpParameter("list_id", listId), new HttpParameter("screen_name", z_T4JInternalStringUtil.join(screenNames))}));
    }

    @Override
    public UserList addUserListMembers(int listId, String[] screenNames) throws TwitterException {
        return this.createUserListMembers(listId, screenNames);
    }

    @Override
    public UserList createUserListMembers(long ownerId, String slug, String[] screenNames) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter[]{new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug), new HttpParameter("screen_name", z_T4JInternalStringUtil.join(screenNames))}));
    }

    @Override
    public UserList createUserListMembers(String ownerScreenName, String slug, String[] screenNames) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter[]{new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("screen_name", z_T4JInternalStringUtil.join(screenNames))}));
    }

    @Override
    public UserList addUserListMembers(long ownerId, String slug, String[] screenNames) throws TwitterException {
        return this.createUserListMembers(ownerId, slug, screenNames);
    }

    @Override
    public User showUserListMembership(int listId, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json?list_id=" + listId + "&user_id=" + userId));
    }

    @Override
    public User showUserListMembership(long ownerId, String slug, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json?owner_id=" + ownerId + "&slug=" + slug + "&user_id=" + userId));
    }

    @Override
    public User showUserListMembership(String ownerScreenName, String slug, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json?owner_screen_name=" + ownerScreenName + "&slug=" + slug + "&user_id=" + userId));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(int listId, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json?list_id=" + listId + "&cursor=" + cursor));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long ownerId, String slug, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json?owner_id=" + ownerId + "&slug=" + slug + "&cursor=" + cursor));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String ownerScreenName, String slug, long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json?owner_screen_name=" + ownerScreenName + "&slug=" + slug + "&cursor=" + cursor));
    }

    @Override
    public UserList createUserListMember(int listId, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("list_id", listId)}));
    }

    @Override
    public UserList addUserListMember(int listId, long userId) throws TwitterException {
        return null;
    }

    @Override
    public UserList createUserListMember(long ownerId, String slug, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)}));
    }

    @Override
    public UserList createUserListMember(String ownerScreenName, String slug, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter[]{new HttpParameter("user_id", userId), new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)}));
    }

    @Override
    public UserList addUserListMember(long ownerId, String slug, long userId) throws TwitterException {
        return null;
    }

    @Override
    public UserList destroyUserList(int listId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter[]{new HttpParameter("list_id", listId)}));
    }

    @Override
    public UserList destroyUserList(long ownerId, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter[]{new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)}));
    }

    @Override
    public UserList destroyUserList(String ownerScreenName, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter[]{new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)}));
    }

    @Override
    public UserList updateUserList(int listId, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        return this.updateUserList(newListName, isPublicList, newDescription, new HttpParameter("list_id", listId));
    }

    @Override
    public UserList updateUserList(long ownerId, String slug, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        return this.updateUserList(newListName, isPublicList, newDescription, new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug));
    }

    @Override
    public UserList updateUserList(String ownerScreenName, String slug, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        return this.updateUserList(newListName, isPublicList, newDescription, new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug));
    }

    private UserList updateUserList(String newListName, boolean isPublicList, String newDescription, HttpParameter ... params) throws TwitterException {
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        Collections.addAll(httpParams, params);
        if (newListName != null) {
            httpParams.add(new HttpParameter("name", newListName));
        }
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (newDescription != null) {
            httpParams.add(new HttpParameter("description", newDescription));
        }
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/update.json", httpParams.toArray(new HttpParameter[httpParams.size()])));
    }

    @Override
    public UserList createUserList(String listName, boolean isPublicList, String description) throws TwitterException {
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(new HttpParameter("name", listName));
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (description != null) {
            httpParams.add(new HttpParameter("description", description));
        }
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/create.json", httpParams.toArray(new HttpParameter[httpParams.size()])));
    }

    @Override
    public UserList showUserList(int listId) throws TwitterException {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json?list_id=" + listId));
    }

    @Override
    public UserList showUserList(long ownerId, String slug) throws TwitterException {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json?owner_id=" + ownerId + "&slug=" + slug));
    }

    @Override
    public UserList showUserList(String ownerScreenName, String slug) throws TwitterException {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json?owner_screen_name=" + ownerScreenName + "&slug=" + slug));
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(String listOwnerScreenName, long cursor) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/subscriptions.json?screen_name=" + listOwnerScreenName + "&cursor=" + cursor));
    }

    @Override
    public ResponseList<SavedSearch> getSavedSearches() throws TwitterException {
        return this.factory.createSavedSearchList(this.get(this.conf.getRestBaseURL() + "saved_searches/list.json"));
    }

    @Override
    public SavedSearch showSavedSearch(int id) throws TwitterException {
        return this.factory.createSavedSearch(this.get(this.conf.getRestBaseURL() + "saved_searches/show/" + id + ".json"));
    }

    @Override
    public SavedSearch createSavedSearch(String query) throws TwitterException {
        return this.factory.createSavedSearch(this.post(this.conf.getRestBaseURL() + "saved_searches/create.json", new HttpParameter[]{new HttpParameter("query", query)}));
    }

    @Override
    public SavedSearch destroySavedSearch(int id) throws TwitterException {
        return this.factory.createSavedSearch(this.post(this.conf.getRestBaseURL() + "saved_searches/destroy/" + id + ".json"));
    }

    @Override
    public Place getGeoDetails(String placeId) throws TwitterException {
        return this.factory.createPlace(this.get(this.conf.getRestBaseURL() + "geo/id/" + placeId + ".json"));
    }

    @Override
    public ResponseList<Place> reverseGeoCode(GeoQuery query) throws TwitterException {
        try {
            return this.factory.createPlaceList(this.get(this.conf.getRestBaseURL() + "geo/reverse_geocode.json", query.asHttpParameterArray()));
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return this.factory.createEmptyResponseList();
            }
            throw te;
        }
    }

    @Override
    public ResponseList<Place> searchPlaces(GeoQuery query) throws TwitterException {
        return this.factory.createPlaceList(this.get(this.conf.getRestBaseURL() + "geo/search.json", query.asHttpParameterArray()));
    }

    @Override
    public SimilarPlaces getSimilarPlaces(GeoLocation location, String name, String containedWithin, String streetAddress) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
        params.add(new HttpParameter("lat", location.getLatitude()));
        params.add(new HttpParameter("long", location.getLongitude()));
        params.add(new HttpParameter("name", name));
        if (containedWithin != null) {
            params.add(new HttpParameter("contained_within", containedWithin));
        }
        if (streetAddress != null) {
            params.add(new HttpParameter("attribute:street_address", streetAddress));
        }
        return this.factory.createSimilarPlaces(this.get(this.conf.getRestBaseURL() + "geo/similar_places.json", params.toArray(new HttpParameter[params.size()])));
    }

    @Override
    public Place createPlace(String name, String containedWithin, String token, GeoLocation location, String streetAddress) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
        params.add(new HttpParameter("name", name));
        params.add(new HttpParameter("contained_within", containedWithin));
        params.add(new HttpParameter("token", token));
        params.add(new HttpParameter("lat", location.getLatitude()));
        params.add(new HttpParameter("long", location.getLongitude()));
        if (streetAddress != null) {
            params.add(new HttpParameter("attribute:street_address", streetAddress));
        }
        return this.factory.createPlace(this.post(this.conf.getRestBaseURL() + "geo/place.json", params.toArray(new HttpParameter[params.size()])));
    }

    @Override
    public Trends getLocationTrends(int woeid) throws TwitterException {
        return this.getPlaceTrends(woeid);
    }

    @Override
    public Trends getPlaceTrends(int woeid) throws TwitterException {
        return this.factory.createTrends(this.get(this.conf.getRestBaseURL() + "trends/place.json?id=" + woeid));
    }

    @Override
    public ResponseList<Location> getAvailableTrends() throws TwitterException {
        return this.factory.createLocationList(this.get(this.conf.getRestBaseURL() + "trends/available.json"));
    }

    @Override
    public ResponseList<Location> getAvailableTrends(GeoLocation location) throws TwitterException {
        return this.getClosestTrends(location);
    }

    @Override
    public ResponseList<Location> getClosestTrends(GeoLocation location) throws TwitterException {
        return this.factory.createLocationList(this.get(this.conf.getRestBaseURL() + "trends/closest.json", new HttpParameter[]{new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude())}));
    }

    @Override
    public User reportSpam(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "users/report_spam.json?user_id=" + userId));
    }

    @Override
    public User reportSpam(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "users/report_spam.json?screen_name=" + screenName));
    }

    @Override
    public TwitterAPIConfiguration getAPIConfiguration() throws TwitterException {
        return this.factory.createTwitterAPIConfiguration(this.get(this.conf.getRestBaseURL() + "help/configuration.json"));
    }

    @Override
    public ResponseList<HelpResources.Language> getLanguages() throws TwitterException {
        return this.factory.createLanguageList(this.get(this.conf.getRestBaseURL() + "help/languages.json"));
    }

    @Override
    public String getPrivacyPolicy() throws TwitterException {
        try {
            return this.get(this.conf.getRestBaseURL() + "help/privacy.json").asJSONObject().getString("privacy");
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public String getTermsOfService() throws TwitterException {
        try {
            return this.get(this.conf.getRestBaseURL() + "help/tos.json").asJSONObject().getString("tos");
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public Map<String, RateLimitStatus> getRateLimitStatus() throws TwitterException {
        return this.factory.createRateLimitStatuses(this.get(this.conf.getRestBaseURL() + "application/rate_limit_status.json"));
    }

    @Override
    public Map<String, RateLimitStatus> getRateLimitStatus(String ... resources) throws TwitterException {
        return this.factory.createRateLimitStatuses(this.get(this.conf.getRestBaseURL() + "application/rate_limit_status.json?resources=" + z_T4JInternalStringUtil.join(resources)));
    }

    @Override
    public RelatedResults getRelatedResults(long statusId) throws TwitterException {
        return this.factory.createRelatedResults(this.get("https://api.twitter.com/1/related_results/show.json?id=" + Long.toString(statusId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        url = url.contains("?") ? url + "&" + this.IMPLICIT_PARAMS_STR : url + "?" + this.IMPLICIT_PARAMS_STR;
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, this.mergeImplicitParams(params), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.mergeImplicitParams(params), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.IMPLICIT_PARAMS, this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.IMPLICIT_PARAMS, this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url, HttpParameter[] params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.mergeImplicitParams(params), this.auth);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.mergeImplicitParams(params), this.auth);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter[] params2) {
        if (params1 != null && params2 != null) {
            HttpParameter[] params = new HttpParameter[params1.length + params2.length];
            System.arraycopy(params1, 0, params, 0, params1.length);
            System.arraycopy(params2, 0, params, params1.length, params2.length);
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (params1 != null) {
            return params1;
        }
        return params2;
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter params2) {
        if (params1 != null && params2 != null) {
            HttpParameter[] params = new HttpParameter[params1.length + 1];
            System.arraycopy(params1, 0, params, 0, params1.length);
            params[params.length - 1] = params2;
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (params1 != null) {
            return params1;
        }
        return new HttpParameter[]{params2};
    }

    private HttpParameter[] mergeImplicitParams(HttpParameter[] params) {
        return this.mergeParameters(params, this.IMPLICIT_PARAMS);
    }

    private boolean isOk(HttpResponse response) {
        return response != null && response.getStatusCode() < 300;
    }

    @Override
    public String toString() {
        return "TwitterImpl{INCLUDE_MY_RETWEET=" + this.INCLUDE_MY_RETWEET + '}';
    }
}

