/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.metaserver.ServerInfo;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.common.networking.ServerInfoMessage;

public final class ServerListMessage
extends ObjectMessage {
    public static final String TAG = "serverList";
    private List<ServerInfo> servers = new ArrayList<ServerInfo>();

    public ServerListMessage() {
        super(TAG);
        this.servers.clear();
    }

    public ServerListMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this();
        ArrayList<ServerInfo> svs = new ArrayList<ServerInfo>();
        while (xr.moreTags()) {
            String tag = xr.getLocalName();
            if ("serverInfo".equals(tag)) {
                svs.add(new ServerInfoMessage(tag, game, xr).getServerInfo());
                continue;
            }
            this.expected("serverInfo", tag);
        }
        xr.expectTag(TAG);
        this.addServers(svs);
    }

    @Override
    public void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        for (ServerInfo si : this.servers) {
            new ServerInfoMessage("serverInfo", si).toXML(xw);
        }
    }

    public List<ServerInfo> getServers() {
        return this.servers;
    }

    public ServerListMessage addServer(ServerInfo si) {
        this.servers.add(si);
        return this;
    }

    public ServerListMessage addServers(List<ServerInfo> lsi) {
        this.servers.addAll(lsi);
        return this;
    }
}

