/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.tooling;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.compile.CompileJavaBuildOperationType;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.build.event.OperationResultPostProcessor;
import org.gradle.internal.build.event.types.AbstractTaskResult;
import org.gradle.internal.build.event.types.DefaultAnnotationProcessorResult;
import org.gradle.internal.build.event.types.DefaultJavaCompileTaskSuccessResult;
import org.gradle.internal.build.event.types.DefaultTaskSuccessResult;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalJavaCompileTaskOperationResult;

public class JavaCompileTaskSuccessResultPostProcessor
implements OperationResultPostProcessor {
    private static final Logger LOGGER = Logging.getLogger(JavaCompileTaskSuccessResultPostProcessor.class);
    private final Map<String, CompileJavaBuildOperationType.Result> results = new ConcurrentHashMap<String, CompileJavaBuildOperationType.Result>();

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        if (finishEvent.getResult() instanceof CompileJavaBuildOperationType.Result) {
            CompileJavaBuildOperationType.Result result = (CompileJavaBuildOperationType.Result)finishEvent.getResult();
            CompileJavaBuildOperationType.Details details = (CompileJavaBuildOperationType.Details)buildOperation.getDetails();
            if (details == null) {
                throw new IllegalStateException("No details for " + buildOperation.getDisplayName() + ", which is required for proper result tracking");
            }
            this.results.put(details.getTaskIdentityPath(), result);
        }
    }

    public AbstractTaskResult process(AbstractTaskResult taskResult, TaskInternal taskInternal) {
        CompileJavaBuildOperationType.Result compileResult = this.results.remove(taskInternal.getIdentityPath().getPath());
        if (taskResult instanceof DefaultTaskSuccessResult) {
            if (compileResult != null) {
                return new DefaultJavaCompileTaskSuccessResult((DefaultTaskSuccessResult)taskResult, this.toAnnotationProcessorResults(compileResult.getAnnotationProcessorDetails()));
            }
            if (taskInternal instanceof JavaCompile) {
                LOGGER.info("No compile result for " + taskInternal.getIdentityPath());
            }
        }
        return taskResult;
    }

    private List<InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult> toAnnotationProcessorResults(List<CompileJavaBuildOperationType.Result.AnnotationProcessorDetails> allDetails) {
        if (allDetails == null) {
            return null;
        }
        ArrayList<InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult> results = new ArrayList<InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult>(allDetails.size());
        for (CompileJavaBuildOperationType.Result.AnnotationProcessorDetails details : allDetails) {
            results.add(this.toAnnotationProcessorResult(details));
        }
        return results;
    }

    private InternalJavaCompileTaskOperationResult.InternalAnnotationProcessorResult toAnnotationProcessorResult(CompileJavaBuildOperationType.Result.AnnotationProcessorDetails details) {
        return new DefaultAnnotationProcessorResult(details.getClassName(), this.toAnnotationProcessorType(details.getType()), Duration.ofMillis(details.getExecutionTimeInMillis()));
    }

    private String toAnnotationProcessorType(CompileJavaBuildOperationType.Result.AnnotationProcessorDetails.Type type) {
        switch (type) {
            case AGGREGATING: {
                return "AGGREGATING";
            }
            case ISOLATING: {
                return "ISOLATING";
            }
            case UNKNOWN: {
                return "UNKNOWN";
            }
        }
        throw new IllegalArgumentException("Missing conversion for enum constant " + (Object)((Object)type));
    }
}

