/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.testing.report.CompositeTestResults;
import org.gradle.api.internal.tasks.testing.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.report.TestResult;
import org.gradle.internal.FileUtils;

public class ClassTestResults
extends CompositeTestResults {
    private final long id;
    private final String name;
    private final String displayName;
    private final PackageTestResults packageResults;
    private final Set<TestResult> results = new TreeSet<TestResult>();
    private final String baseUrl;

    public ClassTestResults(long id, String name, PackageTestResults packageResults) {
        this(id, name, name, packageResults);
    }

    public ClassTestResults(long id, String name, String displayName, PackageTestResults packageResults) {
        super(packageResults);
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.packageResults = packageResults;
        this.baseUrl = "classes/" + FileUtils.toSafeFileName((String)name) + ".html";
    }

    public long getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.name.equals(this.displayName) ? "Class " + this.name : this.displayName;
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getReportName() {
        if (this.displayName != null && !this.displayName.equals(this.name)) {
            return this.displayName;
        }
        return this.getSimpleName();
    }

    public String getSimpleName() {
        String simpleName = StringUtils.substringAfterLast((String)this.name, (String)".");
        if (simpleName.equals("")) {
            return this.name;
        }
        return simpleName;
    }

    public PackageTestResults getPackageResults() {
        return this.packageResults;
    }

    public Collection<TestResult> getTestResults() {
        return this.results;
    }

    public TestResult addTest(String testName, String testDisplayName, long duration) {
        TestResult test = new TestResult(testName, testDisplayName, duration, this);
        this.results.add(test);
        return this.addTest(test);
    }
}

