/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.jndi;

import com.ca.commons.jndi.BasicOps;
import com.ca.commons.jndi.ConnectionData;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;

public class AdvancedOps
extends BasicOps {
    protected NameParser parser = this.getBaseNameParser();
    private static final Logger log = Logger.getLogger(AdvancedOps.class.getName());

    public AdvancedOps(DirContext c) throws NamingException {
        super(c);
    }

    public AdvancedOps(ConnectionData cData) throws NamingException {
        super(cData);
    }

    public static BasicOps getInstance(ConnectionData cData) throws NamingException {
        AdvancedOps newObject = new AdvancedOps(AdvancedOps.openContext(cData));
        return newObject;
    }

    public void startOperation(String heading, String operationName) {
    }

    public void stopOperation() {
    }

    public void pop() {
    }

    public NamingEnumeration push(NamingEnumeration elements) {
        return elements;
    }

    public void push(ArrayList elements) {
    }

    public void inc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTree(Name nodeDN) throws NamingException {
        try {
            if (nodeDN == null) {
                throw new NamingException("null DN passed to deleteTree.");
            }
            log.finer("recursively delete Tree " + nodeDN.toString());
            this.startOperation("Deleting " + nodeDN.toString(), "deleted ");
            this.recDeleteTree(nodeDN);
        }
        finally {
            this.stopOperation();
        }
    }

    protected void recDeleteTree(Name dn) throws NamingException {
        log.info("deleting " + dn);
        ArrayList childArray = this.getChildren(dn);
        this.push(childArray);
        ListIterator children = childArray.listIterator();
        while (children.hasNext()) {
            this.recDeleteTree((Name)children.next());
        }
        this.pop();
        this.deleteEntry(dn);
        this.inc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTree(Name oldNodeDN, Name newNodeDN) throws NamingException {
        try {
            if (oldNodeDN == null) {
                throw new NamingException("the original DN passed to moveTree is null.");
            }
            if (newNodeDN == null) {
                throw new NamingException("the destination DN passed to moveTree is null.");
            }
            log.finer("recursively move tree from " + oldNodeDN.toString() + " to " + newNodeDN.toString());
            this.startOperation("Moving " + oldNodeDN.toString(), "moving");
            this.recMoveTree(oldNodeDN, newNodeDN);
        }
        finally {
            this.stopOperation();
        }
    }

    protected void recMoveTree(Name from, Name to) throws NamingException {
        if (from.size() == to.size() && from.startsWith(to.getPrefix(to.size() - 1))) {
            try {
                this.renameEntry(from, to, true);
            }
            catch (ContextNotEmptyException e) {
                if (e.getMessage().indexOf("subtree rename not supported") > -1) {
                    this.recCopyAndDeleteTree(from, to);
                }
            }
        } else {
            this.recCopyAndDeleteTree(from, to);
        }
    }

    private void recCopyAndDeleteTree(Name from, Name to) throws NamingException {
        if (!this.exists(from)) {
            throw new NamingException("The DN that you are trying to move does not exist.");
        }
        try {
            this.recCopyTree(from, to);
        }
        catch (NamingException e) {
            this.recDeleteTree(to);
            throw e;
        }
        this.recDeleteTree(from);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTree(Name oldNodeDN, Name newNodeDN) throws NamingException {
        try {
            if (oldNodeDN == null) {
                throw new NamingException("the original DN passed to copyTree is null.");
            }
            if (newNodeDN == null) {
                throw new NamingException("the destination DN passed to copyTree is null.");
            }
            log.finer("recursively copy tree from " + oldNodeDN.toString() + " to " + newNodeDN.toString());
            this.startOperation("Copying " + oldNodeDN.toString(), "copying");
            this.recCopyTree(oldNodeDN, newNodeDN);
        }
        finally {
            this.stopOperation();
        }
    }

    protected void recCopyTree(Name from, Name to) throws NamingException {
        this.copyEntry(from, to);
        this.inc();
        ArrayList childArray = this.getChildren(from);
        this.push(childArray);
        ListIterator children = childArray.listIterator();
        while (children.hasNext()) {
            Name childDN = (Name)children.next();
            Name destinationDN = (Name)to.clone();
            destinationDN.add(childDN.get(childDN.size() - 1));
            this.recCopyTree(childDN, destinationDN);
        }
        this.pop();
    }

    protected ArrayList getChildren(Name base) throws NamingException {
        ArrayList<Name> children = new ArrayList<Name>();
        NamingEnumeration rawList = this.list(base);
        if (rawList.hasMoreElements()) {
            while (rawList.hasMoreElements()) {
                NameClassPair child = (NameClassPair)rawList.next();
                Name childDN = this.parser.parse(child.getName());
                if (childDN.size() == 1) {
                    childDN = ((Name)base.clone()).add(child.getName());
                }
                children.add(childDN);
            }
        }
        return children;
    }
}

