untrusted comment: verify with openbsd-63-base.pub
RWRxzbLwAd76ZY38yqd/TJ8+pXvPUerkbdp09oqLgSABa0p/aLelFTAUiseJGYhnOLY7sQMZnmAI550j3R3CGGOKyi1zgf9RDQk=

OpenBSD 6.3 errata 021, November 2, 2018

The syspatch utility incorrectly handles symbolic links.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 021_syspatch.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then install the syspatch utility
    cd /usr/src/usr.sbin/syspatch
    make install

Index: usr.sbin/syspatch/syspatch.sh
===================================================================
RCS file: /cvs/src/usr.sbin/syspatch/syspatch.sh,v
retrieving revision 1.135
diff -u -p -r1.135 syspatch.sh
--- usr.sbin/syspatch/syspatch.sh	10 Mar 2018 12:34:53 -0000	1.135
+++ usr.sbin/syspatch/syspatch.sh	29 Oct 2018 19:24:55 -0000
@@ -140,6 +140,9 @@ install_file()
 	local _dst=$2 _fgrp _fmode _fown _src=$1
 	[[ -f ${_src} && -f ${_dst} ]]
 
+	# ignore symlinks
+	[[ ! -h ${_src} ]] || return 0
+
 	eval $(stat -f "_fmode=%OMp%OLp _fown=%Su _fgrp=%Sg" ${_src})
 
 	install -DFSp -m ${_fmode} -o ${_fown} -g ${_fgrp} ${_src} ${_dst}
@@ -196,6 +199,11 @@ rollback_patch()
 
 	for _file in ${_files}; do
 		((_ret == 0)) || break
+		# prevent reverting to a bogus syspatch
+		if [[ ${_file} == usr/sbin/syspatch &&
+			${_patch} == 63-021_syspatch ]]; then
+			break
+		fi
 		install_file ${_edir}/${_file} /${_file} || _ret=$?
 	done
 
@@ -304,4 +312,8 @@ if ((OPTIND == 1)); then
 	for _PATCH in ${_PATCHES}; do
 		apply_patch ${_OSrev}-${_PATCH}
 	done
+	# repair X -> Xorg
+	if [[ ! -h /usr/X11R6/bin/X ]]; then
+		ln -sf Xorg /usr/X11R6/bin/X
+	fi
 fi
