untrusted comment: signature from openbsd 6.3 base secret key
RWRxzbLwAd76ZblnuQJzfDJ4izFnLuOIdtNCFSdJ+o8oKyZm1zFKd9Q7r0Hh2BzybMCgm190xFg+pBs2vfzcgFBVa3Ssg1XGvQE=

OpenBSD 6.3 errata 004, April 21, 2018:

In the gif(4) interface, use the specified protocol for IPv6, plug
an mbuf leak and avoid a use after free.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 004_gif.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/net/if_gif.c
===================================================================
RCS file: /cvs/src/sys/net/if_gif.c,v
retrieving revision 1.113
diff -u -p -r1.113 if_gif.c
--- sys/net/if_gif.c	15 Mar 2018 21:01:18 -0000	1.113
+++ sys/net/if_gif.c	18 Apr 2018 20:21:24 -0000
@@ -338,7 +338,7 @@ gif_send(struct gif_softc *sc, struct mb
 		ip6->ip6_flow = htonl(flow);
 		ip6->ip6_vfc |= IPV6_VERSION;
 		ip6->ip6_plen = htons(len);
-		ip6->ip6_nxt = IPPROTO_GRE;
+		ip6->ip6_nxt = proto;
 		ip6->ip6_hlim = ttl;
 		ip6->ip6_src = sc->sc_tunnel.t_src6;
 		ip6->ip6_dst = sc->sc_tunnel.t_dst6;
@@ -403,6 +403,8 @@ gif_output(struct ifnet *ifp, struct mbu
 		error = ENOBUFS;
 		goto drop;
 	}
+	memcpy((caddr_t)(mtag + 1), &ifp->if_index, sizeof(ifp->if_index));
+	m_tag_prepend(m, mtag);
 
 	m->m_pkthdr.ph_family = dst->sa_family;
 
@@ -758,7 +760,7 @@ gif_input(struct gif_tunnel *key, struct
 	case IPPROTO_IPV4: {
 		struct ip *ip;
 
-		m = m_pullup(m, sizeof(*ip));
+		m = *mp = m_pullup(m, sizeof(*ip));
 		if (m == NULL)
 			return (IPPROTO_DONE);
 
@@ -779,7 +781,7 @@ gif_input(struct gif_tunnel *key, struct
 	case IPPROTO_IPV6: {
 		struct ip6_hdr *ip6;
 
-		m = m_pullup(m, sizeof(*ip6));
+		m = *mp = m_pullup(m, sizeof(*ip6));
 		if (m == NULL)
 			return (IPPROTO_DONE);
 
@@ -812,7 +814,7 @@ gif_input(struct gif_tunnel *key, struct
 	m_adj(m, *offp);
 
 	if (sc->sc_ttl == -1) {
-		m = m_pullup(m, ttloff + 1);
+		m = *mp = m_pullup(m, ttloff + 1);
 		if (m == NULL)
 			return (IPPROTO_DONE);
 
@@ -842,11 +844,12 @@ gif_input(struct gif_tunnel *key, struct
 	}
 #endif
 
+	*mp = NULL;
 	(*input)(ifp, m);
 	return (IPPROTO_DONE);
 
  drop:
-	m_freem(m);
+	m_freemp(mp);
 	return (IPPROTO_DONE);
 }
 
