untrusted comment: verify with openbsd-76-base.pub
RWTkuwn4mbq8oqfoS/w3T6YuZgLma7MYUgXEB98eQUdqyNOYPa2OC/Q5ppjjbikXFmbtOOCmmVNR6UG6zv1YFwHpGZtUJvAz5Qk=

OpenBSD 7.6 errata 008, February 18, 2025:

sshd(8) denial of service relating to SSH2_MSG_PING handling.
ssh(1) server impersonation when VerifyHostKeyDNS enabled.

Apply by doing:
    signify -Vep /etc/signify/openbsd-76-base.pub -x 008_ssh.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install OpenSSH:
    cd /usr/src/usr.bin/ssh
    make obj
    make
    make install

Index: usr.bin/ssh/krl.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/krl.c,v
diff -u -p -r1.59 krl.c
--- usr.bin/ssh/krl.c	17 Jul 2023 05:22:30 -0000	1.59
+++ usr.bin/ssh/krl.c	7 Feb 2025 17:24:36 -0000
@@ -672,6 +672,7 @@ revoked_certs_generate(struct revoked_ce
 			break;
 		case KRL_SECTION_CERT_SERIAL_BITMAP:
 			if (rs->lo - bitmap_start > INT_MAX) {
+				r = SSH_ERR_INVALID_FORMAT;
 				error_f("insane bitmap gap");
 				goto out;
 			}
@@ -1057,6 +1058,7 @@ ssh_krl_from_blob(struct sshbuf *buf, st
 	}
 
 	if ((krl = ssh_krl_init()) == NULL) {
+		r = SSH_ERR_ALLOC_FAIL;
 		error_f("alloc failed");
 		goto out;
 	}
Index: usr.bin/ssh/packet.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/packet.c,v
diff -u -p -r1.317 packet.c
--- usr.bin/ssh/packet.c	23 Aug 2024 04:51:00 -0000	1.317
+++ usr.bin/ssh/packet.c	7 Feb 2025 17:24:36 -0000
@@ -1839,6 +1839,14 @@ ssh_packet_read_poll_seqnr(struct ssh *s
 			if ((r = sshpkt_get_string_direct(ssh, &d, &len)) != 0)
 				return r;
 			DBG(debug("Received SSH2_MSG_PING len %zu", len));
+			if (!ssh->state->after_authentication) {
+				DBG(debug("Won't reply to PING in preauth"));
+				break;
+			}
+			if (ssh_packet_is_rekeying(ssh)) {
+				DBG(debug("Won't reply to PING during KEX"));
+				break;
+			}
 			if ((r = sshpkt_start(ssh, SSH2_MSG_PONG)) != 0 ||
 			    (r = sshpkt_put_string(ssh, d, len)) != 0 ||
 			    (r = sshpkt_send(ssh)) != 0)
Index: usr.bin/ssh/ssh-agent.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-agent.c,v
diff -u -p -r1.307 ssh-agent.c
--- usr.bin/ssh/ssh-agent.c	24 Sep 2024 02:28:17 -0000	1.307
+++ usr.bin/ssh/ssh-agent.c	7 Feb 2025 17:24:37 -0000
@@ -1195,6 +1195,7 @@ parse_key_constraint_extension(struct ss
 	    "restrict-destination-v00@openssh.com") == 0) {
 		if (*dcsp != NULL) {
 			error_f("%s already set", ext_name);
+			r = SSH_ERR_INVALID_FORMAT;
 			goto out;
 		}
 		if ((r = sshbuf_froms(m, &b)) != 0) {
@@ -1204,6 +1205,7 @@ parse_key_constraint_extension(struct ss
 		while (sshbuf_len(b) != 0) {
 			if (*ndcsp >= AGENT_MAX_DEST_CONSTRAINTS) {
 				error_f("too many %s constraints", ext_name);
+				r = SSH_ERR_INVALID_FORMAT;
 				goto out;
 			}
 			*dcsp = xrecallocarray(*dcsp, *ndcsp, *ndcsp + 1,
@@ -1221,6 +1223,7 @@ parse_key_constraint_extension(struct ss
 		}
 		if (*certs != NULL) {
 			error_f("%s already set", ext_name);
+			r = SSH_ERR_INVALID_FORMAT;
 			goto out;
 		}
 		if ((r = sshbuf_get_u8(m, &v)) != 0 ||
@@ -1232,6 +1235,7 @@ parse_key_constraint_extension(struct ss
 		while (sshbuf_len(b) != 0) {
 			if (*ncerts >= AGENT_MAX_EXT_CERTS) {
 				error_f("too many %s constraints", ext_name);
+				r = SSH_ERR_INVALID_FORMAT;
 				goto out;
 			}
 			*certs = xrecallocarray(*certs, *ncerts, *ncerts + 1,
@@ -1732,6 +1736,7 @@ process_ext_session_bind(SocketEntry *e)
 	/* record new key/sid */
 	if (e->nsession_ids >= AGENT_MAX_SESSION_IDS) {
 		error_f("too many session IDs recorded");
+		r = -1;
 		goto out;
 	}
 	e->session_ids = xrecallocarray(e->session_ids, e->nsession_ids,
Index: usr.bin/ssh/ssh-sk-client.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/ssh-sk-client.c,v
diff -u -p -r1.12 ssh-sk-client.c
--- usr.bin/ssh/ssh-sk-client.c	14 Jan 2022 03:34:00 -0000	1.12
+++ usr.bin/ssh/ssh-sk-client.c	7 Feb 2025 17:24:37 -0000
@@ -429,6 +429,7 @@ sshsk_load_resident(const char *provider
 		}
 		if ((srk = calloc(1, sizeof(*srk))) == NULL) {
 			error_f("calloc failed");
+			r = SSH_ERR_ALLOC_FAIL;
 			goto out;
 		}
 		srk->key = key;
@@ -440,6 +441,7 @@ sshsk_load_resident(const char *provider
 		if ((tmp = recallocarray(srks, nsrks, nsrks + 1,
 		    sizeof(*srks))) == NULL) {
 			error_f("recallocarray keys failed");
+			r = SSH_ERR_ALLOC_FAIL;
 			goto out;
 		}
 		debug_f("srks[%zu]: %s %s uidlen %zu", nsrks,
Index: usr.bin/ssh/sshconnect2.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/sshconnect2.c,v
diff -u -p -r1.375 sshconnect2.c
--- usr.bin/ssh/sshconnect2.c	9 Sep 2024 02:39:57 -0000	1.375
+++ usr.bin/ssh/sshconnect2.c	7 Feb 2025 17:24:37 -0000
@@ -94,7 +94,7 @@ verify_host_key_callback(struct sshkey *
 	    options.required_rsa_size)) != 0)
 		fatal_r(r, "Bad server host key");
 	if (verify_host_key(xxx_host, xxx_hostaddr, hostkey,
-	    xxx_conn_info) == -1)
+	    xxx_conn_info) != 0)
 		fatal("Host key verification failed.");
 	return 0;
 }
@@ -692,6 +692,7 @@ input_userauth_pk_ok(int type, u_int32_t
 
 	if ((pktype = sshkey_type_from_name(pkalg)) == KEY_UNSPEC) {
 		debug_f("server sent unknown pkalg %s", pkalg);
+		r = SSH_ERR_INVALID_FORMAT;
 		goto done;
 	}
 	if ((r = sshkey_from_blob(pkblob, blen, &key)) != 0) {
@@ -702,6 +703,7 @@ input_userauth_pk_ok(int type, u_int32_t
 		error("input_userauth_pk_ok: type mismatch "
 		    "for decoded key (received %d, expected %d)",
 		    key->type, pktype);
+		r = SSH_ERR_INVALID_FORMAT;
 		goto done;
 	}
 
@@ -721,6 +723,7 @@ input_userauth_pk_ok(int type, u_int32_t
 		    SSH_FP_DEFAULT);
 		error_f("server replied with unknown key: %s %s",
 		    sshkey_type(key), fp == NULL ? "<ERROR>" : fp);
+		r = SSH_ERR_INVALID_FORMAT;
 		goto done;
 	}
 	ident = format_identity(id);
Index: usr.bin/ssh/sshsig.c
===================================================================
RCS file: /cvs/src/usr.bin/ssh/sshsig.c,v
diff -u -p -r1.35 sshsig.c
--- usr.bin/ssh/sshsig.c	8 Mar 2024 22:16:32 -0000	1.35
+++ usr.bin/ssh/sshsig.c	7 Feb 2025 17:24:37 -0000
@@ -872,6 +872,7 @@ cert_filter_principals(const char *path,
 	}
 	if ((principals = sshbuf_dup_string(nprincipals)) == NULL) {
 		error_f("buffer error");
+		r = SSH_ERR_ALLOC_FAIL;
 		goto out;
 	}
 	/* success */
