/***************************************************************************
                            kde_DocumentType.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_DOCUMENTTYPE
#define KDE_DOCUMENTTYPE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Each <code> Document </code> has a <code> doctype </code> attribute
 whose value is either <code> null </code> or a <code> DocumentType
 </code> object. The <code> DocumentType </code> interface in the
 DOM Level 1 Core provides an interface to the list of entities that
 are defined for the document, and little else because the effect of
 namespaces and the various XML scheme efforts on DTD representation
 are not clearly understood as of this writing.

  The DOM Level 1 doesn't support editing <code> DocumentType
 </code> nodes.

 
 @short *
 Each <code> Document </code> has a <code> doctype </code> attribute
 whose value is either <code> null </code> or a <code> DocumentType
 </code> object.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_DocumentType * kde_new_DocumentType();
kde_DocumentType * kde_new_DocumentType1(kde_DocumentType* other);
kde_DocumentType * kde_new_DocumentType2(kde_DOMNode* other);
void kde_del_DocumentType( kde_DocumentType* p );

/** *
 The name of DTD; i.e., the name immediately following the
 <code> DOCTYPE </code> keyword.

     
*/
kde_DOMString* kde_DocumentType_name(kde_DocumentType* instPointer);

/** *
 A <code> NamedNodeMap </code> containing the general entities,
 both external and internal, declared in the DTD. Duplicates are
 discarded. For example in: &lt;!DOCTYPE ex SYSTEM "ex.dtd" [
 &lt;!ENTITY foo "foo"> &lt;!ENTITY bar "bar"> &lt;!ENTITY % baz
 "baz"> ]> &lt;ex/> the interface provides access to <code> foo
 </code> and <code> bar </code> but not <code> baz </code> .
 Every node in this map also implements the <code> Entity
 </code> interface.

  The DOM Level 1 does not support editing entities, therefore
 <code> entities </code> cannot be altered in any way.

     
*/
kde_NamedNodeMap* kde_DocumentType_entities(kde_DocumentType* instPointer);

/** *
 A <code> NamedNodeMap </code> containing the notations declared
 in the DTD. Duplicates are discarded. Every node in this map
 also implements the <code> Notation </code> interface.

  The DOM Level 1 does not support editing notations, therefore
 <code> notations </code> cannot be altered in any way.

     
*/
kde_NamedNodeMap* kde_DocumentType_notations(kde_DocumentType* instPointer);

/** *
 Introduced in DOM Level 2

 The public identifier of the external subset.
     
*/
kde_DOMString* kde_DocumentType_publicId(kde_DocumentType* instPointer);

/** *
 Introduced in DOM Level 2

 The system identifier of the external subset.
     
*/
kde_DOMString* kde_DocumentType_systemId(kde_DocumentType* instPointer);

/** *
 Introduced in DOM Level 2

 The internal subset as a string.

 Note: The actual content returned depends on how much information is
 available to the implementation. This may vary depending on various
 parameters, including the XML processor used to build the document.
     
*/
kde_DOMString* kde_DocumentType_internalSubset(kde_DocumentType* instPointer);

#ifdef __cplusplus
}
#endif
#endif
