/***************************************************************************
                            kde_KSelector.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSELECTOR
#define KDE_KSELECTOR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 KSelector is the base class for other widgets which
 provides the ability to choose from a one-dimensional
 range of values. An example is the @ref KGradientSelector
 which allows to choose from a range of colors.

 A custom drawing routine for the widget surface has
 to be provided by the subclass.
 
 @short *
 KSelector is the base class for other widgets which
 provides the ability to choose from a one-dimensional
 range of values.
*/

/** *
 Constructs a horizontal one-dimensional selection widget.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KSelector * kde_new_KSelector(qt_QWidget * parent, char* name);

/** *
 Constructs a one-dimensional selection widget with
 a given orientation.
   
*/
kde_KSelector * kde_new_KSelector1(int o, qt_QWidget * parent, char* name);
void kde_del_KSelector( kde_KSelector* p );

/** *

*/
int kde_KSelector_orientation(kde_KSelector* instPointer);

/** *

*/
qt_QRect* kde_KSelector_contentsRect(kde_KSelector* instPointer);

/** *
 Sets the indent option of the widget to i.
 This determines whether a shaded frame is drawn.
   
*/
void kde_KSelector_setIndent(kde_KSelector* instPointer,int i);

/** *

*/
int kde_KSelector_indent(kde_KSelector* instPointer);

/** *
 Sets the value.
   
*/
void kde_KSelector_setValue(kde_KSelector* instPointer,int value);

/** *

*/
int kde_KSelector_value(kde_KSelector* instPointer);

/** *
 Sets the min value.
   
*/
void kde_KSelector_setMinValue(kde_KSelector* instPointer,int value);

/** *

*/
int kde_KSelector_minValue(kde_KSelector* instPointer);

/** *
 Sets the max value.
   
*/
void kde_KSelector_setMaxValue(kde_KSelector* instPointer,int value);

/** *

*/
int kde_KSelector_maxValue(kde_KSelector* instPointer);

/** *
 Override this function to draw the contents of the control.
 The default implementation does nothing.

 Draw only within contentsRect().
   
*/
void kde_KSelector_drawContents(kde_KSelector* instPointer,qt_QPainter * arg1);

/** *
 Override this function to draw the cursor which
 indicates the current value. This function is
 always called twice, once with argument show=false
 to clear the old cursor, once with argument show=true
 to draw the new one.
   
*/
void kde_KSelector_drawArrow(kde_KSelector* instPointer,qt_QPainter * painter, int show, qt_QPoint* pos);
void kde_KSelector_virtual_hook(kde_KSelector* instPointer,int identifier, void* data);

/** Casts a 'kde_KSelector *' to a 'qt_QRangeControl*' */
qt_QRangeControl* kde_KSelector_QRangeControl(kde_KSelector* instPointer);

/** Casts a 'kde_KSelector *' to a 'qt_QWidget *' */
qt_QWidget * kde_KSelector_QWidget(kde_KSelector* instPointer);

#ifdef __cplusplus
}
#endif
#endif
