/***************************************************************************
                            HTMLScriptElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLSCRIPTELEMENT_H
#define HTMLSCRIPTELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Script statements. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/scripts.-[html edef]-SCRIPT">
 SCRIPT element definition </a> in HTML 4.0.

 
 @short 
 Script statements.
*/

@interface HTMLScriptElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 The script content of the element.

     
*/
- (NSString *) text;

/** 
 see @ref text
     
*/
- setText: (NSString *)arg1;

/** 
 Reserved for future use.

     
*/
- (NSString *) htmlFor;

/** 
 see @ref htmlFor
     
*/
- setHtmlFor: (NSString *)arg1;

/** 
 Reserved for future use.

     
*/
- (NSString *) event;

/** 
 see @ref event
     
*/
//- setEvent: (NSString *)arg1;

/** 
 The character encoding of the linked resource. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/links.-[html adef]-charset">
 charset attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) charset;

/** 
 see @ref charset
     
*/
- setCharset: (NSString *)arg1;

/** 
 Indicates that the user agent can defer processing of the
 script. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/scripts.-[html adef]-defer">
 defer attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) defer;

/** 
 see @ref defer
     
*/
- setDefer: (BOOL)arg1;

/** 
 URI designating an external script. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/scripts.-[html adef]-src-SCRIPT">
 src attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) src;

/** 
 see @ref src
     
*/
- setSrc: (NSString *)arg1;

/** 
 The content type of the script language. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/scripts.-[html adef]-type-SCRIPT">
 type attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) type;

/** 
 see @ref type
     
*/
- setType: (NSString *)arg1;
@end

#endif
