/***************************************************************************
                            KAboutWidget.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KABOUTWIDGET_H
#define KABOUTWIDGET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 KAboutWidget is the main widget for KAboutDialog.

 It has a minimum size set.
 
 @short 
 KAboutWidget is the main widget for KAboutDialog.
*/
@interface KAboutWidget : QWidget 

/** 
 The Qt constructor.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Adjust the minimum size (after setting the properties of the image and
 the labels.
   
*/
- adjust;

/** 
 Sets the image as the application logo.
   
*/
- setLogo: (QPixmap *)arg1;

/**  Sets the author's name and email address. 
*/
- setAuthor: (NSString *)name email: (NSString *)email url: (NSString *)url work: (NSString *)work;

/**  Sets the maintainers name and email address. 
*/
- setMaintainer: (NSString *)name email: (NSString *)email url: (NSString *)url work: (NSString *)work;

/**  Shows this person as one of the major contributors. 
*/
- addContributor: (NSString *)name email: (NSString *)email url: (NSString *)url work: (NSString *)work;

/**  Sets the text describing the version. 
*/
- setVersion: (NSString *)name;

/**  Catches the signals from the contributors elements. 
*/
- sendEmailSlot: (NSString *)name email: (NSString *)email;

/**  Catches the clicked URLs. 
*/
- openURLSlot: (NSString *)url;
@end

/** Override these methods in subclasses of KAboutWidget to customise event handling behaviour */
@protocol KAboutWidgetEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;

/**  The resize event. 
*/
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
