/***************************************************************************
                            KSSL.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSSL_H
#define KSSL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

@class KSSLConnectionInfo; 
@class KSSLPKCS12; 
@class KSSLPeerInfo; 
@class KSSLSettings; 

@interface  KSSL : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- initWithBOOL: (BOOL)init;
- init;
- (void) dealloc;
- (BOOL) initialize;

/** 
 This is used for apps which do STARTTLS or something similar.
 It creates a TLS method regardless of the user's settings.
   
*/
- (BOOL) TLSInit;
- close;
- (BOOL) reInitialize;
- (BOOL) reconfig;
- setAutoReconfig: (BOOL)ar;

/** 
 This will reseed the PRNG with the EGD if the EGD is configured and
 enabled.  You don't need to call this yourself normally.
   
*/
- (int) seedWithEGD;

/** 
 Set a new KSSLSettings instance as the settings.
 This deletes the current instance of KSSLSettings.
   
*/
- (BOOL) setSettings: (KSSLSettings*)settings;

/** 

*/
- (KSSLSettings*) settings;

/** 

*/
- (BOOL) setClientCertificate: (KSSLPKCS12*)pkcs;

/** 
 Set the status of the connection with respect to proxies.
 realIP is the IP address of the host you're connecting to
 realPort is the port of the host you're connecting to
 proxy is the IP or hostname of the proxy server
   
*/
- setProxyUse: (BOOL)active realIP: (NSString *)realIP realPort: (int)realPort proxy: (NSString *)proxy;
- setProxyUse: (BOOL)active ;
- setPeerHost: (NSString *)realHost;
- setPeerHost;
- (int) connect: (int)sock;
- (int) read: (void*)buf len: (int)len;
- (int) peek: (void*)buf len: (int)len;
- (int) write: (void*)buf len: (int)len;
- (int) pending;
- (KSSLConnectionInfo*) connectionInfo;
- (KSSLPeerInfo*) peerInfo;
+ (BOOL) doesSSLWork;
@end

#endif
