/***************************************************************************
                            KScriptInterface.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSCRIPTINTERFACE_H
#define KSCRIPTINTERFACE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

	This class is the base for all script engines.

 @author Ian Reinhart Geiser <geiseri@kde.org>

 @short 
	This class is the base for all script engines.
*/
@interface KScriptInterface : QObject 

/** 
	Return the current script code data

*/
- (NSString *) script;

/** 
	Sets the path to the script library that we are going to embed.

*/
- setScript: (NSString *)scriptFile;

/** 
	Sets the path to the script library that we are going to embed.
	The second argument is the function from the script library that
	we wish to call.

*/
- setScript: (NSString *)scriptLibFile method: (NSString *)method;

/** 
	Run the actual script code
	This can both take a context object that will be shared between the
	main application and a variant that will contain the arguments.

*/
- run: (QObject *)context arg: (QVariant *)arg;
- run;

/** 
	Abort the scripts run

*/
- kill;
@end

/** Override these methods in subclasses of KScriptInterface to customise event handling behaviour */
@protocol KScriptInterfaceEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
