/***************************************************************************
                            KSelector.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSELECTOR_H
#define KSELECTOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QRangeControl.h>
#include <qtobjc/QWidget.h>

/**

 KSelector is the base class for other widgets which
 provides the ability to choose from a one-dimensional
 range of values. An example is the @ref KGradientSelector
 which allows to choose from a range of colors.

 A custom drawing routine for the widget surface has
 to be provided by the subclass.
 
 @short 
 KSelector is the base class for other widgets which
 provides the ability to choose from a one-dimensional
 range of values.
*/
@interface KSelector : QWidget 

/** 
 Constructs a horizontal one-dimensional selection widget.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Constructs a one-dimensional selection widget with
 a given orientation.
   
*/
- initWithInt: (int)o parent: (QWidget *)parent name: (NSString *)name;
- initWithInt: (int)o ;
- (void) dealloc;

/** 

*/
- (int) orientation;

/** 

*/
- (QRect*) contentsRect;

/** 
 Sets the indent option of the widget to i.
 This determines whether a shaded frame is drawn.
   
*/
- setIndent: (BOOL)i;

/** 

*/
- (BOOL) indent;

/** 
 Override this function to draw the contents of the control.
 The default implementation doesn nothing.

 Draw only within -contentsRect.
   
*/
- drawContents: (QPainter *)arg1;

/** 
 Override this function to draw the cursor which
 indicates the currently value. This function is
 always called twice, once with argument show=false
 to clear the old cursor, once with argument show=true
 to draw the new one.
   
*/
- drawArrow: (QPainter *)painter show: (BOOL)show pos: (QPoint*)pos;
@end

@interface KSelector (QRangeControlImplementation) <QRangeControlInterface>
@end

/** Override these methods in subclasses of KSelector to customise event handling behaviour */
@protocol KSelectorEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;

/** 

   
*/
- mousePressEvent:(QMouseEvent*) e;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;

/** 

   
*/
- mouseMoveEvent:(QMouseEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;

/** 

   
*/
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
