/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __XFPRINTERLIST_H__
#define __XFPRINTERLIST_H__

#include <glib.h>

#include "xfprinter.h"

typedef struct _XfPrinterList XfPrinterList;
struct _XfPrinterList
{
	XfPrinter	*default_printer;
	GList		*current;
	GList		*printers;
	/* XXX - introduce a mutex to make this thread safe! */
};

typedef void (*XfPrinterListFunc)(XfPrinter *, gpointer);

extern XfPrinterList	*xfprinterlist_load(void);
extern void		xfprinterlist_free(XfPrinterList *);
extern void		xfprinterlist_save(XfPrinterList *);
extern void		xfprinterlist_insert(XfPrinterList *, XfPrinter *);
extern XfPrinter	*xfprinterlist_lookup(XfPrinterList *, const gchar *);
extern XfPrinter	*xfprinterlist_get_default(XfPrinterList *);
extern void		xfprinterlist_set_default(XfPrinterList *,XfPrinter *);
extern gboolean		xfprinterlist_is_default(XfPrinterList *,XfPrinter *);
extern gboolean		xfprinterlist_is_default_by_alias(XfPrinterList *,
							  const gchar *);
extern GList		*xfprinterlist_get_aliases(XfPrinterList *);
extern void		xfprinterlist_foreach(XfPrinterList *,
					      XfPrinterListFunc, gpointer);
extern XfPrinter	*xfprinterlist_first(XfPrinterList *);
extern XfPrinter	*xfprinterlist_next(XfPrinterList *);
extern void		xfprinterlist_remove(XfPrinterList *, XfPrinter *);
extern gboolean		xfprinterlist_is_empty(const XfPrinterList *);

#endif	/* !__XFPRINTERLIST_H__ */
