/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Timer;

public class AnimationPanel
extends Canvas
implements ActionListener {
    private static final String LOGO_IMAGE_LARGE = "sun/plugin/util/JavaCupLogo-161.png";
    private static final String WATERMARK_IMAGE = "sun/plugin/util/java-watermark.gif";
    private static final double TWO_PI = Math.PI * 2;
    private static final double HALF_PI = 1.5707963267948966;
    private static final Color clrBorder = new Color(153, 153, 153);
    private static final Color clrBg1 = new Color(255, 255, 255, 0);
    private static final Color clrBg2 = Color.white;
    private static final Color clrRay1 = Color.white;
    private static final Color clrRay2 = new Color(180, 180, 180);
    private static final Color clrProgBg = Color.white;
    private static final Color clrProgBorder = Color.lightGray;
    private static final Color clrProgBar = Color.red;
    private static final int MAX_INNER_DIAMETER = 169;
    private static final int MAX_OUTER_DIAMETER = 304;
    private int numRays;
    private int rayStart;
    private int rayEnd;
    private int rayWidth;
    private int progressWidth;
    private int progressHeight;
    private int progressGap;
    private int progressYOff;
    private Polygon[] burstPoints;
    private BufferedImage background;
    private Image logo;
    private Image backbuffer;
    private Timer timer = new Timer(30, this);
    private float burstProgress;
    private float loadingProgress = 0.0f;
    private int width;
    private int height;
    private boolean showBurst;
    private boolean showLogoAndBar;
    private boolean showWatermark;
    private long startTime = System.currentTimeMillis();

    public AnimationPanel(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public void setProgressValue(float f) {
        this.loadingProgress = f;
    }

    private void initDimensions(int n, int n2) {
        int n3;
        int n4;
        int n5 = Math.min(n, n2);
        this.numRays = 18;
        this.showBurst = n5 >= 25;
        this.showLogoAndBar = n5 >= 170;
        boolean bl = this.showWatermark = n5 >= 400;
        if (this.showWatermark) {
            n4 = 169;
            n3 = 304;
        } else if (this.showLogoAndBar) {
            n3 = n5 - 8;
            if (n3 > 304) {
                n3 = 304;
                n4 = 169;
            } else {
                n4 = (int)((double)n3 / 1.8);
            }
        } else {
            n3 = n5 - 4;
            n4 = (int)((double)n5 * 0.35);
            this.numRays = n5 < 100 ? 9 : 12;
        }
        this.rayStart = n4 / 2;
        this.rayEnd = n3 / 2;
        this.rayWidth = Math.max(n3 / 40 + 1, 2);
    }

    private void initBackgroundImage(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        this.background = graphicsConfiguration.createCompatibleImage(n, n2);
        Graphics2D graphics2D = this.background.createGraphics();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(ClassLoader.getSystemResource(WATERMARK_IMAGE));
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        for (int i = 0; i < n2; i += n4) {
            for (int j = 0; j < n; j += n3) {
                graphics2D.drawImage(image, j, i, null);
            }
        }
        graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, clrBg1, n / 2, n2 / 2, clrBg2, true));
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
    }

    private void initLogoImage(GraphicsConfiguration graphicsConfiguration) {
        String string = LOGO_IMAGE_LARGE;
        boolean bl = !this.showWatermark;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(ClassLoader.getSystemResource(string));
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (bl) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            int n3 = this.rayStart * 2 - 8;
            int n4 = (int)((double)n3 / (double)n2 * (double)n);
            this.logo = graphicsConfiguration.createCompatibleImage(n4, n3);
            Graphics2D graphics2D = (Graphics2D)this.logo.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics2D.drawImage(image, 0, 0, n4, n3, Color.white, null);
            graphics2D.dispose();
        } else {
            this.logo = image;
        }
        this.progressWidth = this.logo.getWidth(null) * 2;
        this.progressHeight = 8;
        this.progressGap = 2;
        this.progressYOff = this.rayStart + 10;
    }

    private void initBurst(int n, int n2) {
        this.burstPoints = new Polygon[this.numRays];
        for (int i = 0; i < this.numRays; ++i) {
            Polygon polygon = new Polygon();
            double d = (double)i / (double)this.numRays * (Math.PI * 2) - 1.5707963267948966;
            double d2 = d + 1.5707963267948966;
            double d3 = Math.cos(d);
            double d4 = Math.sin(d);
            int n3 = n + (int)(d3 * (double)this.rayStart);
            int n4 = n2 + (int)(d4 * (double)this.rayStart);
            int n5 = n + (int)(d3 * (double)this.rayEnd);
            int n6 = n2 + (int)(d4 * (double)this.rayEnd);
            int n7 = (int)(Math.cos(d2) * (double)this.rayWidth);
            int n8 = (int)(Math.sin(d2) * (double)this.rayWidth);
            polygon.addPoint(n3 - n7, n4 - n8);
            polygon.addPoint(n5, n6);
            polygon.addPoint(n3 + n7, n4 + n8);
            this.burstPoints[i] = polygon;
        }
    }

    public void paint(Graphics graphics) {
        Object object;
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n / 2;
        int n4 = n2 / 2;
        if (this.backbuffer == null || n != this.width || n2 != this.height) {
            object = this.getGraphicsConfiguration();
            this.backbuffer = this.createImage(n, n2);
            this.initDimensions(n, n2);
            if (this.showWatermark) {
                this.initBackgroundImage((GraphicsConfiguration)object, n, n2);
            }
            if (this.showLogoAndBar) {
                this.initLogoImage((GraphicsConfiguration)object);
            }
            this.initBurst(n3, n4);
            this.width = n;
            this.height = n2;
        }
        object = (Graphics2D)this.backbuffer.getGraphics();
        this.renderBackground((Graphics2D)object, n, n2);
        if (this.showBurst) {
            this.renderBurst((Graphics2D)object, n3, n4);
        }
        if (this.showLogoAndBar) {
            this.renderLogo((Graphics2D)object, n3, n4);
            this.renderProgress((Graphics2D)object, n3 - this.progressWidth / 2, n4 + this.progressYOff, this.progressWidth, this.progressHeight, this.progressGap);
        }
        ((Graphics)object).setColor(clrBorder);
        ((Graphics)object).drawRect(0, 0, n - 1, n2 - 1);
        ((Graphics)object).dispose();
        graphics.drawImage(this.backbuffer, 0, 0, null);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void renderBackground(Graphics2D graphics2D, int n, int n2) {
        if (this.showWatermark) {
            graphics2D.drawImage((Image)this.background, 0, 0, null);
        } else {
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n, n2);
        }
    }

    private void renderBurst(Graphics2D graphics2D, int n, int n2) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n3 = this.burstPoints.length;
        int n4 = this.rayStart + (this.rayEnd - this.rayStart) / 2;
        for (int i = 0; i < n3; ++i) {
            double d = (double)i / (double)n3;
            double d2 = d * (Math.PI * 2) - 1.5707963267948966;
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            double d5 = d > (double)this.burstProgress ? 1.0 - (d - (double)this.burstProgress) : (double)this.burstProgress - d;
            double d6 = (double)n4 + d5 * (double)this.rayEnd;
            float f = (float)n + (float)(d3 * (double)this.rayStart);
            float f2 = (float)n2 + (float)(d4 * (double)this.rayStart);
            float f3 = (float)n + (float)(d3 * d6);
            float f4 = (float)n2 + (float)(d4 * d6);
            GradientPaint gradientPaint = new GradientPaint(f, f2, clrRay1, f3, f4, clrRay2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillPolygon(this.burstPoints[i]);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    private void renderLogo(Graphics2D graphics2D, int n, int n2) {
        graphics2D.drawImage(this.logo, n - this.logo.getWidth(null) / 2, n2 - this.logo.getHeight(null) / 2, null);
    }

    private void renderProgress(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        graphics2D.setColor(clrProgBg);
        graphics2D.fillRect(n, n2, n3, n4);
        graphics2D.setColor(clrProgBorder);
        graphics2D.drawRect(n, n2, n3, n4);
        graphics2D.setColor(clrProgBar);
        graphics2D.fillRect(n + n5, n2 + n5, (int)((float)n3 * this.loadingProgress) - (n5 + 1), n4 - (n5 + 1));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
        long l = System.currentTimeMillis() - this.startTime;
        this.burstProgress = (float)(l % 3000L) / 3000.0f;
    }

    public void startAnimation() {
        this.timer.start();
    }

    public void stopAnimation() {
        this.timer.stop();
    }
}

