/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.CarSpace;
import sun.jvm.hotspot.memory.CarTableDesc;
import sun.jvm.hotspot.memory.Train;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class CarTable
extends VMObject {
    private static CIntegerField logOfCarSpaceSizeField;
    private static AddressField tableField;
    private static AddressField tableBaseField;
    private static CIntegerField tableSizeField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("CarTable");
        logOfCarSpaceSizeField = type.getCIntegerField("_LogOfCarSpaceSizeField");
        tableField = type.getAddressField("_table");
        tableBaseField = type.getAddressField("_table_base");
        tableSizeField = type.getCIntegerField("_table_size");
    }

    public CarTable(Address addr) {
        super(addr);
    }

    public long trainNumberFor(Oop p) {
        return this.descFor(p).trainNumber();
    }

    public long carNumberFor(Oop p) {
        return this.descFor(p).carNumber();
    }

    public Train trainFor(Oop p) {
        return this.descFor(p).train();
    }

    public CarSpace spaceFor(Oop p) {
        return this.descFor(p).space();
    }

    public CarTableDesc descFor(Oop p) {
        OopHandle handle = p.getHandle();
        Address entry = this.tableBase().addOffsetTo(this.getIndexWork(handle));
        return (CarTableDesc)VMObjectFactory.newObject(CarTableDesc.class, entry);
    }

    private Address tableBase() {
        return tableBaseField.getValue(this.addr);
    }

    private int getIndexWork(Address addr) {
        long value = VM.getVM().getDebugger().getAddressValue(addr);
        return CarTable.low(value) >> this.logOfCarSpaceSize();
    }

    private static int low(long value) {
        return (int)value;
    }

    private int logOfCarSpaceSize() {
        return (int)logOfCarSpaceSizeField.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CarTable.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

