/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.memory;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.memory.ContiguousSpace;
import sun.jvm.hotspot.memory.EdenSpace;
import sun.jvm.hotspot.memory.Generation;
import sun.jvm.hotspot.memory.SpaceClosure;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class DefNewGeneration
extends Generation {
    private static AddressField edenSpaceField;
    private static AddressField fromSpaceField;
    private static AddressField toSpaceField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("DefNewGeneration");
        edenSpaceField = type.getAddressField("_eden_space");
        fromSpaceField = type.getAddressField("_from_space");
        toSpaceField = type.getAddressField("_to_space");
    }

    public DefNewGeneration(Address addr) {
        super(addr);
    }

    public Generation.Name kind() {
        return Generation.Name.DEF_NEW;
    }

    public EdenSpace eden() {
        return (EdenSpace)VMObjectFactory.newObject(EdenSpace.class, edenSpaceField.getValue(this.addr));
    }

    public ContiguousSpace from() {
        return (ContiguousSpace)VMObjectFactory.newObject(ContiguousSpace.class, fromSpaceField.getValue(this.addr));
    }

    public ContiguousSpace to() {
        return (ContiguousSpace)VMObjectFactory.newObject(ContiguousSpace.class, toSpaceField.getValue(this.addr));
    }

    public long capacity() {
        return this.eden().capacity() + this.from().capacity();
    }

    public long used() {
        return this.eden().used() + this.from().used();
    }

    public long free() {
        return this.eden().free() + this.from().free();
    }

    public long contiguousAvailable() {
        return this.eden().free();
    }

    public String name() {
        return "default new generation";
    }

    public void spaceIterate(SpaceClosure blk, boolean usedOnly) {
        blk.doSpace(this.eden());
        blk.doSpace(this.from());
        if (!usedOnly) {
            blk.doSpace(this.to());
        }
    }

    public void printOn(PrintStream tty) {
        tty.print("  eden");
        this.eden().printOn(tty);
        tty.print("  from");
        this.from().printOn(tty);
        tty.print("  to  ");
        this.to().printOn(tty);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                DefNewGeneration.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

