/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.daemon.SnmpResponseHandler;
import com.sun.jmx.trace.Trace;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

final class SnmpSocket
implements Runnable {
    private DatagramSocket _socket = null;
    private SnmpResponseHandler _dgramHdlr = null;
    private Thread _sockThread = null;
    private byte[] _buffer = null;
    private transient boolean isClosing = false;
    int _socketPort = 0;
    int responseBufSize = 1024;
    String dbgTag = "SnmpSocket";

    public SnmpSocket(SnmpResponseHandler snmpResponseHandler, InetAddress inetAddress, int n2) throws SocketException {
        if (this.isTraceOn()) {
            this.trace("constructor", "Creating new SNMP datagram socket");
        }
        this._socket = new DatagramSocket(0, inetAddress);
        this._socketPort = this._socket.getLocalPort();
        this.responseBufSize = n2;
        this._buffer = new byte[this.responseBufSize];
        this._dgramHdlr = snmpResponseHandler;
        this._sockThread = new Thread(this, "SnmpSocket");
        this._sockThread.start();
    }

    public synchronized void sendPacket(byte[] byArray, int n2, InetAddress inetAddress, int n3) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n2, inetAddress, n3);
        this.sendPacket(datagramPacket);
    }

    public synchronized void sendPacket(DatagramPacket datagramPacket) throws IOException {
        try {
            if (this.isValid()) {
                if (this.isTraceOn()) {
                    this.trace("sendPacket", "Sending DatagramPacket. Length = " + datagramPacket.getLength() + " through socket = " + this._socket.toString());
                }
            } else {
                throw new IOException("Invalid state of SNMP datagram socket.");
            }
            this._socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            if (this.isDebugOn()) {
                this.debug("sendPacket", "Io error while sending");
                this.debug("sendPacket", iOException.getMessage());
            }
            throw iOException;
        }
    }

    public synchronized boolean isValid() {
        return this._socket != null && this._sockThread != null && this._sockThread.isAlive();
    }

    public synchronized void close() {
        this.isClosing = true;
        if (this.isTraceOn()) {
            this.trace("close", "Closing and destroying the SNMP datagram socket -> " + this.toString());
        }
        try {
            DatagramSocket datagramSocket = new DatagramSocket(0);
            byte[] byArray = new byte[1];
            DatagramPacket datagramPacket = new DatagramPacket(byArray, 1, InetAddress.getLocalHost(), this._socketPort);
            datagramSocket.send(datagramPacket);
            datagramSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (this._sockThread != null && this._sockThread.isAlive()) {
            this._sockThread.interrupt();
            try {
                this._sockThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._sockThread = null;
        }
    }

    public void run() {
        Thread.currentThread().setPriority(8);
        block5: while (true) {
            try {
                while (true) {
                    DatagramPacket datagramPacket = new DatagramPacket(this._buffer, this._buffer.length);
                    if (this.isTraceOn()) {
                        this.trace("run", "[" + Thread.currentThread().toString() + "]:" + "Blocking for receiving packet");
                    }
                    this._socket.receive(datagramPacket);
                    if (this.isClosing) break block5;
                    if (this.isTraceOn()) {
                        this.trace("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet");
                    }
                    if (datagramPacket.getLength() <= 0) continue;
                    if (this.isTraceOn()) {
                        this.trace("run", "[" + Thread.currentThread().toString() + "]:" + "Received a packet from : " + datagramPacket.getAddress().toString() + ", Length = " + datagramPacket.getLength());
                    }
                    this.handleDatagram(datagramPacket);
                    if (this.isClosing) break;
                }
            }
            catch (IOException iOException) {
                if (this.isClosing) break;
                if (!this.isDebugOn()) continue;
                this.debug("run", iOException.getMessage());
                this.debug("run", iOException);
                continue;
            }
            catch (Exception exception) {
                if (this.isClosing) break;
                if (!this.isDebugOn()) continue;
                this.debug("run", "Exception in socket thread...");
                this.debug("run", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (this.isDebugOn()) {
                    this.debug("run", "Socket Thread DEAD..." + this.toString());
                    this.debug("run", threadDeath);
                }
                this.close();
                throw threadDeath;
            }
            catch (Error error) {
                if (this.isDebugOn()) {
                    this.debug("run", error);
                }
                this.handleJavaError(error);
                continue;
            }
            break;
        }
    }

    public synchronized void finalize() {
        this.close();
    }

    private synchronized void handleJavaError(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            if (this.isDebugOn()) {
                this.debug("handleJavaError", throwable);
            }
            Thread.currentThread();
            Thread.yield();
            return;
        }
        if (this._socket != null) {
            this._socket.close();
            this._socket = null;
        }
        if (this.isDebugOn()) {
            this.debug("handleJavaError", "Global Internal error");
        }
        Thread.currentThread();
        Thread.yield();
    }

    private synchronized void handleDatagram(DatagramPacket datagramPacket) {
        this._dgramHdlr.processDatagram(datagramPacket);
    }

    boolean isTraceOn() {
        return Trace.isSelected(1, 256);
    }

    void trace(String string, String string2, String string3) {
        Trace.send(1, 256, string, string2, string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    void debug(String string, String string2, String string3) {
        Trace.send(2, 256, string, string2, string3);
    }

    void debug(String string, String string2, Throwable throwable) {
        Trace.send(2, 256, string, string2, throwable);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    void debug(String string, Throwable throwable) {
        this.debug(this.dbgTag, string, throwable);
    }
}

