/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.spi.NamingManager;

class ServiceLocator {
    private static final String SRV_RR = "SRV";
    private static final String[] SRV_RR_ATTR = new String[]{"SRV"};
    private static final Random random = new Random();

    private ServiceLocator() {
    }

    static String mapDnToDomainName(String string) throws InvalidNameException {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        LdapName ldapName = new LdapName(string);
        List<Rdn> list = ldapName.getRdns();
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            Rdn rdn = list.get(i2);
            if (rdn.size() == 1 && "dc".equalsIgnoreCase(rdn.getType())) {
                Object object = rdn.getValue();
                if (object instanceof String) {
                    if (object.equals(".") || stringBuffer.length() == 1 && stringBuffer.charAt(0) == '.') {
                        stringBuffer.setLength(0);
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(object);
                    continue;
                }
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.setLength(0);
        }
        return stringBuffer.length() != 0 ? stringBuffer.toString() : null;
    }

    static String[] getLdapService(String string, Hashtable hashtable) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = "dns:///_ldap._tcp." + string;
        String[] stringArray = null;
        try {
            Attribute attribute;
            Context context = NamingManager.getURLContext("dns", hashtable);
            if (!(context instanceof DirContext)) {
                return null;
            }
            Attributes attributes = ((DirContext)context).getAttributes(string2, SRV_RR_ATTR);
            if (attributes != null && (attribute = attributes.get(SRV_RR)) != null) {
                int n2 = attribute.size();
                int n3 = 0;
                Object[] objectArray = new SrvRecord[n2];
                int n4 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    try {
                        objectArray[n4] = new SrvRecord((String)attribute.get(i2));
                        ++n4;
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                n3 = n4;
                if (n3 < n2) {
                    SrvRecord[] srvRecordArray = new SrvRecord[n3];
                    System.arraycopy(objectArray, 0, srvRecordArray, 0, n3);
                    objectArray = srvRecordArray;
                }
                if (n3 > 1) {
                    Arrays.sort(objectArray);
                }
                stringArray = ServiceLocator.extractHostports((SrvRecord[])objectArray);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return stringArray;
    }

    private static String[] extractHostports(SrvRecord[] srvRecordArray) {
        String[] stringArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < srvRecordArray.length; ++i2) {
            if (stringArray == null) {
                stringArray = new String[srvRecordArray.length];
            }
            n2 = i2;
            while (i2 < srvRecordArray.length - 1 && srvRecordArray[i2].priority == srvRecordArray[i2 + 1].priority) {
                ++i2;
            }
            n3 = i2;
            n4 = n3 - n2 + 1;
            for (int i3 = 0; i3 < n4; ++i3) {
                stringArray[n5++] = ServiceLocator.selectHostport(srvRecordArray, n2, n3);
            }
        }
        return stringArray;
    }

    private static String selectHostport(SrvRecord[] srvRecordArray, int n2, int n3) {
        if (n2 == n3) {
            return srvRecordArray[n2].hostport;
        }
        int n4 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (srvRecordArray[i2] == null) continue;
            srvRecordArray[i2].sum = n4 += srvRecordArray[i2].weight;
        }
        String string = null;
        int n5 = n4 == 0 ? 0 : random.nextInt(n4 + 1);
        for (int i3 = n2; i3 <= n3; ++i3) {
            if (srvRecordArray[i3] == null || srvRecordArray[i3].sum < n5) continue;
            string = srvRecordArray[i3].hostport;
            srvRecordArray[i3] = null;
            break;
        }
        return string;
    }

    static class SrvRecord
    implements Comparable {
        int priority;
        int weight;
        int sum;
        String hostport;

        SrvRecord(String string) throws Exception {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            if (stringTokenizer.countTokens() != 4) {
                throw new IllegalArgumentException();
            }
            this.priority = Integer.parseInt(stringTokenizer.nextToken());
            this.weight = Integer.parseInt(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            this.hostport = stringTokenizer.nextToken() + ":" + string2;
        }

        public int compareTo(Object object) {
            SrvRecord srvRecord = (SrvRecord)object;
            if (this.priority > srvRecord.priority) {
                return 1;
            }
            if (this.priority < srvRecord.priority) {
                return -1;
            }
            if (this.weight == 0 && srvRecord.weight != 0) {
                return -1;
            }
            if (this.weight != 0 && srvRecord.weight == 0) {
                return 1;
            }
            return 0;
        }
    }
}

