/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.StackProducer;
import com.sun.org.apache.bcel.internal.generic.VariableLengthInstruction;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Select
extends BranchInstruction
implements VariableLengthInstruction,
StackProducer {
    protected int[] match;
    protected int[] indices;
    protected InstructionHandle[] targets;
    protected int fixed_length;
    protected int match_length;
    protected int padding = 0;

    Select() {
    }

    Select(short s2, int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super(s2, instructionHandle);
        this.targets = instructionHandleArray;
        for (int i2 = 0; i2 < instructionHandleArray.length; ++i2) {
            Select.notifyTarget(null, instructionHandleArray[i2], this);
        }
        this.match = nArray;
        this.match_length = nArray.length;
        if (this.match_length != instructionHandleArray.length) {
            throw new ClassGenException("Match and target array have not the same length");
        }
        this.indices = new int[this.match_length];
    }

    protected int updatePosition(int n2, int n3) {
        this.position += n2;
        short s2 = this.length;
        this.padding = (4 - (this.position + 1) % 4) % 4;
        this.length = (short)(this.fixed_length + this.padding);
        return this.length - s2;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        for (int i2 = 0; i2 < this.padding; ++i2) {
            dataOutputStream.writeByte(0);
        }
        this.index = this.getTargetOffset();
        dataOutputStream.writeInt(this.index);
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) throws IOException {
        this.padding = (4 - byteSequence.getIndex() % 4) % 4;
        for (int i2 = 0; i2 < this.padding; ++i2) {
            byte by = byteSequence.readByte();
            if (by == 0) continue;
            throw new ClassGenException("Padding byte != 0: " + by);
        }
        this.index = byteSequence.readInt();
    }

    public String toString(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(super.toString(bl2));
        if (bl2) {
            for (int i2 = 0; i2 < this.match_length; ++i2) {
                String string = "null";
                if (this.targets[i2] != null) {
                    string = this.targets[i2].getInstruction().toString();
                }
                stringBuffer.append("(" + this.match[i2] + ", " + string + " = {" + this.indices[i2] + "})");
            }
        } else {
            stringBuffer.append(" ...");
        }
        return stringBuffer.toString();
    }

    public void setTarget(int n2, InstructionHandle instructionHandle) {
        Select.notifyTarget(this.targets[n2], instructionHandle, this);
        this.targets[n2] = instructionHandle;
    }

    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl2 = false;
        if (this.target == instructionHandle) {
            bl2 = true;
            this.setTarget(instructionHandle2);
        }
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            if (this.targets[i2] != instructionHandle) continue;
            bl2 = true;
            this.setTarget(i2, instructionHandle2);
        }
        if (!bl2) {
            throw new ClassGenException("Not targeting " + instructionHandle);
        }
    }

    public boolean containsTarget(InstructionHandle instructionHandle) {
        if (this.target == instructionHandle) {
            return true;
        }
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            if (this.targets[i2] != instructionHandle) continue;
            return true;
        }
        return false;
    }

    void dispose() {
        super.dispose();
        for (int i2 = 0; i2 < this.targets.length; ++i2) {
            this.targets[i2].removeTargeter(this);
        }
    }

    public int[] getMatchs() {
        return this.match;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public InstructionHandle[] getTargets() {
        return this.targets;
    }
}

