/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.DocumentImpl;
import com.sun.org.apache.xerces.internal.dom.RangeExceptionImpl;
import com.sun.org.apache.xerces.internal.dom.TextImpl;
import java.util.Vector;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.ranges.Range;
import org.w3c.dom.ranges.RangeException;

public class RangeImpl
implements Range {
    DocumentImpl fDocument;
    Node fStartContainer;
    Node fEndContainer;
    int fStartOffset;
    int fEndOffset;
    boolean fIsCollapsed;
    boolean fDetach = false;
    Node fInsertNode = null;
    Node fDeleteNode = null;
    Node fSplitNode = null;
    Node fRemoveChild = null;
    static final int EXTRACT_CONTENTS = 1;
    static final int CLONE_CONTENTS = 2;
    static final int DELETE_CONTENTS = 3;

    public RangeImpl(DocumentImpl documentImpl) {
        this.fDocument = documentImpl;
        this.fStartContainer = documentImpl;
        this.fEndContainer = documentImpl;
        this.fStartOffset = 0;
        this.fEndOffset = 0;
        this.fDetach = false;
    }

    public Node getStartContainer() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fStartContainer;
    }

    public int getStartOffset() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fStartOffset;
    }

    public Node getEndContainer() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fEndContainer;
    }

    public int getEndOffset() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fEndOffset;
    }

    public boolean getCollapsed() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        return this.fStartContainer == this.fEndContainer && this.fStartOffset == this.fEndOffset;
    }

    public Node getCommonAncestorContainer() {
        Node node;
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        Vector<Node> vector = new Vector<Node>();
        for (node = this.fStartContainer; node != null; node = node.getParentNode()) {
            vector.addElement(node);
        }
        Vector<Node> vector2 = new Vector<Node>();
        for (node = this.fEndContainer; node != null; node = node.getParentNode()) {
            vector2.addElement(node);
        }
        int n2 = vector.size() - 1;
        Object var6_6 = null;
        for (int i2 = vector2.size() - 1; n2 >= 0 && i2 >= 0 && vector.elementAt(n2) == vector2.elementAt(i2); --n2, --i2) {
            var6_6 = vector.elementAt(n2);
        }
        return var6_6;
    }

    public void setStart(Node node, int n2) throws RangeException, DOMException {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (!this.isLegalContainer(node)) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument() && this.fDocument != node) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        this.checkIndex(node, n2);
        this.fStartContainer = node;
        this.fStartOffset = n2;
    }

    public void setEnd(Node node, int n2) throws RangeException, DOMException {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (!this.isLegalContainer(node)) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument() && this.fDocument != node) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        this.checkIndex(node, n2);
        this.fEndContainer = node;
        this.fEndOffset = n2;
    }

    public void setStartBefore(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (!this.hasLegalRootContainer(node) || !this.isLegalContainedNode(node)) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument() && this.fDocument != node) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        this.fStartContainer = node.getParentNode();
        int n2 = 0;
        for (Node node2 = node; node2 != null; node2 = node2.getPreviousSibling()) {
            ++n2;
        }
        this.fStartOffset = n2 - 1;
    }

    public void setStartAfter(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (!this.hasLegalRootContainer(node) || !this.isLegalContainedNode(node)) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument() && this.fDocument != node) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        this.fStartContainer = node.getParentNode();
        int n2 = 0;
        for (Node node2 = node; node2 != null; node2 = node2.getPreviousSibling()) {
            ++n2;
        }
        this.fStartOffset = n2;
    }

    public void setEndBefore(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (!this.hasLegalRootContainer(node) || !this.isLegalContainedNode(node)) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument() && this.fDocument != node) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        this.fEndContainer = node.getParentNode();
        int n2 = 0;
        for (Node node2 = node; node2 != null; node2 = node2.getPreviousSibling()) {
            ++n2;
        }
        this.fEndOffset = n2 - 1;
    }

    public void setEndAfter(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (!this.hasLegalRootContainer(node) || !this.isLegalContainedNode(node)) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument() && this.fDocument != node) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        this.fEndContainer = node.getParentNode();
        int n2 = 0;
        for (Node node2 = node; node2 != null; node2 = node2.getPreviousSibling()) {
            ++n2;
        }
        this.fEndOffset = n2;
    }

    public void collapse(boolean bl2) {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (bl2) {
            this.fEndContainer = this.fStartContainer;
            this.fEndOffset = this.fStartOffset;
        } else {
            this.fStartContainer = this.fEndContainer;
            this.fStartOffset = this.fEndOffset;
        }
    }

    public void selectNode(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (!this.isLegalContainer(node.getParentNode()) || !this.isLegalContainedNode(node)) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument() && this.fDocument != node) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        Node node2 = node.getParentNode();
        if (node2 != null) {
            this.fStartContainer = node2;
            this.fEndContainer = node2;
            int n2 = 0;
            for (Node node3 = node; node3 != null; node3 = node3.getPreviousSibling()) {
                ++n2;
            }
            this.fStartOffset = n2 - 1;
            this.fEndOffset = this.fStartOffset + 1;
        }
    }

    public void selectNodeContents(Node node) throws RangeException {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (!this.isLegalContainer(node)) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument() && this.fDocument != node) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        this.fStartContainer = node;
        this.fEndContainer = node;
        Node node2 = node.getFirstChild();
        this.fStartOffset = 0;
        if (node2 == null) {
            this.fEndOffset = 0;
        } else {
            int n2 = 0;
            for (Node node3 = node2; node3 != null; node3 = node3.getNextSibling()) {
                ++n2;
            }
            this.fEndOffset = n2;
        }
    }

    public short compareBoundaryPoints(short s2, Range range) throws DOMException {
        Node node;
        int n2;
        int n3;
        Node node2;
        Node node3;
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (s2 == 0) {
            node3 = range.getStartContainer();
            node2 = this.fStartContainer;
            n3 = range.getStartOffset();
            n2 = this.fStartOffset;
        } else if (s2 == 1) {
            node3 = range.getStartContainer();
            node2 = this.fEndContainer;
            n3 = range.getStartOffset();
            n2 = this.fEndOffset;
        } else if (s2 == 3) {
            node3 = range.getEndContainer();
            node2 = this.fStartContainer;
            n3 = range.getEndOffset();
            n2 = this.fStartOffset;
        } else {
            node3 = range.getEndContainer();
            node2 = this.fEndContainer;
            n3 = range.getEndOffset();
            n2 = this.fEndOffset;
        }
        if (node3 == node2) {
            if (n3 < n2) {
                return 1;
            }
            if (n3 == n2) {
                return 0;
            }
            return -1;
        }
        Node node4 = node2;
        for (node = node4.getParentNode(); node != null; node = node.getParentNode()) {
            if (node == node3) {
                int n4 = this.indexOf(node4, node3);
                if (n3 <= n4) {
                    return 1;
                }
                return -1;
            }
            node4 = node;
        }
        node4 = node3;
        for (node = node4.getParentNode(); node != null; node = node.getParentNode()) {
            if (node == node2) {
                int n5 = this.indexOf(node4, node2);
                if (n5 < n2) {
                    return 1;
                }
                return -1;
            }
            node4 = node;
        }
        int n6 = 0;
        for (node = node3; node != null; node = node.getParentNode()) {
            ++n6;
        }
        for (node = node2; node != null; node = node.getParentNode()) {
            --n6;
        }
        while (n6 > 0) {
            node3 = node3.getParentNode();
            --n6;
        }
        while (n6 < 0) {
            node2 = node2.getParentNode();
            ++n6;
        }
        node = node3.getParentNode();
        for (Node node5 = node2.getParentNode(); node != node5; node = node.getParentNode(), node5 = node5.getParentNode()) {
            node3 = node;
            node2 = node5;
        }
        for (node = node3.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node != node2) continue;
            return 1;
        }
        return -1;
    }

    public void deleteContents() throws DOMException {
        this.traverseContents(3);
    }

    public DocumentFragment extractContents() throws DOMException {
        return this.traverseContents(1);
    }

    public DocumentFragment cloneContents() throws DOMException {
        return this.traverseContents(2);
    }

    public void insertNode(Node node) throws DOMException, RangeException {
        if (node == null) {
            return;
        }
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (this.fDocument != node.getOwnerDocument()) {
            throw new DOMException(4, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null));
        }
        short s2 = node.getNodeType();
        if (s2 == 2 || s2 == 6 || s2 == 12 || s2 == 9) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        int n2 = 0;
        if (this.fStartContainer.getNodeType() == 3) {
            Node node2 = this.fStartContainer.getParentNode();
            n2 = node2.getChildNodes().getLength();
            Node node3 = this.fStartContainer.cloneNode(false);
            ((TextImpl)node3).setNodeValueInternal(node3.getNodeValue().substring(this.fStartOffset));
            ((TextImpl)this.fStartContainer).setNodeValueInternal(this.fStartContainer.getNodeValue().substring(0, this.fStartOffset));
            Node node4 = this.fStartContainer.getNextSibling();
            if (node4 != null) {
                if (node2 != null) {
                    node2.insertBefore(node, node4);
                    node2.insertBefore(node3, node4);
                }
            } else if (node2 != null) {
                node2.appendChild(node);
                node2.appendChild(node3);
            }
            if (this.fEndContainer == this.fStartContainer) {
                this.fEndContainer = node3;
                this.fEndOffset -= this.fStartOffset;
            } else if (this.fEndContainer == node2) {
                this.fEndOffset += node2.getChildNodes().getLength() - n2;
            }
            this.signalSplitData(this.fStartContainer, node3, this.fStartOffset);
        } else {
            if (this.fEndContainer == this.fStartContainer) {
                n2 = this.fEndContainer.getChildNodes().getLength();
            }
            Node node5 = this.fStartContainer.getFirstChild();
            int n3 = 0;
            for (n3 = 0; n3 < this.fStartOffset && node5 != null; node5 = node5.getNextSibling(), ++n3) {
            }
            if (node5 != null) {
                this.fStartContainer.insertBefore(node, node5);
            } else {
                this.fStartContainer.appendChild(node);
            }
            if (this.fEndContainer == this.fStartContainer) {
                this.fEndOffset += this.fEndContainer.getChildNodes().getLength() - n2;
            }
        }
    }

    public void surroundContents(Node node) throws DOMException, RangeException {
        if (node == null) {
            return;
        }
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        short s2 = node.getNodeType();
        if (s2 == 2 || s2 == 6 || s2 == 12 || s2 == 10 || s2 == 9 || s2 == 11) {
            throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
        }
        Node node2 = this.getCommonAncestorContainer();
        Node node3 = this.fStartContainer;
        Node node4 = this.fEndContainer;
        if (this.fStartContainer.getNodeType() == 3) {
            node3 = this.fStartContainer.getParentNode();
        }
        if (this.fEndContainer.getNodeType() == 3) {
            node4 = this.fEndContainer.getParentNode();
        }
        if (node3 != node4) {
            throw new RangeExceptionImpl(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "BAD_BOUNDARYPOINTS_ERR", null));
        }
        DocumentFragment documentFragment = this.extractContents();
        this.insertNode(node);
        node.appendChild(documentFragment);
        this.selectNode(node);
    }

    public Range cloneRange() {
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        Range range = this.fDocument.createRange();
        range.setStart(this.fStartContainer, this.fStartOffset);
        range.setEnd(this.fEndContainer, this.fEndOffset);
        return range;
    }

    public String toString() {
        int n2;
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        Node node = this.fStartContainer;
        Node node2 = this.fEndContainer;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fStartContainer.getNodeType() == 3 || this.fStartContainer.getNodeType() == 4) {
            if (this.fStartContainer == this.fEndContainer) {
                stringBuffer.append(this.fStartContainer.getNodeValue().substring(this.fStartOffset, this.fEndOffset));
                return stringBuffer.toString();
            }
            stringBuffer.append(this.fStartContainer.getNodeValue().substring(this.fStartOffset));
            node = this.nextNode(node, true);
        } else {
            node = node.getFirstChild();
            if (this.fStartOffset > 0) {
                for (n2 = 0; n2 < this.fStartOffset && node != null; node = node.getNextSibling(), ++n2) {
                }
            }
            if (node == null) {
                node = this.nextNode(this.fStartContainer, false);
            }
        }
        if (this.fEndContainer.getNodeType() != 3 && this.fEndContainer.getNodeType() != 4) {
            n2 = this.fEndOffset;
            for (node2 = this.fEndContainer.getFirstChild(); n2 > 0 && node2 != null; --n2, node2 = node2.getNextSibling()) {
            }
            if (node2 == null) {
                node2 = this.nextNode(this.fEndContainer, false);
            }
        }
        while (node != node2 && node != null) {
            if (node.getNodeType() == 3 || node.getNodeType() == 4) {
                stringBuffer.append(node.getNodeValue());
            }
            node = this.nextNode(node, true);
        }
        if (this.fEndContainer.getNodeType() == 3 || this.fEndContainer.getNodeType() == 4) {
            stringBuffer.append(this.fEndContainer.getNodeValue().substring(0, this.fEndOffset));
        }
        return stringBuffer.toString();
    }

    public void detach() {
        this.fDetach = true;
        this.fDocument.removeRange(this);
    }

    void signalSplitData(Node node, Node node2, int n2) {
        this.fSplitNode = node;
        this.fDocument.splitData(node, node2, n2);
        this.fSplitNode = null;
    }

    void receiveSplitData(Node node, Node node2, int n2) {
        if (node == null || node2 == null) {
            return;
        }
        if (this.fSplitNode == node) {
            return;
        }
        if (node == this.fStartContainer && this.fStartContainer.getNodeType() == 3 && this.fStartOffset > n2) {
            this.fStartOffset -= n2;
            this.fStartContainer = node2;
        }
        if (node == this.fEndContainer && this.fEndContainer.getNodeType() == 3 && this.fEndOffset > n2) {
            this.fEndOffset -= n2;
            this.fEndContainer = node2;
        }
    }

    void deleteData(CharacterData characterData, int n2, int n3) {
        this.fDeleteNode = characterData;
        characterData.deleteData(n2, n3);
        this.fDeleteNode = null;
    }

    void receiveDeletedText(Node node, int n2, int n3) {
        if (node == null) {
            return;
        }
        if (this.fDeleteNode == node) {
            return;
        }
        if (node == this.fStartContainer && this.fStartContainer.getNodeType() == 3) {
            if (this.fStartOffset > n2 + n3) {
                this.fStartOffset = n2 + (this.fStartOffset - (n2 + n3));
            } else if (this.fStartOffset > n2) {
                this.fStartOffset = n2;
            }
        }
        if (node == this.fEndContainer && this.fEndContainer.getNodeType() == 3) {
            if (this.fEndOffset > n2 + n3) {
                this.fEndOffset = n2 + (this.fEndOffset - (n2 + n3));
            } else if (this.fEndOffset > n2) {
                this.fEndOffset = n2;
            }
        }
    }

    void insertData(CharacterData characterData, int n2, String string) {
        this.fInsertNode = characterData;
        characterData.insertData(n2, string);
        this.fInsertNode = null;
    }

    void receiveInsertedText(Node node, int n2, int n3) {
        if (node == null) {
            return;
        }
        if (this.fInsertNode == node) {
            return;
        }
        if (node == this.fStartContainer && this.fStartContainer.getNodeType() == 3 && n2 < this.fStartOffset) {
            this.fStartOffset += n3;
        }
        if (node == this.fEndContainer && this.fEndContainer.getNodeType() == 3 && n2 < this.fEndOffset) {
            this.fEndOffset += n3;
        }
    }

    void receiveReplacedText(Node node) {
        if (node == null) {
            return;
        }
        if (node == this.fStartContainer && this.fStartContainer.getNodeType() == 3) {
            this.fStartOffset = 0;
        }
        if (node == this.fEndContainer && this.fEndContainer.getNodeType() == 3) {
            this.fEndOffset = 0;
        }
    }

    public void insertedNodeFromDOM(Node node) {
        int n2;
        if (node == null) {
            return;
        }
        if (this.fInsertNode == node) {
            return;
        }
        Node node2 = node.getParentNode();
        if (node2 == this.fStartContainer && (n2 = this.indexOf(node, this.fStartContainer)) < this.fStartOffset) {
            ++this.fStartOffset;
        }
        if (node2 == this.fEndContainer && (n2 = this.indexOf(node, this.fEndContainer)) < this.fEndOffset) {
            ++this.fEndOffset;
        }
    }

    Node removeChild(Node node, Node node2) {
        this.fRemoveChild = node2;
        Node node3 = node.removeChild(node2);
        this.fRemoveChild = null;
        return node3;
    }

    void removeNode(Node node) {
        int n2;
        if (node == null) {
            return;
        }
        if (this.fRemoveChild == node) {
            return;
        }
        Node node2 = node.getParentNode();
        if (node2 == this.fStartContainer && (n2 = this.indexOf(node, this.fStartContainer)) < this.fStartOffset) {
            --this.fStartOffset;
        }
        if (node2 == this.fEndContainer && (n2 = this.indexOf(node, this.fEndContainer)) < this.fEndOffset) {
            --this.fEndOffset;
        }
        if (node2 != this.fStartContainer || node2 != this.fEndContainer) {
            if (this.isAncestorOf(node, this.fStartContainer)) {
                this.fStartContainer = node2;
                this.fStartOffset = this.indexOf(node, node2);
            }
            if (this.isAncestorOf(node, this.fEndContainer)) {
                this.fEndContainer = node2;
                this.fEndOffset = this.indexOf(node, node2);
            }
        }
    }

    private DocumentFragment traverseContents(int n2) throws DOMException {
        int n3;
        Node node;
        Node node2;
        if (this.fStartContainer == null || this.fEndContainer == null) {
            return null;
        }
        if (this.fDetach) {
            throw new DOMException(11, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_STATE_ERR", null));
        }
        if (this.fStartContainer == this.fEndContainer) {
            return this.traverseSameContainer(n2);
        }
        int n4 = 0;
        Node node3 = this.fEndContainer;
        for (node2 = node3.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            if (node2 == this.fStartContainer) {
                return this.traverseCommonStartContainer(node3, n2);
            }
            ++n4;
            node3 = node2;
        }
        int n5 = 0;
        node2 = this.fStartContainer;
        for (node = node2.getParentNode(); node != null; node = node.getParentNode()) {
            if (node == this.fEndContainer) {
                return this.traverseCommonEndContainer(node2, n2);
            }
            ++n5;
            node2 = node;
        }
        node = this.fStartContainer;
        for (n3 = n5 - n4; n3 > 0; --n3) {
            node = node.getParentNode();
        }
        Node node4 = this.fEndContainer;
        while (n3 < 0) {
            node4 = node4.getParentNode();
            ++n3;
        }
        Node node5 = node.getParentNode();
        for (Node node6 = node4.getParentNode(); node5 != node6; node5 = node5.getParentNode(), node6 = node6.getParentNode()) {
            node = node5;
            node4 = node6;
        }
        return this.traverseCommonAncestors(node, node4, n2);
    }

    private DocumentFragment traverseSameContainer(int n2) {
        DocumentFragment documentFragment = null;
        if (n2 != 3) {
            documentFragment = this.fDocument.createDocumentFragment();
        }
        if (this.fStartOffset == this.fEndOffset) {
            return documentFragment;
        }
        if (this.fStartContainer.getNodeType() == 3) {
            String string = this.fStartContainer.getNodeValue();
            String string2 = string.substring(this.fStartOffset, this.fEndOffset);
            if (n2 != 2) {
                ((TextImpl)this.fStartContainer).deleteData(this.fStartOffset, this.fEndOffset - this.fStartOffset);
                this.collapse(true);
            }
            if (n2 == 3) {
                return null;
            }
            documentFragment.appendChild(this.fDocument.createTextNode(string2));
            return documentFragment;
        }
        Node node = this.getSelectedNode(this.fStartContainer, this.fStartOffset);
        for (int i2 = this.fEndOffset - this.fStartOffset; i2 > 0; --i2) {
            Node node2 = node.getNextSibling();
            Node node3 = this.traverseFullySelected(node, n2);
            if (documentFragment != null) {
                documentFragment.appendChild(node3);
            }
            node = node2;
        }
        if (n2 != 2) {
            this.collapse(true);
        }
        return documentFragment;
    }

    private DocumentFragment traverseCommonStartContainer(Node node, int n2) {
        int n3;
        int n4;
        DocumentFragment documentFragment = null;
        if (n2 != 3) {
            documentFragment = this.fDocument.createDocumentFragment();
        }
        Node node2 = this.traverseRightBoundary(node, n2);
        if (documentFragment != null) {
            documentFragment.appendChild(node2);
        }
        if ((n4 = (n3 = this.indexOf(node, this.fStartContainer)) - this.fStartOffset) <= 0) {
            if (n2 != 2) {
                this.setEndBefore(node);
                this.collapse(false);
            }
            return documentFragment;
        }
        node2 = node.getPreviousSibling();
        while (n4 > 0) {
            Node node3 = node2.getPreviousSibling();
            Node node4 = this.traverseFullySelected(node2, n2);
            if (documentFragment != null) {
                documentFragment.insertBefore(node4, documentFragment.getFirstChild());
            }
            --n4;
            node2 = node3;
        }
        if (n2 != 2) {
            this.setEndBefore(node);
            this.collapse(false);
        }
        return documentFragment;
    }

    private DocumentFragment traverseCommonEndContainer(Node node, int n2) {
        DocumentFragment documentFragment = null;
        if (n2 != 3) {
            documentFragment = this.fDocument.createDocumentFragment();
        }
        Node node2 = this.traverseLeftBoundary(node, n2);
        if (documentFragment != null) {
            documentFragment.appendChild(node2);
        }
        int n3 = this.indexOf(node, this.fEndContainer);
        node2 = node.getNextSibling();
        for (int i2 = this.fEndOffset - ++n3; i2 > 0; --i2) {
            Node node3 = node2.getNextSibling();
            Node node4 = this.traverseFullySelected(node2, n2);
            if (documentFragment != null) {
                documentFragment.appendChild(node4);
            }
            node2 = node3;
        }
        if (n2 != 2) {
            this.setStartAfter(node);
            this.collapse(true);
        }
        return documentFragment;
    }

    private DocumentFragment traverseCommonAncestors(Node node, Node node2, int n2) {
        DocumentFragment documentFragment = null;
        if (n2 != 3) {
            documentFragment = this.fDocument.createDocumentFragment();
        }
        Node node3 = this.traverseLeftBoundary(node, n2);
        if (documentFragment != null) {
            documentFragment.appendChild(node3);
        }
        Node node4 = node.getParentNode();
        int n3 = this.indexOf(node, node4);
        int n4 = this.indexOf(node2, node4);
        Node node5 = node.getNextSibling();
        for (int i2 = n4 - ++n3; i2 > 0; --i2) {
            Node node6 = node5.getNextSibling();
            node3 = this.traverseFullySelected(node5, n2);
            if (documentFragment != null) {
                documentFragment.appendChild(node3);
            }
            node5 = node6;
        }
        node3 = this.traverseRightBoundary(node2, n2);
        if (documentFragment != null) {
            documentFragment.appendChild(node3);
        }
        if (n2 != 2) {
            this.setStartAfter(node);
            this.collapse(true);
        }
        return documentFragment;
    }

    private Node traverseRightBoundary(Node node, int n2) {
        boolean bl2;
        Node node2 = this.getSelectedNode(this.fEndContainer, this.fEndOffset - 1);
        boolean bl3 = bl2 = node2 != this.fEndContainer;
        if (node2 == node) {
            return this.traverseNode(node2, bl2, false, n2);
        }
        Node node3 = node2.getParentNode();
        Node node4 = this.traverseNode(node3, false, false, n2);
        while (node3 != null) {
            Node node5;
            while (node2 != null) {
                node5 = node2.getPreviousSibling();
                Node node6 = this.traverseNode(node2, bl2, false, n2);
                if (n2 != 3) {
                    node4.insertBefore(node6, node4.getFirstChild());
                }
                bl2 = true;
                node2 = node5;
            }
            if (node3 == node) {
                return node4;
            }
            node2 = node3.getPreviousSibling();
            node3 = node3.getParentNode();
            node5 = this.traverseNode(node3, false, false, n2);
            if (n2 != 3) {
                node5.appendChild(node4);
            }
            node4 = node5;
        }
        return null;
    }

    private Node traverseLeftBoundary(Node node, int n2) {
        boolean bl2;
        Node node2 = this.getSelectedNode(this.getStartContainer(), this.getStartOffset());
        boolean bl3 = bl2 = node2 != this.getStartContainer();
        if (node2 == node) {
            return this.traverseNode(node2, bl2, true, n2);
        }
        Node node3 = node2.getParentNode();
        Node node4 = this.traverseNode(node3, false, true, n2);
        while (node3 != null) {
            Node node5;
            while (node2 != null) {
                node5 = node2.getNextSibling();
                Node node6 = this.traverseNode(node2, bl2, true, n2);
                if (n2 != 3) {
                    node4.appendChild(node6);
                }
                bl2 = true;
                node2 = node5;
            }
            if (node3 == node) {
                return node4;
            }
            node2 = node3.getNextSibling();
            node3 = node3.getParentNode();
            node5 = this.traverseNode(node3, false, true, n2);
            if (n2 != 3) {
                node5.appendChild(node4);
            }
            node4 = node5;
        }
        return null;
    }

    private Node traverseNode(Node node, boolean bl2, boolean bl3, int n2) {
        if (bl2) {
            return this.traverseFullySelected(node, n2);
        }
        if (node.getNodeType() == 3) {
            return this.traverseTextNode(node, bl3, n2);
        }
        return this.traversePartiallySelected(node, n2);
    }

    private Node traverseFullySelected(Node node, int n2) {
        switch (n2) {
            case 2: {
                return node.cloneNode(true);
            }
            case 1: {
                if (node.getNodeType() == 10) {
                    throw new RangeExceptionImpl(2, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INVALID_NODE_TYPE_ERR", null));
                }
                return node;
            }
            case 3: {
                node.getParentNode().removeChild(node);
                return null;
            }
        }
        return null;
    }

    private Node traversePartiallySelected(Node node, int n2) {
        switch (n2) {
            case 3: {
                return null;
            }
            case 1: 
            case 2: {
                return node.cloneNode(false);
            }
        }
        return null;
    }

    private Node traverseTextNode(Node node, boolean bl2, int n2) {
        String string;
        String string2;
        int n3;
        String string3 = node.getNodeValue();
        if (bl2) {
            n3 = this.getStartOffset();
            string2 = string3.substring(n3);
            string = string3.substring(0, n3);
        } else {
            n3 = this.getEndOffset();
            string2 = string3.substring(0, n3);
            string = string3.substring(n3);
        }
        if (n2 != 2) {
            node.setNodeValue(string);
        }
        if (n2 == 3) {
            return null;
        }
        Node node2 = node.cloneNode(false);
        node2.setNodeValue(string2);
        return node2;
    }

    void checkIndex(Node node, int n2) throws DOMException {
        if (n2 < 0) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
        short s2 = node.getNodeType();
        if (s2 == 3 || s2 == 4 || s2 == 8 || s2 == 7 ? n2 > node.getNodeValue().length() : n2 > node.getChildNodes().getLength()) {
            throw new DOMException(1, DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INDEX_SIZE_ERR", null));
        }
    }

    private Node getRootContainer(Node node) {
        if (node == null) {
            return null;
        }
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    private boolean isLegalContainer(Node node) {
        if (node == null) {
            return false;
        }
        while (node != null) {
            switch (node.getNodeType()) {
                case 6: 
                case 10: 
                case 12: {
                    return false;
                }
            }
            node = node.getParentNode();
        }
        return true;
    }

    private boolean hasLegalRootContainer(Node node) {
        if (node == null) {
            return false;
        }
        Node node2 = this.getRootContainer(node);
        switch (node2.getNodeType()) {
            case 2: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private boolean isLegalContainedNode(Node node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 2: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                return false;
            }
        }
        return true;
    }

    Node nextNode(Node node, boolean bl2) {
        Node node2;
        if (node == null) {
            return null;
        }
        if (bl2 && (node2 = node.getFirstChild()) != null) {
            return node2;
        }
        node2 = node.getNextSibling();
        if (node2 != null) {
            return node2;
        }
        for (Node node3 = node.getParentNode(); node3 != null && node3 != this.fDocument; node3 = node3.getParentNode()) {
            node2 = node3.getNextSibling();
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    boolean isAncestorOf(Node node, Node node2) {
        for (Node node3 = node2; node3 != null; node3 = node3.getParentNode()) {
            if (node3 != node) continue;
            return true;
        }
        return false;
    }

    int indexOf(Node node, Node node2) {
        if (node.getParentNode() != node2) {
            return -1;
        }
        int n2 = 0;
        for (Node node3 = node2.getFirstChild(); node3 != node; node3 = node3.getNextSibling()) {
            ++n2;
        }
        return n2;
    }

    private Node getSelectedNode(Node node, int n2) {
        Node node2;
        if (node.getNodeType() == 3) {
            return node;
        }
        if (n2 < 0) {
            return node;
        }
        for (node2 = node.getFirstChild(); node2 != null && n2 > 0; --n2, node2 = node2.getNextSibling()) {
        }
        if (node2 != null) {
            return node2;
        }
        return node;
    }
}

