/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;

public class PSSParameterSpec
implements AlgorithmParameterSpec {
    private String mdName = "SHA-1";
    private String mgfName = "MGF1";
    private AlgorithmParameterSpec mgfSpec = MGF1ParameterSpec.SHA1;
    private int saltLen = 20;
    private int trailerField = 1;
    public static final PSSParameterSpec DEFAULT = new PSSParameterSpec();

    private PSSParameterSpec() {
    }

    public PSSParameterSpec(String string, String string2, AlgorithmParameterSpec algorithmParameterSpec, int n2, int n3) {
        if (string == null) {
            throw new NullPointerException("digest algorithm is null");
        }
        if (string2 == null) {
            throw new NullPointerException("mask generation function algorithm is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("negative saltLen value: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative trailerField: " + n3);
        }
        this.mdName = string;
        this.mgfName = string2;
        this.mgfSpec = algorithmParameterSpec;
        this.saltLen = n2;
        this.trailerField = n3;
    }

    public PSSParameterSpec(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative saltLen value: " + n2);
        }
        this.saltLen = n2;
    }

    public String getDigestAlgorithm() {
        return this.mdName;
    }

    public String getMGFAlgorithm() {
        return this.mgfName;
    }

    public AlgorithmParameterSpec getMGFParameters() {
        return this.mgfSpec;
    }

    public int getSaltLength() {
        return this.saltLen;
    }

    public int getTrailerField() {
        return this.trailerField;
    }
}

