/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.Serializable;
import java.util.Arrays;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int base = unsafe.arrayBaseOffset(Object[].class);
    private static final int scale = unsafe.arrayIndexScale(Object[].class);
    private final Object[] array;

    private long rawIndex(int n2) {
        if (n2 < 0 || n2 >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + n2);
        }
        return base + n2 * scale;
    }

    public AtomicReferenceArray(int n2) {
        this.array = new Object[n2];
        if (n2 > 0) {
            unsafe.putObjectVolatile(this.array, this.rawIndex(0), null);
        }
    }

    public AtomicReferenceArray(E[] EArray) {
        if (EArray == null) {
            throw new NullPointerException();
        }
        int n2 = EArray.length;
        this.array = new Object[n2];
        if (n2 > 0) {
            int n3 = n2 - 1;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.array[i2] = EArray[i2];
            }
            E e2 = EArray[n3];
            unsafe.putObjectVolatile(this.array, this.rawIndex(n3), e2);
        }
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int n2) {
        return (E)unsafe.getObjectVolatile(this.array, this.rawIndex(n2));
    }

    public final void set(int n2, E e2) {
        unsafe.putObjectVolatile(this.array, this.rawIndex(n2), e2);
    }

    public final E getAndSet(int n2, E e2) {
        E e3;
        while (!this.compareAndSet(n2, e3 = this.get(n2), e2)) {
        }
        return e3;
    }

    public final boolean compareAndSet(int n2, E e2, E e3) {
        return unsafe.compareAndSwapObject(this.array, this.rawIndex(n2), e2, e3);
    }

    public final boolean weakCompareAndSet(int n2, E e2, E e3) {
        return this.compareAndSet(n2, e2, e3);
    }

    public String toString() {
        if (this.array.length > 0) {
            this.get(0);
        }
        return Arrays.toString(this.array);
    }
}

