/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;
import javax.management.relation.RoleStatus;

public class RoleUnresolved
implements Serializable {
    private static final long oldSerialVersionUID = -9026457686611660144L;
    private static final long newSerialVersionUID = -48350262537070138L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("myRoleName", String.class), new ObjectStreamField("myRoleValue", ArrayList.class), new ObjectStreamField("myPbType", Integer.TYPE)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("roleName", String.class), new ObjectStreamField("roleValue", List.class), new ObjectStreamField("problemType", Integer.TYPE)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private String roleName = null;
    private List roleValue = null;
    private int problemType;

    public RoleUnresolved(String string, List list, int n2) throws IllegalArgumentException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        this.setRoleName(string);
        this.setRoleValue(list);
        this.setProblemType(n2);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public List getRoleValue() {
        return this.roleValue;
    }

    public int getProblemType() {
        return this.problemType;
    }

    public void setRoleName(String string) throws IllegalArgumentException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        this.roleName = string;
    }

    public void setRoleValue(List list) {
        this.roleValue = list != null ? new ArrayList(list) : null;
    }

    public void setProblemType(int n2) throws IllegalArgumentException {
        if (!RoleStatus.isRoleStatus(n2)) {
            String string = "Incorrect problem type.";
            throw new IllegalArgumentException(string);
        }
        this.problemType = n2;
    }

    public Object clone() {
        try {
            return new RoleUnresolved(this.roleName, this.roleValue, this.problemType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("role name: " + this.roleName);
        if (this.roleValue != null) {
            stringBuffer.append("; value: ");
            Iterator iterator = this.roleValue.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = (ObjectName)iterator.next();
                stringBuffer.append(objectName.toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("; problem type: " + this.problemType);
        return stringBuffer.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.roleName = (String)getField.get("myRoleName", null);
            if (getField.defaulted("myRoleName")) {
                throw new NullPointerException("myRoleName");
            }
            this.roleValue = (List)getField.get("myRoleValue", null);
            if (getField.defaulted("myRoleValue")) {
                throw new NullPointerException("myRoleValue");
            }
            this.problemType = getField.get("myPbType", 0);
            if (getField.defaulted("myPbType")) {
                throw new NullPointerException("myPbType");
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("myRoleName", this.roleName);
            putField.put("myRoleValue", (ArrayList)this.roleValue);
            putField.put("myPbType", this.problemType);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = (String)AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = -9026457686611660144L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = -48350262537070138L;
        }
    }
}

