/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class CachedPainter {
    private static final Map<Object, Cache> cacheMap = new HashMap<Object, Cache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Cache getCache(Object object) {
        Map<Object, Cache> map = cacheMap;
        synchronized (map) {
            Cache cache = cacheMap.get(object);
            if (cache == null) {
                cache = new Cache(1);
                cacheMap.put(object, cache);
            }
            return cache;
        }
    }

    public CachedPainter(int n2) {
        CachedPainter.getCache(this.getClass()).setMaxCount(n2);
    }

    protected void paint(Component component, Graphics graphics, int n2, int n3, int n4, int n5, Object ... objectArray) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        Class<? extends Object> clazz = this.getClass();
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Cache cache = CachedPainter.getCache(clazz);
        Image image = cache.getImage(clazz, graphicsConfiguration, n4, n5, objectArray);
        int n6 = 0;
        do {
            boolean bl2 = false;
            if (image instanceof VolatileImage) {
                switch (((VolatileImage)image).validate(graphicsConfiguration)) {
                    case 2: {
                        ((VolatileImage)image).flush();
                        image = null;
                        break;
                    }
                    case 1: {
                        bl2 = true;
                    }
                }
            }
            if (image == null) {
                image = this.createImage(component, n4, n5, graphicsConfiguration);
                cache.setImage(clazz, graphicsConfiguration, n4, n5, objectArray, image);
                bl2 = true;
            }
            if (bl2) {
                Graphics graphics2 = image.getGraphics();
                this.paintToImage(component, graphics2, n4, n5, objectArray);
                graphics2.dispose();
            }
            this.paintImage(component, graphics, n2, n3, n4, n5, image, objectArray);
        } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost() && ++n6 < 3);
    }

    protected abstract void paintToImage(Component var1, Graphics var2, int var3, int var4, Object[] var5);

    protected void paintImage(Component component, Graphics graphics, int n2, int n3, int n4, int n5, Image image, Object[] objectArray) {
        graphics.drawImage(image, n2, n3, null);
    }

    protected Image createImage(Component component, int n2, int n3, GraphicsConfiguration graphicsConfiguration) {
        if (graphicsConfiguration == null) {
            return new BufferedImage(n2, n3, 1);
        }
        return graphicsConfiguration.createCompatibleVolatileImage(n2, n3);
    }

    private static class Cache {
        private int maxCount;
        private List<SoftReference<Entry>> entries;

        Cache(int n2) {
            this.maxCount = n2;
            this.entries = new ArrayList<SoftReference<Entry>>(n2);
        }

        void setMaxCount(int n2) {
            this.maxCount = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Entry getEntry(Object object, GraphicsConfiguration graphicsConfiguration, int n2, int n3, Object[] objectArray) {
            Cache cache = this;
            synchronized (cache) {
                Entry entry;
                for (int i2 = this.entries.size() - 1; i2 >= 0; --i2) {
                    entry = this.entries.get(i2).get();
                    if (entry == null) {
                        this.entries.remove(i2);
                        continue;
                    }
                    if (!entry.equals(graphicsConfiguration, n2, n3, objectArray)) continue;
                    return entry;
                }
                entry = new Entry(graphicsConfiguration, n2, n3, objectArray);
                if (this.entries.size() == this.maxCount) {
                    this.entries.remove(0);
                }
                this.entries.add(new SoftReference<Entry>(entry));
                return entry;
            }
        }

        public Image getImage(Object object, GraphicsConfiguration graphicsConfiguration, int n2, int n3, Object[] objectArray) {
            Entry entry = this.getEntry(object, graphicsConfiguration, n2, n3, objectArray);
            return entry.getImage();
        }

        public void setImage(Object object, GraphicsConfiguration graphicsConfiguration, int n2, int n3, Object[] objectArray, Image image) {
            Entry entry = this.getEntry(object, graphicsConfiguration, n2, n3, objectArray);
            entry.setImage(image);
        }

        private static class Entry {
            private GraphicsConfiguration config;
            private Object[] args;
            private Image image;
            private int w;
            private int h;

            Entry(GraphicsConfiguration graphicsConfiguration, int n2, int n3, Object[] objectArray) {
                this.config = graphicsConfiguration;
                this.args = objectArray;
                this.w = n2;
                this.h = n3;
            }

            public void setImage(Image image) {
                this.image = image;
            }

            public Image getImage() {
                return this.image;
            }

            public String toString() {
                String string = super.toString() + "[ graphicsConfig=" + this.config + ", image=" + this.image + ", w=" + this.w + ", h=" + this.h;
                if (this.args != null) {
                    for (int i2 = 0; i2 < this.args.length; ++i2) {
                        string = string + ", " + this.args[i2];
                    }
                }
                string = string + "]";
                return string;
            }

            public boolean equals(GraphicsConfiguration graphicsConfiguration, int n2, int n3, Object[] objectArray) {
                if (this.w == n2 && this.h == n3 && (this.config != null && this.config.equals(graphicsConfiguration) || this.config == null && graphicsConfiguration == null)) {
                    if (this.args == null && objectArray == null) {
                        return true;
                    }
                    if (this.args != null && objectArray != null && this.args.length == objectArray.length) {
                        for (int i2 = objectArray.length - 1; i2 >= 0; --i2) {
                            if (this.args[i2].equals(objectArray[i2])) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
        }
    }
}

