/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.JobAttributes;
import java.awt.KeyboardFocusManager;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.MouseEvent;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.MouseInfoPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11.AwtScreenData;
import sun.awt.X11.IXAnyEvent;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.Native;
import sun.awt.X11.XAWTLookAndFeel;
import sun.awt.X11.XAWTXSettings;
import sun.awt.X11.XAnyEvent;
import sun.awt.X11.XAtom;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonPeer;
import sun.awt.X11.XCanvasPeer;
import sun.awt.X11.XCheckboxMenuItemPeer;
import sun.awt.X11.XCheckboxPeer;
import sun.awt.X11.XChoicePeer;
import sun.awt.X11.XClipboard;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCustomCursor;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XDragSourceContextPeer;
import sun.awt.X11.XDropTargetEventProcessor;
import sun.awt.X11.XEmbedChildProxy;
import sun.awt.X11.XEmbedChildProxyPeer;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorEvent;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XFileDialogPeer;
import sun.awt.X11.XFontPeer;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XInputMethod;
import sun.awt.X11.XInputMethodDescriptor;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XLabelPeer;
import sun.awt.X11.XListPeer;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XModifierKeymap;
import sun.awt.X11.XMouseDragGestureRecognizer;
import sun.awt.X11.XMouseInfoPeer;
import sun.awt.X11.XPanelPeer;
import sun.awt.X11.XPopupMenuPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XRobotPeer;
import sun.awt.X11.XScrollPanePeer;
import sun.awt.X11.XScrollbarPeer;
import sun.awt.X11.XTextAreaPeer;
import sun.awt.X11.XTextFieldPeer;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.awt.XSettings;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XToolkit
extends UNIXToolkit
implements Runnable,
XConstants {
    private static Logger log = Logger.getLogger("sun.awt.X11.XToolkit");
    private static Logger eventLog = Logger.getLogger("sun.awt.X11.event.XToolkit");
    private static final Logger timeoutTaskLog = Logger.getLogger("sun.awt.X11.timeoutTask.XToolkit");
    static final boolean PRIMARY_LOOP = false;
    static final boolean SECONDARY_LOOP = true;
    private static String awtAppClassName = null;
    XClipboard clipboard;
    XClipboard selection;
    protected static boolean dynamicLayoutSetting = false;
    private boolean loadedXSettings;
    private XSettings xs;
    static int arrowCursor;
    static TreeMap winMap;
    static HashMap specialPeerMap;
    static HashMap winToDispatcher;
    static long display;
    static UIDefaults uidefaults;
    static X11GraphicsEnvironment localEnv;
    static X11GraphicsDevice device;
    static final X11GraphicsConfig config;
    static long tempptr;
    static int awt_multiclick_time;
    static boolean securityWarningEnabled;
    private static int screenWidth;
    private static int screenHeight;
    static long awt_defaultFg;
    private static XMouseInfoPeer xPeer;
    private static Method m_removeSourceEvents;
    static XErrorEvent saved_error;
    static long saved_error_handler;
    static XErrorHandler curErrorHandler;
    static XErrorHandler IgnoreBadWindowHandler;
    static Thread toolkitThread;
    static boolean debug;
    static Object displayLock;
    static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.X11.XDataTransferer";
    static ColorModel screenmodel;
    private static boolean initialized;
    private static boolean timeStampUpdated;
    private static long timeStamp;
    private static final XEventDispatcher timeFetcher;
    private static XAtom _XA_JAVA_TIME_PROPERTY_ATOM;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String dndPrefix = "DnD.";
    static int altMask;
    static int metaMask;
    static int numLockMask;
    static int modeSwitchMask;
    private static SortedMap timeoutTasks;
    static long reset_time_utc;
    static final long WRAP_TIME_MILLIS = Integer.MAX_VALUE;

    static void WITH_XERROR_HANDLER(XErrorHandler xErrorHandler) {
        saved_error = null;
        curErrorHandler = xErrorHandler;
        XToolkit.XSync();
        saved_error_handler = XlibWrapper.SetToolkitErrorHandler();
    }

    static void XERROR_SAVE(XErrorEvent xErrorEvent) {
        saved_error = xErrorEvent;
    }

    static void RESTORE_XERROR_HANDLER() {
        XToolkit.XSync();
        XlibWrapper.XSetErrorHandler(saved_error_handler);
        curErrorHandler = null;
    }

    static int SAVED_ERROR_HANDLER(long l2, XErrorEvent xErrorEvent) {
        return XlibWrapper.CallErrorHandler(saved_error_handler, l2, xErrorEvent.pData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int GlobalErrorHandler(long l2, long l3) {
        XErrorEvent xErrorEvent;
        block3: {
            xErrorEvent = new XErrorEvent(l3);
            if (curErrorHandler == null) break block3;
            int n2 = curErrorHandler.handleError(l2, xErrorEvent);
            return n2;
        }
        int n3 = XToolkit.SAVED_ERROR_HANDLER(l2, xErrorEvent);
        return n3;
    }

    private static native void initIDs();

    static native void waitForEvents();

    static boolean isToolkitThread() {
        return Thread.currentThread() == toolkitThread;
    }

    static void initSecurityWarning() {
        String string = XToolkit.getSystemProperty("java.runtime.version");
        securityWarningEnabled = string != null && string.contains("internal");
    }

    static boolean isSecurityWarningEnabled() {
        return securityWarningEnabled;
    }

    static final void awtLock() {
        if (debug) {
            System.out.println(" --------   awtLock --------------");
            Thread.currentThread();
            Thread.dumpStack();
        }
        XlibWrapper.unsafe.monitorEnter(XToolkit.getAWTLock());
    }

    static final void awtUnlock() {
        if (debug) {
            System.out.println(" --------   awtUnLock --------------");
            Thread.currentThread();
            Thread.dumpStack();
        }
        XlibWrapper.unsafe.monitorExit(XToolkit.getAWTLock());
    }

    static final Object getAWTLock() {
        return X11GraphicsEnvironment.class;
    }

    public native void nativeLoadSystemColors(int[] var1);

    static UIDefaults getUIDefaults() {
        if (uidefaults == null) {
            XToolkit.initUIDefaults();
        }
        return uidefaults;
    }

    @Override
    public void loadSystemColors(int[] nArray) {
        this.nativeLoadSystemColors(nArray);
        MotifColorUtilities.loadSystemColors(nArray);
    }

    static void initUIDefaults() {
        try {
            SystemColor systemColor = SystemColor.text;
            XAWTLookAndFeel xAWTLookAndFeel = new XAWTLookAndFeel();
            uidefaults = ((LookAndFeel)xAWTLookAndFeel).getDefaults();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static native long xGetDisplay();

    static long getDisplay() {
        return display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getDefaultRootWindow() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            long l2 = XlibWrapper.RootWindow(XToolkit.getDisplay(), XlibWrapper.DefaultScreen(XToolkit.getDisplay()));
            if (l2 == 0L) {
                throw new IllegalStateException("Root window must not be null");
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XSupportsLocale();
            if (XlibWrapper.XSetLocaleModifiers("") == null) {
                log.finer("X locale modifiers are not supported, using default");
            }
            AwtScreenData awtScreenData = new AwtScreenData(XToolkit.getDefaultScreenData());
            awt_defaultFg = awtScreenData.get_blackpixel();
            arrowCursor = XlibWrapper.XCreateFontCursor(XToolkit.getDisplay(), 2);
        }
        if (log.isLoggable(Level.FINE)) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    XToolkit.dumpPeers();
                }
            });
        }
    }

    static String getCorrectXIDString(String string) {
        if (string != null) {
            return string.replace('.', '-');
        }
        return string;
    }

    static native String getEnv(String var0);

    static String getAWTAppClassName() {
        return awtAppClassName;
    }

    public XToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("XToolkit construction");
        }
        if (!GraphicsEnvironment.isHeadless()) {
            String string = null;
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            int n2 = stackTraceElementArray.length - 1;
            if (n2 >= 0) {
                string = stackTraceElementArray[n2].getClassName();
            }
            if (string == null || string.equals("")) {
                string = "AWT";
            }
            awtAppClassName = XToolkit.getCorrectXIDString(string);
            this.init();
            XWM.init();
            SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
            toolkitThread = new Thread(this, "AWT-XAWT");
            toolkitThread.setPriority(6);
            toolkitThread.setDaemon(true);
            ThreadGroup threadGroup = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = threadGroup.getParent();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
            toolkitThread.start();
        }
    }

    @Override
    public ButtonPeer createButton(Button button) {
        XButtonPeer xButtonPeer = new XButtonPeer(button);
        XToolkit.targetCreatedPeer(button, xButtonPeer);
        return xButtonPeer;
    }

    @Override
    public FramePeer createFrame(Frame frame) {
        XFramePeer xFramePeer = new XFramePeer(frame);
        XToolkit.targetCreatedPeer(frame, xFramePeer);
        return xFramePeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addToWinMap(long l2, XBaseWindow xBaseWindow) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            winMap.put(new Long(l2), xBaseWindow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromWinMap(long l2, XBaseWindow xBaseWindow) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            winMap.remove(new Long(l2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XBaseWindow windowToXWindow(long l2) {
        TreeMap treeMap = winMap;
        synchronized (treeMap) {
            return (XBaseWindow)winMap.get(new Long(l2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addEventDispatcher(long l2, XEventDispatcher xEventDispatcher) {
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Long l3 = new Long(l2);
            Vector<XEventDispatcher> vector = (Vector<XEventDispatcher>)winToDispatcher.get(l3);
            if (vector == null) {
                vector = new Vector<XEventDispatcher>();
                winToDispatcher.put(l3, vector);
            }
            vector.add(xEventDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeEventDispatcher(long l2, XEventDispatcher xEventDispatcher) {
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Long l3 = new Long(l2);
            Collection collection = (Collection)winToDispatcher.get(l3);
            if (collection != null) {
                collection.remove(xEventDispatcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchEvent(XAnyEvent xAnyEvent) {
        XBaseWindow.dispatchToWindow(xAnyEvent);
        Vector vector = null;
        HashMap hashMap = winToDispatcher;
        synchronized (hashMap) {
            Object object = new Long(xAnyEvent.get_window());
            vector = (Vector)winToDispatcher.get(object);
            if (vector != null) {
                vector = new Vector(vector);
            }
        }
        if (vector != null) {
            for (Object object : vector) {
                object.dispatchEvent(xAnyEvent);
            }
        }
    }

    static void processException(Throwable throwable) {
        System.err.println("Exception on Toolkit thread: " + throwable);
        throwable.printStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XFramePeer getParentFramePeer(Component component) {
        if (component == null) {
            return null;
        }
        ComponentPeer componentPeer = component.getPeer();
        Object object = component.getTreeLock();
        synchronized (object) {
            while (component != null && !(componentPeer instanceof XFramePeer)) {
                component = component.getParent();
                componentPeer = component.getPeer();
            }
        }
        if (componentPeer != null && componentPeer instanceof XFramePeer) {
            return (XFramePeer)componentPeer;
        }
        return null;
    }

    @Override
    public void run() {
        XToolkit.initUIDefaults();
        this.run(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(boolean bl2) {
        XAnyEvent xAnyEvent = new XAnyEvent(tempptr);
        while (true) {
            XToolkit.awtLock();
            try {
                XWindow xWindow;
                Component component;
                if (bl2) {
                    if (!XlibWrapper.XNextSecondaryLoopEvent(XToolkit.getDisplay(), xAnyEvent.pData)) {
                        break;
                    }
                } else {
                    XToolkit.callTimeoutTasks();
                    while (XlibWrapper.XEventsQueued(XToolkit.getDisplay(), 1) == 0 && XlibWrapper.XEventsQueued(XToolkit.getDisplay(), 2) == 0) {
                        XToolkit.callTimeoutTasks();
                        XToolkit.waitForEvents();
                    }
                    XlibWrapper.XNextEvent(XToolkit.getDisplay(), xAnyEvent.pData);
                }
                if (XDropTargetEventProcessor.processEvent(xAnyEvent) || XDragSourceContextPeer.processEvent(xAnyEvent)) continue;
                if (eventLog.isLoggable(Level.FINER)) {
                    eventLog.finer(xAnyEvent.toString());
                }
                long l2 = 0L;
                if (XToolkit.windowToXWindow(xAnyEvent.get_window()) != null && (component = XKeyboardFocusManagerPeer.getCurrentNativeFocusOwner()) != null && (xWindow = (XWindow)((Object)component.getPeer())) != null) {
                    l2 = xWindow.getContentWindow();
                }
                if (XlibWrapper.XFilterEvent(xAnyEvent.pData, l2)) continue;
                this.dispatchEvent(xAnyEvent);
                XlibWrapper.XFlush(XToolkit.getDisplay());
                continue;
            }
            catch (ThreadDeath threadDeath) {
                XBaseWindow.ungrabInput();
                return;
            }
            catch (Throwable throwable) {
                XBaseWindow.ungrabInput();
                XToolkit.processException(throwable);
                continue;
            }
            finally {
                XToolkit.awtUnlock();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDefaultScreenWidth() {
        if (screenWidth == -1) {
            long l2 = XToolkit.getDisplay();
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                screenWidth = (int)XlibWrapper.DisplayWidth(l2, XlibWrapper.DefaultScreen(l2));
            }
        }
        return screenWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDefaultScreenHeight() {
        if (screenHeight == -1) {
            long l2 = XToolkit.getDisplay();
            Object object = XToolkit.getAWTLock();
            synchronized (object) {
                screenHeight = (int)XlibWrapper.DisplayHeight(l2, XlibWrapper.DefaultScreen(l2));
            }
        }
        return screenHeight;
    }

    @Override
    protected int getScreenWidth() {
        return XToolkit.getDefaultScreenWidth();
    }

    @Override
    protected int getScreenHeight() {
        return XToolkit.getDefaultScreenHeight();
    }

    protected static final Object targetToPeer(Object object) {
        Object var1_1 = null;
        if (object != null && !GraphicsEnvironment.isHeadless()) {
            var1_1 = specialPeerMap.get(object);
        }
        if (var1_1 != null) {
            return var1_1;
        }
        return SunToolkit.targetToPeer(object);
    }

    protected static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    @Override
    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new XRobotPeer(graphicsDevice.getDefaultConfiguration());
    }

    @Override
    public void setDynamicLayout(boolean bl2) {
        dynamicLayoutSetting = bl2;
    }

    @Override
    protected boolean isDynamicLayoutSet() {
        return dynamicLayoutSetting;
    }

    protected boolean isDynamicLayoutSupported() {
        return XWM.getWM().supportsDynamicLayout();
    }

    @Override
    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSupported();
    }

    @Override
    public FontPeer getFontPeer(String string, int n2) {
        return new XFontPeer(string, n2);
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return XDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n2, DragGestureListener dragGestureListener) {
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            return (T)new XMouseDragGestureRecognizer(dragSource, component, n2, dragGestureListener);
        }
        return null;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        XCheckboxMenuItemPeer xCheckboxMenuItemPeer = new XCheckboxMenuItemPeer(checkboxMenuItem);
        XToolkit.targetCreatedPeer(checkboxMenuItem, xCheckboxMenuItemPeer);
        return xCheckboxMenuItemPeer;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        XMenuItemPeer xMenuItemPeer = new XMenuItemPeer(menuItem);
        XToolkit.targetCreatedPeer(menuItem, xMenuItemPeer);
        return xMenuItemPeer;
    }

    @Override
    public TextFieldPeer createTextField(TextField textField) {
        XTextFieldPeer xTextFieldPeer = new XTextFieldPeer(textField);
        XToolkit.targetCreatedPeer(textField, xTextFieldPeer);
        return xTextFieldPeer;
    }

    @Override
    public LabelPeer createLabel(Label label) {
        XLabelPeer xLabelPeer = new XLabelPeer(label);
        XToolkit.targetCreatedPeer(label, xLabelPeer);
        return xLabelPeer;
    }

    @Override
    public ListPeer createList(List list) {
        XListPeer xListPeer = new XListPeer(list);
        XToolkit.targetCreatedPeer(list, xListPeer);
        return xListPeer;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        XCheckboxPeer xCheckboxPeer = new XCheckboxPeer(checkbox);
        XToolkit.targetCreatedPeer(checkbox, xCheckboxPeer);
        return xCheckboxPeer;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        XScrollbarPeer xScrollbarPeer = new XScrollbarPeer(scrollbar);
        XToolkit.targetCreatedPeer(scrollbar, xScrollbarPeer);
        return xScrollbarPeer;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        XScrollPanePeer xScrollPanePeer = new XScrollPanePeer(scrollPane);
        XToolkit.targetCreatedPeer(scrollPane, xScrollPanePeer);
        return xScrollPanePeer;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea textArea) {
        XTextAreaPeer xTextAreaPeer = new XTextAreaPeer(textArea);
        XToolkit.targetCreatedPeer(textArea, xTextAreaPeer);
        return xTextAreaPeer;
    }

    @Override
    public ChoicePeer createChoice(Choice choice) {
        XChoicePeer xChoicePeer = new XChoicePeer(choice);
        XToolkit.targetCreatedPeer(choice, xChoicePeer);
        return xChoicePeer;
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        XCanvasPeer xCanvasPeer = new XCanvasPeer(canvas);
        XToolkit.targetCreatedPeer(canvas, xCanvasPeer);
        return xCanvasPeer;
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        XPanelPeer xPanelPeer = new XPanelPeer(panel);
        XToolkit.targetCreatedPeer(panel, xPanelPeer);
        return xPanelPeer;
    }

    @Override
    public WindowPeer createWindow(Window window) {
        XWindowPeer xWindowPeer = new XWindowPeer(window);
        XToolkit.targetCreatedPeer(window, xWindowPeer);
        return xWindowPeer;
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        XDialogPeer xDialogPeer = new XDialogPeer(dialog);
        XToolkit.targetCreatedPeer(dialog, xDialogPeer);
        return xDialogPeer;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        XFileDialogPeer xFileDialogPeer = new XFileDialogPeer(fileDialog);
        XToolkit.targetCreatedPeer(fileDialog, xFileDialogPeer);
        return xFileDialogPeer;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        XMenuBarPeer xMenuBarPeer = new XMenuBarPeer(menuBar);
        XToolkit.targetCreatedPeer(menuBar, xMenuBarPeer);
        return xMenuBarPeer;
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        XMenuPeer xMenuPeer = new XMenuPeer(menu);
        XToolkit.targetCreatedPeer(menu, xMenuPeer);
        return xMenuPeer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        XPopupMenuPeer xPopupMenuPeer = new XPopupMenuPeer(popupMenu);
        XToolkit.targetCreatedPeer(popupMenu, xPopupMenuPeer);
        return xPopupMenuPeer;
    }

    @Override
    public synchronized MouseInfoPeer getMouseInfoPeer() {
        if (xPeer == null) {
            xPeer = new XMouseInfoPeer();
        }
        return xPeer;
    }

    public XEmbeddedFramePeer createEmbeddedFrame(XEmbeddedFrame xEmbeddedFrame) {
        XEmbeddedFramePeer xEmbeddedFramePeer = new XEmbeddedFramePeer(xEmbeddedFrame);
        XToolkit.targetCreatedPeer(xEmbeddedFrame, xEmbeddedFramePeer);
        return xEmbeddedFramePeer;
    }

    XEmbedChildProxyPeer createEmbedProxy(XEmbedChildProxy xEmbedChildProxy) {
        XEmbedChildProxyPeer xEmbedChildProxyPeer = new XEmbedChildProxyPeer(xEmbedChildProxy);
        XToolkit.targetCreatedPeer(xEmbedChildProxy, xEmbedChildProxyPeer);
        return xEmbedChildProxyPeer;
    }

    @Override
    public KeyboardFocusManagerPeer createKeyboardFocusManagerPeer(KeyboardFocusManager keyboardFocusManager) throws HeadlessException {
        XKeyboardFocusManagerPeer xKeyboardFocusManagerPeer = new XKeyboardFocusManagerPeer(keyboardFocusManager);
        return xKeyboardFocusManagerPeer;
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new XCustomCursor(image, point, string);
    }

    @Override
    public Dimension getBestCursorSize(int n2, int n3) {
        return XCustomCursor.getBestCursorSize(Math.max(1, n2), Math.max(1, n3));
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return XInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        XToolkit xToolkit = this;
        synchronized (xToolkit) {
            if (this.clipboard == null) {
                this.clipboard = new XClipboard("System", "CLIPBOARD");
            }
        }
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemSelection() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        XToolkit xToolkit = this;
        synchronized (xToolkit) {
            if (this.selection == null) {
                this.selection = new XClipboard("Selection", "PRIMARY");
            }
        }
        return this.selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beep() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XBell(XToolkit.getDisplay(), 0);
        }
    }

    static String getSystemProperty(final String string) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string);
            }
        });
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, properties);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void XSync() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XlibWrapper.XSync(XToolkit.getDisplay(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getScreenResolution() {
        long l2 = XToolkit.getDisplay();
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            return (int)((double)XlibWrapper.DisplayWidth(l2, XlibWrapper.DefaultScreen(l2)) * 25.4 / (double)XlibWrapper.DisplayWidthMM(l2, XlibWrapper.DefaultScreen(l2)));
        }
    }

    static native long getDefaultXColormap();

    static native long getDefaultScreenData();

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = config.getColorModel();
        }
        return screenmodel;
    }

    @Override
    public ColorModel getColorModel() {
        return XToolkit.getStaticColorModel();
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() throws AWTException {
        return new XInputMethodDescriptor();
    }

    static int getMultiClickTime() {
        if (awt_multiclick_time == 0) {
            XToolkit.initializeMultiClickTime();
        }
        return awt_multiclick_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeMultiClickTime() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            try {
                String string = XlibWrapper.XGetDefault(XToolkit.getDisplay(), "*", "multiClickTime");
                awt_multiclick_time = string != null ? (int)Long.parseLong(string) : ((string = XlibWrapper.XGetDefault(XToolkit.getDisplay(), "OpenWindows", "MultiClickTimeout")) != null ? (int)Long.parseLong(string) * 100 : 200);
            }
            catch (NumberFormatException numberFormatException) {
                awt_multiclick_time = 200;
            }
            catch (NullPointerException nullPointerException) {
                awt_multiclick_time = 200;
            }
        }
        if (awt_multiclick_time == 0) {
            awt_multiclick_time = 200;
        }
    }

    @Override
    public boolean isFrameStateSupported(int n2) throws HeadlessException {
        if (n2 == 0 || n2 == 1) {
            return true;
        }
        return XWM.getWM().supportsExtendedState(n2);
    }

    static void dumpPeers() {
        if (log.isLoggable(Level.FINE)) {
            System.err.println("Mapped windows:");
            for (Map.Entry entry : winMap.entrySet()) {
                System.err.println(entry.getKey() + "->" + entry.getValue());
                if (!(entry.getValue() instanceof XComponentPeer)) continue;
                Component component = (Component)((XComponentPeer)entry.getValue()).getTarget();
                System.err.println("\ttarget: " + component);
            }
            System.err.println("Mapped peers:");
            for (Map.Entry entry : SunToolkit.peerMap.entrySet()) {
                System.err.println(entry.getKey() + "->" + entry.getValue());
            }
            System.err.println("Mapped special peers:");
            for (Map.Entry entry : specialPeerMap.entrySet()) {
                System.err.println(entry.getKey() + "->" + entry.getValue());
            }
            System.err.println("Mapped dispatchers:");
            for (Map.Entry entry : winToDispatcher.entrySet()) {
                System.err.println(entry.getKey() + "->" + entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getCurrentServerTime() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            block12: {
                try {
                    if (!initialized) {
                        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), timeFetcher);
                        _XA_JAVA_TIME_PROPERTY_ATOM = XAtom.get("_SUNW_JAVA_AWT_TIME");
                        initialized = true;
                    }
                    timeStampUpdated = false;
                    XlibWrapper.XChangeProperty(XToolkit.getDisplay(), XWindow.getXAWTRootWindow().getWindow(), _XA_JAVA_TIME_PROPERTY_ATOM.getAtom(), 4L, 32, 2, 0L, 0);
                    XlibWrapper.XFlush(XToolkit.getDisplay());
                    if (XToolkit.isToolkitThread()) {
                        XEvent xEvent = new XEvent();
                        try {
                            XlibWrapper.XWindowEvent(XToolkit.getDisplay(), XWindow.getXAWTRootWindow().getWindow(), 0x400000L, xEvent.pData);
                            XPropertyEvent xPropertyEvent = new XPropertyEvent(xEvent.pData);
                            timeFetcher.dispatchEvent(xPropertyEvent);
                            break block12;
                        }
                        finally {
                            if (xEvent != null) {
                                xEvent.dispose();
                            }
                        }
                    }
                    while (!timeStampUpdated) {
                        XToolkit.getAWTLock().wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!log.isLoggable(Level.FINE)) break block12;
                    log.fine("Catched exception, timeStamp may not be correct (ie = " + interruptedException + ")");
                }
            }
        }
        return timeStamp;
    }

    @Override
    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
        if (!GraphicsEnvironment.isHeadless()) {
            this.desktopProperties.put("awt.multiClickInterval", new Integer(XToolkit.getMultiClickTime()));
            this.desktopProperties.put("awt.mouse.numButtons", new Integer(this.getNumMouseButtons()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumMouseButtons() {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            return XlibWrapper.XGetPointerMapping(XToolkit.getDisplay(), 0L, 0);
        }
    }

    @Override
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                System.err.println("cannot load system cursor: " + string2);
                return null;
            }
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            return new Boolean(this.isDynamicLayoutSupported());
        }
        if (!this.loadedXSettings && (string.startsWith("gnome.") || string.startsWith(dndPrefix))) {
            this.loadedXSettings = true;
            if (!GraphicsEnvironment.isHeadless()) {
                this.loadXSettings();
                return this.desktopProperties.get(string);
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    void loadXSettings() {
        this.xs = new XAWTXSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parseXSettings(int n2, Map map) {
        Integer n3;
        Object object;
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry object22 : map.entrySet()) {
            object = (String)object22.getKey();
            object = "gnome." + (String)object;
            this.setDesktopProperty((String)object, object22.getValue());
            log.fine("name = " + (String)object + " value = " + object22.getValue());
        }
        Object var4_5 = null;
        object = this;
        synchronized (object) {
            n3 = (Integer)this.desktopProperties.get("gnome.Net/DndDragThreshold");
        }
        if (n3 != null) {
            this.setDesktopProperty("DnD.gestureMotionThreshold", n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int keysymToPrimaryKeycode(long l2) {
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            int n2 = XlibWrapper.XKeysymToKeycode(XToolkit.getDisplay(), l2);
            if (n2 == 0) {
                return 0;
            }
            long l3 = XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), n2, 0);
            if (l2 != l3) {
                return 0;
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setupModifierMap() {
        int n2 = XToolkit.keysymToPrimaryKeycode(65511L);
        int n3 = XToolkit.keysymToPrimaryKeycode(65512L);
        int n4 = XToolkit.keysymToPrimaryKeycode(65513L);
        int n5 = XToolkit.keysymToPrimaryKeycode(65514L);
        int n6 = XToolkit.keysymToPrimaryKeycode(65407L);
        int n7 = XToolkit.keysymToPrimaryKeycode(65406L);
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        log.fine("In setupModifierMap");
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            XModifierKeymap xModifierKeymap = new XModifierKeymap(XlibWrapper.XGetModifierMapping(XToolkit.getDisplay()));
            int n8 = xModifierKeymap.get_max_keypermod();
            long l2 = xModifierKeymap.get_modifiermap();
            block3: for (int i2 = 3; i2 <= 7; ++i2) {
                short s2;
                for (int i3 = 0; i3 < n8 && (s2 = Native.getUByte(l2, i2 * n8 + i3)) != 0; ++i3) {
                    if (metaMask == 0 && (s2 == n2 || s2 == n3)) {
                        metaMask = nArray[i2];
                        continue block3;
                    }
                    if (altMask == 0 && (s2 == n4 || s2 == n5)) {
                        altMask = nArray[i2];
                        continue block3;
                    }
                    if (numLockMask == 0 && s2 == n6) {
                        numLockMask = nArray[i2];
                        continue block3;
                    }
                    if (modeSwitchMask != 0 || s2 != n7) continue;
                    modeSwitchMask = nArray[i2];
                    continue block3;
                }
            }
            XlibWrapper.XFreeModifiermap(xModifierKeymap.pData);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("metaMask = " + metaMask);
            log.fine("altMask = " + altMask);
            log.fine("numLockMask = " + numLockMask);
            log.fine("modeSwitchMask = " + modeSwitchMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException("task is null");
        }
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            if (timeoutTaskLog.isLoggable(Level.FINER)) {
                timeoutTaskLog.finer("Removing task " + runnable);
            }
            if (timeoutTasks == null) {
                if (timeoutTaskLog.isLoggable(Level.FINER)) {
                    timeoutTaskLog.finer("Task is not scheduled");
                }
                return;
            }
            Collection collection = timeoutTasks.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                java.util.List list = (java.util.List)iterator.next();
                boolean bl2 = false;
                if (!list.contains(runnable)) continue;
                list.remove(runnable);
                if (!list.isEmpty()) break;
                iterator.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void schedule(Runnable runnable, long l2) {
        if (runnable == null) {
            throw new NullPointerException("task is null");
        }
        if (l2 <= 0L) {
            throw new IllegalArgumentException("interval " + l2 + " is not positive");
        }
        Object object = XToolkit.getAWTLock();
        synchronized (object) {
            Long l3;
            ArrayList<Runnable> arrayList;
            if (timeoutTaskLog.isLoggable(Level.FINER)) {
                timeoutTaskLog.finer("XToolkit.schedule(): current time=" + System.currentTimeMillis() + ";  interval=" + l2 + ";  task being added=" + runnable + ";  tasks before addition=" + timeoutTasks);
            }
            if (timeoutTasks == null) {
                timeoutTasks = new TreeMap();
            }
            if ((arrayList = (ArrayList<Runnable>)timeoutTasks.get(l3 = new Long(System.currentTimeMillis() + l2))) == null) {
                arrayList = new ArrayList<Runnable>(1);
                timeoutTasks.put(l3, arrayList);
            }
            arrayList.add(runnable);
        }
    }

    private static void callTimeoutTasks() {
        if (timeoutTaskLog.isLoggable(Level.FINER)) {
            timeoutTaskLog.finer("XToolkit.callTimeoutTasks(): current time=" + System.currentTimeMillis() + ";  tasks=" + timeoutTasks);
        }
        if (timeoutTasks == null || timeoutTasks.isEmpty()) {
            return;
        }
        Long l2 = new Long(System.currentTimeMillis());
        Long l3 = (Long)timeoutTasks.firstKey();
        while (l3.compareTo(l2) <= 0) {
            java.util.List list = (java.util.List)timeoutTasks.remove(l3);
            for (Runnable runnable : list) {
                if (timeoutTaskLog.isLoggable(Level.FINER)) {
                    timeoutTaskLog.finer("XToolkit.callTimeoutTasks(): current time=" + l2 + ";  about to run task=" + runnable);
                }
                try {
                    runnable.run();
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    XToolkit.processException(throwable);
                }
            }
            if (timeoutTasks.isEmpty()) break;
            l3 = (Long)timeoutTasks.firstKey();
        }
    }

    static long getAwtDefaultFg() {
        return awt_defaultFg;
    }

    static boolean isLeftMouseButton(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: 
            case 502: {
                return mouseEvent.getButton() == 1;
            }
            case 500: 
            case 504: 
            case 505: {
                return (mouseEvent.getModifiersEx() & 0x400) != 0;
            }
        }
        return false;
    }

    static Field getField(final Class clazz, final String string) {
        Field field = null;
        try {
            field = (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Field field = clazz.getDeclaredField(string);
                    field.setAccessible(true);
                    return field;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return field;
    }

    static Method getMethod(final Class clazz, final String string, final Class[] classArray) {
        Method method = null;
        try {
            method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method method = clazz.getDeclaredMethod(string, classArray);
                    method.setAccessible(true);
                    return method;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            privilegedActionException.printStackTrace();
        }
        return method;
    }

    static long nowMillisUTC_offset(long l2) {
        long l3 = System.currentTimeMillis();
        if (log.isLoggable(Level.FINER)) {
            log.finer("reset_time=" + reset_time_utc + ", current_time=" + l3 + ", server_offset=" + l2 + ", wrap_time=" + Integer.MAX_VALUE);
        }
        if (l3 - reset_time_utc > Integer.MAX_VALUE) {
            reset_time_utc = System.currentTimeMillis() - XToolkit.getCurrentServerTime();
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("result = " + (reset_time_utc + l2));
        }
        return reset_time_utc + l2;
    }

    @Override
    protected boolean needsXEmbedImpl() {
        return true;
    }

    static EventQueue getEventQueue(Object object) {
        AppContext appContext = XToolkit.targetToAppContext(object);
        if (appContext != null) {
            return (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
        }
        return null;
    }

    static void removeSourceEvents(EventQueue eventQueue, Object object, boolean bl2) {
        try {
            m_removeSourceEvents.invoke(eventQueue, object, bl2);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    static {
        winMap = new TreeMap();
        specialPeerMap = new HashMap();
        winToDispatcher = new HashMap();
        tempptr = XlibWrapper.unsafe.allocateMemory(4096L);
        screenWidth = -1;
        screenHeight = -1;
        XToolkit.initSecurityWarning();
        if (GraphicsEnvironment.isHeadless()) {
            config = null;
        } else {
            localEnv = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
            device = (X11GraphicsDevice)localEnv.getDefaultScreenDevice();
            config = (X11GraphicsConfig)device.getDefaultConfiguration();
            if (device != null) {
                display = device.getDisplay();
            }
            XToolkit.setupModifierMap();
            XToolkit.initIDs();
        }
        m_removeSourceEvents = XToolkit.getMethod(EventQueue.class, "removeSourceEvents", new Class[]{Object.class, Boolean.TYPE});
        IgnoreBadWindowHandler = new XErrorHandler(){

            public int handleError(long l2, XErrorEvent xErrorEvent) {
                XToolkit.XERROR_SAVE(xErrorEvent);
                if (xErrorEvent.get_error_code() == 3) {
                    return 0;
                }
                return XToolkit.SAVED_ERROR_HANDLER(l2, xErrorEvent);
            }
        };
        debug = false;
        displayLock = new Object();
        timeFetcher = new XEventDispatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatchEvent(IXAnyEvent iXAnyEvent) {
                long l2 = iXAnyEvent.getPData();
                switch (iXAnyEvent.get_type()) {
                    case 28: {
                        XPropertyEvent xPropertyEvent = new XPropertyEvent(l2);
                        Object object = XToolkit.getAWTLock();
                        synchronized (object) {
                            timeStamp = xPropertyEvent.get_time();
                            timeStampUpdated = true;
                            XToolkit.getAWTLock().notifyAll();
                            break;
                        }
                    }
                }
            }
        };
    }

    static interface XErrorHandler {
        public int handleError(long var1, XErrorEvent var3);
    }
}

