/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.text.Trie;

public class IntTrie
extends Trie {
    private int m_initialValue_;
    private int[] m_data_;

    public IntTrie(InputStream inputStream, Trie.DataManipulate dataManipulate) throws IOException {
        super(inputStream, dataManipulate);
        if (!this.isIntTrie()) {
            throw new IllegalArgumentException("Data given does not belong to a int trie.");
        }
    }

    public final int getCodePointValue(int n2) {
        int n3 = this.getCodePointOffset(n2);
        return n3 >= 0 ? this.m_data_[n3] : this.m_initialValue_;
    }

    public final int getLeadValue(char c2) {
        return this.m_data_[this.getLeadOffset(c2)];
    }

    public final int getBMPValue(char c2) {
        return this.m_data_[this.getBMPOffset(c2)];
    }

    public final int getSurrogateValue(char c2, char c3) {
        if (!Character.isHighSurrogate(c2) || !Character.isLowSurrogate(c3)) {
            throw new IllegalArgumentException("Argument characters do not form a supplementary character");
        }
        int n2 = this.getSurrogateOffset(c2, c3);
        if (n2 > 0) {
            return this.m_data_[n2];
        }
        return this.m_initialValue_;
    }

    public final int getTrailValue(int n2, char c2) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n3 = this.m_dataManipulate_.getFoldingOffset(n2);
        if (n3 > 0) {
            return this.m_data_[this.getRawOffset(n3, (char)(c2 & 0x3FF))];
        }
        return this.m_initialValue_;
    }

    public final int getLatin1LinearValue(char c2) {
        return this.m_data_[32 + c2];
    }

    protected final void unserialize(InputStream inputStream) throws IOException {
        super.unserialize(inputStream);
        this.m_data_ = new int[this.m_dataLength_];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        byte[] byArray = new byte[this.m_dataLength_ * 4];
        dataInputStream.read(byArray);
        int n2 = 0;
        for (int i2 = 0; i2 < this.m_dataLength_; ++i2) {
            this.m_data_[i2] = byArray[n2++] << 24 & 0xFF000000 | byArray[n2++] << 16 & 0xFF0000 | byArray[n2++] << 8 & 0xFF00 | byArray[n2++] & 0xFF;
        }
        this.m_initialValue_ = this.m_data_[0];
    }

    protected final int getSurrogateOffset(char c2, char c3) {
        if (this.m_dataManipulate_ == null) {
            throw new NullPointerException("The field DataManipulate in this Trie is null");
        }
        int n2 = this.m_dataManipulate_.getFoldingOffset(this.getLeadValue(c2));
        if (n2 > 0) {
            return this.getRawOffset(n2, (char)(c3 & 0x3FF));
        }
        return -1;
    }

    protected final int getValue(int n2) {
        return this.m_data_[n2];
    }

    protected final int getInitialValue() {
        return this.m_initialValue_;
    }

    IntTrie(char[] cArray, int[] nArray, int n2, int n3, Trie.DataManipulate dataManipulate) {
        super(cArray, n3, dataManipulate);
        this.m_index_ = cArray;
        this.m_data_ = nArray;
        this.m_dataLength_ = this.m_data_.length;
        this.m_initialValue_ = n2;
    }
}

