/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteConstants;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SecureKey;
import com.sun.net.ssl.internal.ssl.SessionId;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLPermission;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

final class SSLSessionImpl
implements SSLSession,
CipherSuiteConstants {
    static final SSLSessionImpl nullSession = new SSLSessionImpl();
    private static final byte compression_null = 0;
    private final ProtocolVersion protocolVersion;
    private final SessionId sessionId;
    private java.security.cert.X509Certificate[] peerCerts;
    private byte compressionMethod;
    private final CipherSuite cipherSuite;
    private byte[] masterSecret;
    private final long creationTime = System.currentTimeMillis();
    private long lastUsedTime = 0L;
    private final String host;
    private final int port;
    private SSLSessionContextImpl context;
    private int sessionCount;
    private boolean invalidated;
    private java.security.cert.X509Certificate[] localCerts;
    private PrivateKey localPrivateKey;
    private Principal peerPrincipal;
    private Principal localPrincipal;
    private static volatile int counter = 0;
    private static boolean defaultRejoinable = true;
    private static final Debug debug = Debug.getInstance("ssl");
    private Hashtable table = new Hashtable();

    private SSLSessionImpl() {
        this(ProtocolVersion.NONE, CipherSuite.C_NULL, new SessionId(false, null), null, -1);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, SecureRandom secureRandom, String string, int n) {
        this(protocolVersion, cipherSuite, new SessionId(defaultRejoinable, secureRandom), string, n);
    }

    SSLSessionImpl(ProtocolVersion protocolVersion, CipherSuite cipherSuite, SessionId sessionId, String string, int n) {
        this.protocolVersion = protocolVersion;
        this.sessionId = sessionId;
        this.peerCerts = null;
        this.compressionMethod = 0;
        this.cipherSuite = cipherSuite;
        this.masterSecret = null;
        this.host = string;
        this.port = n;
        this.sessionCount = ++counter;
        if (debug != null && Debug.isOn("session")) {
            System.out.println("%% Created:  " + this);
        }
    }

    void setMasterSecret(byte[] byArray) {
        if (this.masterSecret == null) {
            this.masterSecret = byArray;
        }
    }

    byte[] getMasterSecret() {
        return this.masterSecret;
    }

    void setPeerCertificates(java.security.cert.X509Certificate[] x509CertificateArray) {
        if (this.peerCerts == null) {
            this.peerCerts = x509CertificateArray;
        }
    }

    void setLocalCertificates(java.security.cert.X509Certificate[] x509CertificateArray) {
        this.localCerts = x509CertificateArray;
    }

    void setLocalPrivateKey(PrivateKey privateKey) {
        this.localPrivateKey = privateKey;
    }

    void setPeerPrincipal(Principal principal) {
        if (this.peerPrincipal == null) {
            this.peerPrincipal = principal;
        }
    }

    void setLocalPrincipal(Principal principal) {
        this.localPrincipal = principal;
    }

    boolean isRejoinable() {
        return this.sessionId != null && this.sessionId.length() != 0 && !this.invalidated && this.isLocalAuthenticationValid();
    }

    public synchronized boolean isValid() {
        return this.isRejoinable();
    }

    boolean isLocalAuthenticationValid() {
        if (this.localPrivateKey != null) {
            try {
                this.localPrivateKey.getAlgorithm();
            }
            catch (Exception exception) {
                this.invalidate();
                return false;
            }
        }
        return true;
    }

    public byte[] getId() {
        return this.sessionId.getId();
    }

    public SSLSessionContext getSessionContext() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSLPermission("getSSLSessionContext"));
        }
        return this.context;
    }

    SessionId getSessionId() {
        return this.sessionId;
    }

    CipherSuite getSuite() {
        return this.cipherSuite;
    }

    public String getCipherSuite() {
        return this.getSuite().name;
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getProtocol() {
        return this.getProtocolVersion().name;
    }

    byte getCompression() {
        return this.compressionMethod;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SSLSessionImpl) {
            SSLSessionImpl sSLSessionImpl = (SSLSessionImpl)object;
            return this.sessionId != null && this.sessionId.equals(sSLSessionImpl.getSessionId());
        }
        return false;
    }

    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == K_KRB5 || this.cipherSuite.keyExchange == K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return (Certificate[])this.peerCerts.clone();
    }

    public Certificate[] getLocalCertificates() {
        return this.localCerts == null ? null : (Certificate[])this.localCerts.clone();
    }

    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == K_KRB5 || this.cipherSuite.keyExchange == K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[this.peerCerts.length];
        for (int i = 0; i < this.peerCerts.length; ++i) {
            byte[] byArray = null;
            try {
                byArray = this.peerCerts[i].getEncoded();
                x509CertificateArray[i] = X509Certificate.getInstance(byArray);
                continue;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new SSLPeerUnverifiedException(certificateEncodingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new SSLPeerUnverifiedException(certificateException.getMessage());
            }
        }
        return x509CertificateArray;
    }

    public java.security.cert.X509Certificate[] getCertificateChain() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == K_KRB5 || this.cipherSuite.keyExchange == K_KRB5_EXPORT) {
            throw new SSLPeerUnverifiedException("no certificates expected for Kerberos cipher suites");
        }
        if (this.peerCerts != null) {
            return (java.security.cert.X509Certificate[])this.peerCerts.clone();
        }
        throw new SSLPeerUnverifiedException("peer not authenticated");
    }

    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        if (this.cipherSuite.keyExchange == K_KRB5 || this.cipherSuite.keyExchange == K_KRB5_EXPORT) {
            if (this.peerPrincipal == null) {
                throw new SSLPeerUnverifiedException("peer not authenticated");
            }
            return (KerberosPrincipal)this.peerPrincipal;
        }
        if (this.peerCerts == null) {
            throw new SSLPeerUnverifiedException("peer not authenticated");
        }
        return this.peerCerts[0].getSubjectX500Principal();
    }

    public Principal getLocalPrincipal() {
        if (this.cipherSuite.keyExchange == K_KRB5 || this.cipherSuite.keyExchange == K_KRB5_EXPORT) {
            return this.localPrincipal == null ? null : (KerberosPrincipal)this.localPrincipal;
        }
        return this.localCerts == null ? null : this.localCerts[0].getSubjectX500Principal();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastUsedTime != 0L ? this.lastUsedTime : this.creationTime;
    }

    void setLastAccessedTime(long l) {
        this.lastUsedTime = l;
    }

    public InetAddress getPeerAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public String getPeerHost() {
        return this.host;
    }

    public int getPeerPort() {
        return this.port;
    }

    void setContext(SSLSessionContextImpl sSLSessionContextImpl) {
        if (this.context == null) {
            this.context = sSLSessionContextImpl;
        }
    }

    public synchronized void invalidate() {
        if (this == nullSession) {
            return;
        }
        this.invalidated = true;
        if (debug != null && Debug.isOn("session")) {
            System.out.println("%% Invalidated:  " + this);
        }
        if (this.context != null) {
            this.context.remove(this.sessionId);
            this.context = null;
        }
    }

    public void putValue(String string, Object object) {
        SSLSessionBindingEvent sSLSessionBindingEvent;
        if (string == null || object == null) {
            throw new IllegalArgumentException("arguments can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object object2 = this.table.put(secureKey, object);
        if (object2 instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object2).valueUnbound(sSLSessionBindingEvent);
        }
        if (object instanceof SSLSessionBindingListener) {
            sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)object).valueBound(sSLSessionBindingEvent);
        }
    }

    public Object getValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        return this.table.get(secureKey);
    }

    public void removeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException("argument can not be null");
        }
        SecureKey secureKey = new SecureKey(string);
        Object v = this.table.remove(secureKey);
        if (v instanceof SSLSessionBindingListener) {
            SSLSessionBindingEvent sSLSessionBindingEvent = new SSLSessionBindingEvent(this, string);
            ((SSLSessionBindingListener)v).valueUnbound(sSLSessionBindingEvent);
        }
    }

    public String[] getValueNames() {
        Vector<Object> vector = new Vector<Object>();
        Object object = SecureKey.getCurrentSecurityContext();
        Enumeration enumeration = this.table.keys();
        while (enumeration.hasMoreElements()) {
            SecureKey secureKey = (SecureKey)enumeration.nextElement();
            if (!object.equals(secureKey.getSecurityContext())) continue;
            vector.addElement(secureKey.getAppKey());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int getPacketBufferSize() {
        return 16665;
    }

    public int getApplicationBufferSize() {
        return 16384;
    }

    public String toString() {
        return "[Session-" + this.sessionCount + ", " + this.getCipherSuite() + "]";
    }

    public void finalize() {
        String[] stringArray = this.getValueNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.removeValue(stringArray[i]);
        }
    }
}

