/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.ExportControl;
import java.io.IOException;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.DefaultSSLSocketFactory;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SSLSocketFactory theFactory;
    private static final Debug debug;

    private static void log(String string) {
        if (debug != null && Debug.isOn("pluggability")) {
            System.out.println(string);
        }
    }

    public static synchronized SocketFactory getDefault() {
        if (theFactory == null) {
            SSLSocketFactory.log("setting up default SSLSocketFactory");
            String string = SSLSocketFactory.getFactoryProvider();
            try {
                Class<?> clazz;
                block5: {
                    clazz = null;
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                        if (classLoader == null) break block5;
                        clazz = classLoader.loadClass(string);
                    }
                }
                SSLSocketFactory.log("class " + string + " is loaded");
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)clazz.newInstance();
                SSLSocketFactory.log("instantiated an instance of class " + string);
                ExportControl.checkCipherSuites(sSLSocketFactory);
                theFactory = sSLSocketFactory;
            }
            catch (Exception exception) {
                SSLSocketFactory.log("use dummy SSLSocketFactory due to " + exception.toString());
                theFactory = new DefaultSSLSocketFactory(exception.getMessage());
            }
        }
        return theFactory;
    }

    private static String getFactoryProvider() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("ssl.SocketFactory.provider");
            }
        });
        if (string == null) {
            string = "com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl";
            SSLSocketFactory.log("use default SunJSSE impl class: " + string);
        } else {
            SSLSocketFactory.log("use class specified by ssl.SocketFactory.provider: " + string);
        }
        return string;
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;

    static {
        debug = Debug.getInstance("ssl");
    }
}

