overold() {
	BASENAME=`basename $i .new`
	FILEPATH=`dirname $i`
	FULLNAME="${FILEPATH}/${BASENAME}"

	if [ -e ${FULLNAME} ]; then
	    mv ${FULLNAME} ${FULLNAME}.orig
	fi
	mv ${FULLNAME}.new ${FULLNAME}
}

removeold() {
	rm $i
}

looknew() {
	echo -e "\nSearching NEW configuration files"
	FILES=`find /etc -name "*.new" 2>/dev/null`

	if [ "$FILES" != "" ]; then
		echo -e "\n\
Some packages had new configuration files installed.
You have four choices:

	(K)eep the old files and consider .new files later 

	(O)verwrite all old files with the new ones. The
	   old files will be stored with the suffix .orig

	(R)emove all .new files

	(P)rompt K, O, R selection for every single file
	
What do you want (K/O/R/P)?"
		read ANSWER
		case $ANSWER in
			K|k)
				break
			;;
			O|o)
				for i in $FILES; do
					overold $i
				done
				break
			;;
			R|r)
				for i in $FILES; do
					removeold $i
				done
				break
			;;
			P|p)
				echo "Select what you want file-by-file"
				for i in $FILES; do
					echo -e "$i - (K)eep|(O)verwrite|(R)emove?"
					read ANSWER
					case $ANSWER in
						O|o)
							overold $i
						;;
						R|r)
							removeold $i
						;;
						K|k|*)
						;;
					esac
				done
				break
			;;
			*)
				echo "OK! Your choice is nothing! slackpkg will Keep the old files for you to deal with later"
			;;
		esac
	fi
}

lookkernel() {
	NEWKERNELMD5=`md5sum /boot/vmlinuz 2>/dev/null`
	if [ "$KERNELMD5" != "$NEWKERNELMD5" ]; then
		echo -e "\n
Your kernel image is updated. We highly recommend you run: lilo
Do you want slackpkg to run lilo now? (Y/n)"
		read ANSWER
		if [ "$ANSWER" != "n" ] && [ "$ANSWER" != "N" ]; then
			/sbin/lilo
		fi
	fi
}
