.\"
.\" $XFree86: xc/lib/Xft/Xft.man,v 1.2 2000/11/30 06:59:45 keithp Exp $
.\"
.\" Copyright © 2000 Keith Packard.
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Keith Packard not be used in
.\" advertising or publicity pertaining to distribution of the software without
.\" specific, written prior permission.  Keith Packard makes no
.\" representations about the suitability of this software for any purpose.  It
.\" is provided "as is" without express or implied warranty.
.\"
.\" KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.de TQ
.br
.ns
.TP \\$1
..
.TH XFT __libmansuffix__ __vendorversion__

.SH NAME
 XFT \- X FreeType interface library

.SH DESCRIPTION
.B Xft
is a simple library designed to interface the FreeType rasterizer with the X
Rendering Extension.  This manual page barely scratches the surface of this
library.

.SH DATATYPES

.B XftPattern
holds a set of names with associated value lists; each name refers to a
property of a font.  XftPatterns are used as inputs to the matching code as
well as holding information about specific fonts.

.B XftFont
contains general font metrics and a pointer to either the core XFontStruct
data or a structure holding FreeType and X Render Extension data.

.B XftFontStruct
contains information about FreeType fonts used with the X Render Extension.

.B XftFontSet
contains a list of XftPatterns.  Internally Xft uses this data structure to
hold sets of fonts.  Externally, Xft returns the results of listing fonts in
this format.

.B XftObjectSet
holds a set of names and is used to specify which fields from fonts are
placed in the the list of returned patterns when listing fonts.

.B XftDraw
is an opaque object which holds information used to render to an X drawable
using either core protocol or the X Rendering extension.

.SH FUNCTIONS
.nf
XftFont *
XftFontOpen (Display *dpy, int screen, ...);
.fi
.B XftFontOpen
takes a list of pattern elements of the form (field, type, value) terminated
with a 0, matches that pattern against the available fonts and opens the
matching font.
.PP
Example:
.br
	font = XftFontOpen (dpy, scr,
			    XFT_FAMILY, XftTypeString, "charter",
			    XFT_SIZE, XftTypeDouble, 12.0);
.PP
This opens the charter font at 12 points.  The point size is automatically
converted to the correct pixel size based on the resolution of the monitor.
.PP
.nf
void
XftTextExtents8 (Display	*dpy,
		 XftFont	*font,
		 unsigned char  *string, 
		 int		len,
		 XGlyphInfo	*extents);
.fi
.B XftTextExtents8
computes the pixel extents of "string" when drawn with "font".
.PP
.nf
XftDraw *
XftDrawCreate (Display   *dpy,
	       Drawable  drawable,
	       Visual    *visual,
	       Colormap  colormap);
.fi
.B XtDrawCreate
creates a structure that can be used to render text and rectangles
to the screen.
.PP
.nf
void
XftDrawString8 (XftDraw		*d,
		XRenderColor	*color,
		XftFont		*font,
		int		x, 
		int		y,
		unsigned char	*string,
		int		len);
.fi
.B XftDrawString8
draws "string" using "font" in "color" at "x, y".
.PP
.nf
void
XftDrawRect (XftDraw	    *d,
	     XRenderColor   *color,
	     int	    x, 
	     int	    y,
	     unsigned int   width,
	     unsigned int   height);
.fi
.B XftDrawRect
fills a solid rectangle in the specified color.
.SH XftConfig
The 
.B XftConfig
file contains configuration information for the Xft library consisting of
directories to look at for font information as well as instructions on
editing program specified font patterns before attempting to match the
available fonts.
.PP
.nf
config	:   "dir" STRING
	|   "include" STRING
	|   "includeif" STRING
	|   "match" tests "edit" edits
	;
test	:   qual FIELD-NAME COMPARE CONSTANT
	;
qual	:   "any"
	|   "all"
	;
edit	:   FIELD-NAME ASSIGN expr SEMI
	;
.fi
.PP
STRINGs are double-quote delimited.  FIELD-NAMEs are identifiers,
ASSIGN is one of "=", "+=" or "=+".  expr can contain the usual
arithmetic operators and can include FIELD-NAMEs.
.PP
"dir" adds a directory to the list of places Xft will look for fonts.
There is no particular order implied by the list; Xft treats all fonts about
the same.
.PP
"include" and "includeif" cause Xft to load more configuration parameters
from the indicated file.  "includeif" doesn't elicit a complaint if the file
doesn't exist.  If the file name begins with a '~' character, it refers to a
path relative to the home directory of the user.
.PP
If the tests in a "match" statement all match a user-specified pattern, the
pattern will be edited with the specified instructions.
.PP
Where ASSIGN is "=", the matching value in the pattern will be replaced by
the given expression.  "+="/"=+" will prepend/append a new value to the list
of values for the indicated field.

.SH RESTRICTIONS
.B Xft
will probably change radically in the future; weak attempts will be made to
retain some level of source-file compatibility.

.SH AUTHOR
Keith Packard
