/* mdprint --- for each block, print the 1st long int to stdout */

# include <sys/types.h>
# include <sys/stat.h>
# include <fcntl.h>
# include <stdio.h>
# include <stdlib.h>
# include <errno.h>
# include <string.h>

# define BLOCK_SIZE		(1024)
# define LONGS_PER_BLOCK	(BLOCK_SIZE / sizeof (long))
# define NBLOCKS		(160384)

char *progname = "mdread";

main (int argc, char **argv)
{
	long buf[LONGS_PER_BLOCK];
	long i;
	int fd;
	char *devname;

	if (argc != 2) {
		fprintf (stderr, "Usage: %s <device>\n", progname);
		exit (1);
	}

	devname = argv[1];

	fd = open (devname, O_RDONLY);
	if (fd < 0) {
		fprintf (stderr, "%s: can't open %s (%s)\n", progname,
		    devname, strerror (errno));
		exit (2);
	}

	for (i = 0; i < NBLOCKS; i++) {
		if (read (fd, (char *) buf, sizeof (buf)) < 0) {
			fprintf (stderr, "%s: read failed (%s)\n", progname,
			    strerror (errno));
			abort ();
		}

		printf ("block %4ld: %ld\n", i, *buf);

	}

	close (fd);

	exit (0);
}
