/*
 * Decompiled with CFR 0.152.
 */
package jep;

import jep.AppletHandlerFactory;

public class RunnableWrapper
implements Runnable {
    private int timesRun = 0;
    private Runnable oldTarget = null;
    private Runnable runnable = null;
    private Thread newThread = null;

    private RunnableWrapper(Runnable runnable) {
        this.runnable = runnable;
    }

    private RunnableWrapper(Thread oldThread, Runnable oldTarget) {
        this.runnable = oldThread;
        this.oldTarget = oldTarget;
    }

    private static RunnableWrapper newWrapper(Runnable runnable) {
        return new RunnableWrapper(runnable);
    }

    private static RunnableWrapper newWrapper(Thread oldThread, Runnable oldTarget) {
        RunnableWrapper wrapper = new RunnableWrapper(oldThread, oldTarget);
        WrapperThread newThread = new WrapperThread(oldThread.getThreadGroup(), wrapper, oldThread.getName());
        newThread.setDaemon(oldThread.isDaemon());
        newThread.setPriority(oldThread.getPriority());
        wrapper.newThread = newThread;
        return wrapper;
    }

    private Thread getOldThread() {
        try {
            return (Thread)this.runnable;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    private Thread getNewThread() {
        return this.newThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (this.runnable == null) return;
        if (++this.timesRun != 1) {
            if (this.oldTarget == null) return;
            this.oldTarget.run();
            return;
        }
        long pool = AppletHandlerFactory.allocAutoreleasePool();
        try {
            try {
                this.runnable.run();
            }
            catch (ThreadDeath e) {
                Object var5_3 = null;
                AppletHandlerFactory.releaseAutoreleasePool(pool);
                if (this.newThread != null) {
                    Thread oldThreadCopy = this.getOldThread();
                    Thread newThreadCopy = this.newThread;
                    this.runnable = null;
                    this.newThread = null;
                    RunnableWrapper.unposeThreads(newThreadCopy, oldThreadCopy);
                    return;
                }
                this.runnable = null;
                return;
            }
            catch (Throwable e) {
                System.out.println("RunnableWrapper.run(): Unexpected error " + e.getMessage());
                e.printStackTrace();
                Object var5_4 = null;
                AppletHandlerFactory.releaseAutoreleasePool(pool);
                if (this.newThread != null) {
                    Thread oldThreadCopy = this.getOldThread();
                    Thread newThreadCopy = this.newThread;
                    this.runnable = null;
                    this.newThread = null;
                    RunnableWrapper.unposeThreads(newThreadCopy, oldThreadCopy);
                    return;
                }
                this.runnable = null;
                return;
            }
            Object var5_2 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            AppletHandlerFactory.releaseAutoreleasePool(pool);
            if (this.newThread != null) {
                Thread oldThreadCopy = this.getOldThread();
                Thread newThreadCopy = this.newThread;
                this.runnable = null;
                this.newThread = null;
                RunnableWrapper.unposeThreads(newThreadCopy, oldThreadCopy);
                throw throwable;
            }
            this.runnable = null;
            throw throwable;
        }
        AppletHandlerFactory.releaseAutoreleasePool(pool);
        if (this.newThread != null) {
            Thread oldThreadCopy = this.getOldThread();
            Thread newThreadCopy = this.newThread;
            this.runnable = null;
            this.newThread = null;
            RunnableWrapper.unposeThreads(newThreadCopy, oldThreadCopy);
            return;
        }
        this.runnable = null;
    }

    private static native void poseAsThread(Thread var0, Thread var1);

    private static native void unposeThreads(Thread var0, Thread var1);

    public static class WrapperThread
    extends Thread {
        private int timesRun = 0;
        private RunnableWrapper wrapper = null;

        private WrapperThread(ThreadGroup group, RunnableWrapper wrapper, String name) {
            super(group, wrapper, name);
            this.wrapper = wrapper;
        }

        private RunnableWrapper getWrapper() {
            return this.wrapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.wrapper != null) {
                if (++this.timesRun == 1) {
                    WrapperThread wrapperThread = this;
                    synchronized (wrapperThread) {
                        RunnableWrapper.poseAsThread(this, this.wrapper.getOldThread());
                    }
                }
                this.wrapper.run();
                this.wrapper = null;
            }
        }

        public String toString() {
            return super.toString() + " (WrapperThread)";
        }
    }
}

