/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.schema;

import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrdf.model.Value;
import org.openrdf.sail.rdbms.schema.IdSequence;
import org.openrdf.sail.rdbms.schema.ValueType;

public class IntegerIdSequence
extends IdSequence {
    private int SPAN = 0xFFFFFFF;
    private int SHIFT = Long.toBinaryString(this.SPAN).length();
    private Number[] minIds;
    private ConcurrentMap<ValueType, AtomicInteger> seq = new ConcurrentHashMap<ValueType, AtomicInteger>();

    public int getShift() {
        return this.SHIFT;
    }

    public int getJdbcIdType() {
        return 4;
    }

    public String getSqlType() {
        return "INTEGER";
    }

    public void init() throws SQLException {
        this.minIds = new Number[ValueType.values().length];
        for (int i = 0; i < this.minIds.length; ++i) {
            this.minIds[i] = i * (this.SPAN + 1);
        }
        if (this.getHashTable() != null) {
            for (Long max : this.getHashTable().maxIds(this.getShift(), this.getMod())) {
                ValueType code = this.valueOf(max);
                if (((Number)max).intValue() <= this.minId(code).intValue() || this.seq.containsKey((Object)code) && ((AtomicInteger)this.seq.get((Object)code)).intValue() >= ((Number)max).intValue()) continue;
                this.seq.put(code, new AtomicInteger(((Number)max).intValue()));
            }
        }
    }

    public Number idOf(Number number) {
        return number.intValue();
    }

    public Number maxId(ValueType type) {
        return this.minId(type).intValue() + this.SPAN;
    }

    public Number minId(ValueType type) {
        return this.minIds[type.index()];
    }

    public Number nextId(Value value) {
        ValueType code = this.valueOf(value);
        if (!this.seq.containsKey((Object)code)) {
            this.seq.putIfAbsent(code, new AtomicInteger(this.minId(code).intValue()));
        }
        int id = ((AtomicInteger)this.seq.get((Object)code)).incrementAndGet();
        return id;
    }

    protected int shift(Number id) {
        return id.intValue() >>> this.SHIFT;
    }
}

