/*
 *Copyright(c)2004,Cisco URP imburses and Network Information Center in Beijing University of Posts and Telecommunications researches.
 *
 *All right reserved
 *
 *File Name: expObjectTable.c
 *File Description: expObjectTable MIB operation.
 *
 *Current Version:1.0
 *Author:JianShun Tong
 *Date:2004.8.20
 */


/*
 * This file was generated by mib2c and is intended for use as
 * a mib module for the ucd-snmp snmpd agent. 
 */


/*
 * This should always be included first before anything else 
 */
#include <net-snmp/net-snmp-config.h>
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#ifdef HAVE_LIMITS_H
#include <limits.h>
#endif


/*
 * minimal include directives 
 */
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "header_complex.h"
#include "expExpressionTable.h"
#include "expObjectTable.h"


/*
 * expObjectTable_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */
oid             TimeInstance[] = { 1, 3, 6, 1, 2, 1, 1, 3, 0 };

oid             expObjectTable_variables_oid[] =
    { 1, 3, 6, 1, 2, 1, 90, 1, 2, 3 };

/*
 * variable2 expObjectTable_variables:
 */

struct variable2 expObjectTable_variables[] = {
    /*
     * magic number        , variable type , ro/rw , callback fn  , L, oidsuffix 
     */
#define	EXPOBJECTID  2
    {EXPOBJECTID,         ASN_OBJECT_ID, NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 2}},
#define	EXPOBJECTIDWILDCARD 3
    {EXPOBJECTIDWILDCARD, ASN_INTEGER,   NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 3}},
#define	EXPOBJECTSAMPLETYPE 4
    {EXPOBJECTSAMPLETYPE, ASN_INTEGER,   NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 4}},
#define	EXPOBJECTDELTADISCONTINUITYID 5
    {EXPOBJECTDELTADISCONTINUITYID,  ASN_OBJECT_ID, NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 5}},
#define	EXPOBJECTDISCONTINUITYIDWILDCARD 6
    {EXPOBJECTDISCONTINUITYIDWILDCARD, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 6}},
#define	EXPOBJECTDISCONTINUITYIDTYPE 7
    {EXPOBJECTDISCONTINUITYIDTYPE,     ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 7}},
#define	EXPOBJECTCONDITIONAL  8
    {EXPOBJECTCONDITIONAL, ASN_OBJECT_ID, NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 8}},
#define	EXPOBJECTCONDITIONALWILDCARD  9
    {EXPOBJECTCONDITIONALWILDCARD,     ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 9}},
#define	EXPOBJECTENTRYSTATUS  10
    {EXPOBJECTENTRYSTATUS, ASN_INTEGER, NETSNMP_OLDAPI_RWRITE,
     var_expObjectTable, 2, {1, 10}}
};


/*
 * global storage of our data, saved in and configured by header_complex() 
 */
extern struct header_complex_index *expExpressionTableStorage;
extern struct header_complex_index *expValueTableStorage;

struct header_complex_index *expObjectTableStorage = NULL;

/*
 * init_expObjectTable():
 *   Initialization routine.  This is called when the agent starts up.
 *   At a minimum, registration of your variables should take place here.
 */
void
init_expObjectTable(void)
{
    DEBUGMSGTL(("expObjectTable", "initializing...  "));


    /*
     * register ourselves with the agent to handle our mib tree 
     */
    REGISTER_MIB("expObjectTable",
                 expObjectTable_variables, variable2,
                 expObjectTable_variables_oid);

    /*
     * register our config handler(s) to deal with registrations 
     */
    snmpd_register_config_handler("expObjectTable", parse_expObjectTable,
                                  NULL, NULL);

    snmp_register_callback(SNMP_CALLBACK_LIBRARY, SNMP_CALLBACK_STORE_DATA,
                           store_expObjectTable, NULL);

    DEBUGMSGTL(("expObjectTable", "done.\n"));
}


struct expObjectTable_data *
create_expObjectTable_data(void)
{
    struct expObjectTable_data *StorageNew;

    StorageNew = SNMP_MALLOC_STRUCT(expObjectTable_data);

    /*
     * fill in default row values here into StorageNew 
     */
    /*
     * fill in values for all tables (even if not
     * appropriate), since its easier to do here than anywhere
     * else 
     */

    StorageNew->expObjectIDWildcard = EXPOBJCETIDWILDCARD_FALSE;
    StorageNew->expObjectSampleType = EXPOBJCETSAMPLETYPE_ABSOLUTEVALUE;
    memdup((unsigned char **)
           &(StorageNew->expObjectDeltaDiscontinuityID),
           (unsigned char *) TimeInstance, sizeof(TimeInstance));
    StorageNew->expObjectDeltaDiscontinuityIDLen =
        sizeof(TimeInstance) / sizeof(oid);




    StorageNew->expObjectDiscontinuityIDWildcard =
        EXPOBJCETDISCONTINUITYIDWILDCARD_FALSE;
    StorageNew->expObjectDiscontinuityIDType =
        EXPOBJECTDISCONTINUITYIDTYPE_TIMETICKS;

    StorageNew->expObjectConditional = calloc(1, sizeof(oid) * 2);      /* 0.0 */
    StorageNew->expObjectConditionalLen = 2;

    StorageNew->expObjectID = calloc(1, sizeof(oid) * 2);       /* 0.0 */
    StorageNew->expObjectIDLen = 2;

    StorageNew->expObjectConditionalWildcard =
        EXPOBJECTCONDITIONALWILDCARD_FALSE;
    StorageNew->storageType = ST_NONVOLATILE;

    return StorageNew;
}

int
expObjectTable_add(struct expObjectTable_data *thedata)
{
    netsnmp_variable_list *vars = NULL;


    DEBUGMSGTL(("expObjectTable", "adding data...  "));
    /*
     * add the index variables to the varbind list, which is 
     * used by header_complex to index the data 
     */


    snmp_varlist_add_variable(&vars, NULL, 0, ASN_OCTET_STR, (char *) thedata->expExpressionOwner, thedata->expExpressionOwnerLen);     /* expExpressionOwner */
    snmp_varlist_add_variable(&vars, NULL, 0, ASN_OCTET_STR, (char *) thedata->expExpressionName, thedata->expExpressionNameLen);       /* expExpressionName */
    snmp_varlist_add_variable(&vars, NULL, 0, ASN_UNSIGNED, (char *) &thedata->expObjectIndex, sizeof(thedata->expObjectIndex));        /* expExpressionName */




    header_complex_add_data(&expObjectTableStorage, vars, thedata);
    DEBUGMSGTL(("expObjectTable", "registered an entry\n"));


    DEBUGMSGTL(("expObjectTable", "done.\n"));
    return SNMPERR_SUCCESS;
}



/*
 * parse_mteTriggerTable():
 *   parses .conf file entries needed to configure the mib.
 */
void
parse_expObjectTable(const char *token, char *line)
{
    size_t          tmpint;
    oid            *tmpoid = NULL;
    struct expObjectTable_data *StorageTmp =
        SNMP_MALLOC_STRUCT(expObjectTable_data);

    DEBUGMSGTL(("expObjectTable", "parsing config...  "));

    if (StorageTmp == NULL) {
        config_perror("malloc failure");
        return;
    }

    line =
        read_config_read_data(ASN_OCTET_STR, line,
                              &StorageTmp->expExpressionOwner,
                              &StorageTmp->expExpressionOwnerLen);
    if (StorageTmp->expExpressionOwner == NULL) {
        config_perror("invalid specification for expExpressionOwner");
        return;
    }

    line =
        read_config_read_data(ASN_OCTET_STR, line,
                              &StorageTmp->expExpressionName,
                              &StorageTmp->expExpressionNameLen);
    if (StorageTmp->expExpressionName == NULL) {
        config_perror("invalid specification for expExpressionName");
        return;
    }

    line =
        read_config_read_data(ASN_UNSIGNED, line,
                              &StorageTmp->expObjectIndex, &tmpint);

    line =
        read_config_read_data(ASN_OBJECT_ID, line,
                              &StorageTmp->expObjectID,
                              &StorageTmp->expObjectIDLen);
    if (StorageTmp->expObjectID == NULL) {
        config_perror("invalid specification for expObjectID");
        return;
    }

    line =
        read_config_read_data(ASN_INTEGER, line,
                              &StorageTmp->expObjectIDWildcard, &tmpint);

    line =
        read_config_read_data(ASN_INTEGER, line,
                              &StorageTmp->expObjectSampleType, &tmpint);

    line =
        read_config_read_data(ASN_OBJECT_ID, line,
                              &StorageTmp->expObjectDeltaDiscontinuityID,
                              &StorageTmp->
                              expObjectDeltaDiscontinuityIDLen);
    if (StorageTmp->expObjectDeltaDiscontinuityID == NULL) {
        config_perror
            ("invalid specification for expObjectDeltaDiscontinuityID");
        return;
    }

    line =
        read_config_read_data(ASN_INTEGER, line,
                              &StorageTmp->
                              expObjectDiscontinuityIDWildcard, &tmpint);

    line =
        read_config_read_data(ASN_INTEGER, line,
                              &StorageTmp->expObjectDiscontinuityIDType,
                              &tmpint);

    line =
        read_config_read_data(ASN_OBJECT_ID, line,
                              &StorageTmp->expObjectConditional,
                              &StorageTmp->expObjectConditionalLen);
    if (StorageTmp->expObjectConditional == NULL) {
        config_perror("invalid specification for expObjectConditional");
        return;
    }

    line =
        read_config_read_data(ASN_INTEGER, line,
                              &StorageTmp->expObjectConditionalWildcard,
                              &tmpint);

    line =
        read_config_read_data(ASN_INTEGER, line,
                              &StorageTmp->expObjectEntryStatus, &tmpint);

    StorageTmp->storageType = ST_NONVOLATILE;
    expObjectTable_add(StorageTmp);

    DEBUGMSGTL(("expObjectTable", "done.\n"));

}



/*
 * store_expExpressionTable():
 *   stores .conf file entries needed to configure the mib.
 */
int
store_expObjectTable(int majorID, int minorID, void *serverarg,
                     void *clientarg)
{
    char            line[SNMP_MAXBUF];
    char           *cptr;
    size_t          tmpint;
    struct expObjectTable_data *StorageTmp;
    struct header_complex_index *hcindex;

    DEBUGMSGTL(("expObjectTable", "storing data...  "));

    for (hcindex = expObjectTableStorage; hcindex != NULL;
         hcindex = hcindex->next) {
        StorageTmp = (struct expObjectTable_data *) hcindex->data;



        if (StorageTmp->storageType == ST_NONVOLATILE) {

            memset(line, 0, sizeof(line));
            strcat(line, "expObjectTable ");
            cptr = line + strlen(line);
            /*
             * expObjectTable
             */

            cptr =
                read_config_store_data(ASN_OCTET_STR, cptr,
                                       &StorageTmp->expExpressionOwner,
                                       &StorageTmp->expExpressionOwnerLen);
            cptr =
                read_config_store_data(ASN_OCTET_STR, cptr,
                                       &StorageTmp->expExpressionName,
                                       &StorageTmp->expExpressionNameLen);
            cptr =
                read_config_store_data(ASN_UNSIGNED, cptr,
                                       &StorageTmp->expObjectIndex,
                                       &tmpint);
            cptr =
                read_config_store_data(ASN_OBJECT_ID, cptr,
                                       &StorageTmp->expObjectID,
                                       &StorageTmp->expObjectIDLen);
            cptr =
                read_config_store_data(ASN_INTEGER, cptr,
                                       &StorageTmp->expObjectIDWildcard,
                                       &tmpint);
            cptr =
                read_config_store_data(ASN_INTEGER, cptr,
                                       &StorageTmp->expObjectSampleType,
                                       &tmpint);
            cptr =
                read_config_store_data(ASN_OBJECT_ID, cptr,
                                       &StorageTmp->
                                       expObjectDeltaDiscontinuityID,
                                       &StorageTmp->
                                       expObjectDeltaDiscontinuityIDLen);
            cptr =
                read_config_store_data(ASN_INTEGER, cptr,
                                       &StorageTmp->
                                       expObjectDiscontinuityIDWildcard,
                                       &tmpint);
            cptr =
                read_config_store_data(ASN_INTEGER, cptr,
                                       &StorageTmp->
                                       expObjectDiscontinuityIDType,
                                       &tmpint);
            cptr =
                read_config_store_data(ASN_OBJECT_ID, cptr,
                                       &StorageTmp->expObjectConditional,
                                       &StorageTmp->
                                       expObjectConditionalLen);
            cptr =
                read_config_store_data(ASN_INTEGER, cptr,
                                       &StorageTmp->
                                       expObjectConditionalWildcard,
                                       &tmpint);
            cptr =
                read_config_store_data(ASN_INTEGER, cptr,
                                       &StorageTmp->expObjectEntryStatus,
                                       &tmpint);
            snmpd_store_config(line);
        }
    }
    DEBUGMSGTL(("expObjectTable", "storage done\n"));
}


/*
 * var_expObjectTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_expObjectTable above.
 */
unsigned char  *
var_expObjectTable(struct variable *vp,
                   oid * name,
                   size_t *length,
                   int exact, size_t *var_len, WriteMethod ** write_method)
{
    struct expObjectTable_data *StorageTmp = NULL;


    DEBUGMSGTL(("expObjectTable", "var_expObjectTable: Entering...  \n"));
    /*
     * this assumes you have registered all your data properly
     */
    if ((StorageTmp =
         header_complex(expObjectTableStorage, vp, name, length, exact,
                        var_len, write_method)) == NULL) {
        if (vp->magic == EXPOBJECTENTRYSTATUS)
            *write_method = write_expObjectEntryStatus;
        return NULL;
    }
    /*
     * this is where we do the value assignments for the mib results.
     */
    switch (vp->magic) {

    case EXPOBJECTID:
        *write_method = write_expObjectID;
        *var_len = StorageTmp->expObjectIDLen * sizeof(oid);
        return (u_char *) StorageTmp->expObjectID;

    case EXPOBJECTIDWILDCARD:
        *write_method = write_expObjectIDWildcard;
        *var_len = sizeof(StorageTmp->expObjectIDWildcard);
        return (u_char *) & StorageTmp->expObjectIDWildcard;

    case EXPOBJECTSAMPLETYPE:
        *write_method = write_expObjectSampleType;
        *var_len = sizeof(StorageTmp->expObjectSampleType);
        return (u_char *) & StorageTmp->expObjectSampleType;

    case EXPOBJECTDELTADISCONTINUITYID:
        *write_method = write_expObjectDeltaDiscontinuityID;
        *var_len =
            StorageTmp->expObjectDeltaDiscontinuityIDLen * sizeof(oid);
        return (u_char *) StorageTmp->expObjectDeltaDiscontinuityID;

    case EXPOBJECTDISCONTINUITYIDWILDCARD:
        *write_method = write_expObjectDiscontinuityIDWildcard;
        *var_len = sizeof(StorageTmp->expObjectDiscontinuityIDWildcard);
        return (u_char *) & StorageTmp->expObjectDiscontinuityIDWildcard;

    case EXPOBJECTDISCONTINUITYIDTYPE:
        *write_method = write_expObjectDiscontinuityIDWildcard;
        *var_len = sizeof(StorageTmp->expObjectDiscontinuityIDType);
        return (u_char *) & StorageTmp->expObjectDiscontinuityIDType;

    case EXPOBJECTCONDITIONAL:
        *write_method = write_expObjectConditional;
        *var_len = StorageTmp->expObjectConditionalLen * sizeof(oid);
        return (u_char *) StorageTmp->expObjectConditional;

    case EXPOBJECTCONDITIONALWILDCARD:
        *write_method = write_expObjectConditionalWildcard;
        *var_len = sizeof(StorageTmp->expObjectConditionalWildcard);
        return (u_char *) & StorageTmp->expObjectConditionalWildcard;

    case EXPOBJECTENTRYSTATUS:
        *write_method = write_expObjectEntryStatus;
        *var_len = sizeof(StorageTmp->expObjectEntryStatus);
        return (u_char *) & StorageTmp->expObjectEntryStatus;


    default:
        ERROR_MSG("");
    }
    return NULL;
}

int
write_expObjectID(int action,
                  u_char * var_val,
                  u_char var_val_type,
                  size_t var_val_len,
                  u_char * statP, oid * name, size_t name_len)
{
    static oid     *tmpvar;
    struct expObjectTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);


    DEBUGMSGTL(("expObjectTable",
                "write_expObjectID entering action=%d...  \n", action));
    if ((StorageTmp =
         header_complex(expObjectTableStorage, NULL,
                        &name[sizeof(expObjectTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OBJECT_ID) {
            snmp_log(LOG_ERR, "write to expObjectID not ASN_OBJECT_ID\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in objid for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->expObjectID;
        tmplen = StorageTmp->expObjectIDLen;
        memdup((u_char **) & StorageTmp->expObjectID, var_val,
               var_val_len);
        StorageTmp->expObjectIDLen = var_val_len / sizeof(oid);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->expObjectID);
        StorageTmp->expObjectID = tmpvar;
        StorageTmp->expObjectIDLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        /*
         * XXX: if the valueID has actually changed, shouldn't we dump any
         * previous values, as these are from a different object?  
         */
        SNMP_FREE(tmpvar);
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}

int
write_expObjectIDWildcard(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    static int      tmpvar;
    struct expObjectTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);


    DEBUGMSGTL(("expObjectTable",
                "write_expObjectIDWildcard entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(expObjectTableStorage, NULL,
                        &name[sizeof(expObjectTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            snmp_log(LOG_ERR,
                     "write to expObjectIDWildcard not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->expObjectIDWildcard;
        StorageTmp->expObjectIDWildcard = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->expObjectIDWildcard = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}


int
write_expObjectSampleType(int action,
                          u_char * var_val,
                          u_char var_val_type,
                          size_t var_val_len,
                          u_char * statP, oid * name, size_t name_len)
{
    static int      tmpvar;
    struct expObjectTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);


    DEBUGMSGTL(("expObjectTable",
                "write_expObjectSampleType entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(expObjectTableStorage, NULL,
                        &name[sizeof(expObjectTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            snmp_log(LOG_ERR,
                     "write to expObjectSampleTypenot ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->expObjectSampleType;
        StorageTmp->expObjectSampleType = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->expObjectSampleType = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_expObjectDeltaDiscontinuityID(int action,
                                    u_char * var_val,
                                    u_char var_val_type,
                                    size_t var_val_len,
                                    u_char * statP, oid * name,
                                    size_t name_len)
{
    static oid     *tmpvar;
    struct expObjectTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);


    DEBUGMSGTL(("expObjectTable",
                "write_expObjectDeltaDiscontinuityID entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(expObjectTableStorage, NULL,
                        &name[sizeof(expObjectTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OBJECT_ID) {
            snmp_log(LOG_ERR,
                     "write to expObjectDeltaDiscontinuityID not ASN_OBJECT_ID\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in objid for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->expObjectDeltaDiscontinuityID;
        tmplen = StorageTmp->expObjectDeltaDiscontinuityIDLen;
        memdup((u_char **) & StorageTmp->expObjectDeltaDiscontinuityID,
               var_val, var_val_len);
        StorageTmp->expObjectDeltaDiscontinuityIDLen =
            var_val_len / sizeof(oid);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->expObjectDeltaDiscontinuityID);
        StorageTmp->expObjectDeltaDiscontinuityID = tmpvar;
        StorageTmp->expObjectDeltaDiscontinuityIDLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        /*
         * XXX: if the valueID has actually changed, shouldn't we dump any
         * previous values, as these are from a different object?  
         */
        SNMP_FREE(tmpvar);
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_expObjectDiscontinuityIDWildcard(int action,
                                       u_char * var_val,
                                       u_char var_val_type,
                                       size_t var_val_len,
                                       u_char * statP,
                                       oid * name, size_t name_len)
{
    static int      tmpvar;
    struct expObjectTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);


    DEBUGMSGTL(("expObjectTable",
                "write_expObjectDiscontinuityIDWildcard entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(expObjectTableStorage, NULL,
                        &name[sizeof(expObjectTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            snmp_log(LOG_ERR,
                     "write to expObjectDiscontinuityIDWildcard not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->expObjectDiscontinuityIDWildcard;
        StorageTmp->expObjectDiscontinuityIDWildcard = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->expObjectDiscontinuityIDWildcard = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_expObjectDiscontinuityIDType(int action,
                                   u_char * var_val,
                                   u_char var_val_type,
                                   size_t var_val_len,
                                   u_char * statP,
                                   oid * name, size_t name_len)
{
    static int      tmpvar;
    struct expObjectTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);


    DEBUGMSGTL(("expObjectTable",
                "write_expObjectDiscontinuityIDWildcard entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(expObjectTableStorage, NULL,
                        &name[sizeof(expObjectTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            snmp_log(LOG_ERR,
                     "write to expObjectDiscontinuityIDType not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->expObjectDiscontinuityIDType;
        StorageTmp->expObjectDiscontinuityIDType = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->expObjectDiscontinuityIDType = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}



int
write_expObjectConditional(int action,
                           u_char * var_val,
                           u_char var_val_type,
                           size_t var_val_len,
                           u_char * statP, oid * name, size_t name_len)
{
    static oid     *tmpvar;
    struct expObjectTable_data *StorageTmp = NULL;
    static size_t   tmplen;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);


    DEBUGMSGTL(("expObjectTable",
                "write_expObjectConditional entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(expObjectTableStorage, NULL,
                        &name[sizeof(expObjectTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_OBJECT_ID) {
            snmp_log(LOG_ERR,
                     "write to expObjectConditional not ASN_OBJECT_ID\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in objid for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->expObjectConditional;
        tmplen = StorageTmp->expObjectConditionalLen;
        memdup((u_char **) & StorageTmp->expObjectConditional, var_val,
               var_val_len);
        StorageTmp->expObjectConditionalLen = var_val_len / sizeof(oid);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        SNMP_FREE(StorageTmp->expObjectConditional);
        StorageTmp->expObjectConditional = tmpvar;
        StorageTmp->expObjectConditionalLen = tmplen;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */

        /*
         * XXX: if the valueID has actually changed, shouldn't we dump any
         * previous values, as these are from a different object?  
         */
        SNMP_FREE(tmpvar);
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}




int
write_expObjectConditionalWildcard(int action,
                                   u_char * var_val,
                                   u_char var_val_type,
                                   size_t var_val_len,
                                   u_char * statP,
                                   oid * name, size_t name_len)
{
    static int      tmpvar;
    struct expObjectTable_data *StorageTmp = NULL;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);


    DEBUGMSGTL(("expObjectTable",
                "write_expObjectConditionalWildcard entering action=%d...  \n",
                action));
    if ((StorageTmp =
         header_complex(expObjectTableStorage, NULL,
                        &name[sizeof(expObjectTable_variables_oid) /
                              sizeof(oid) + 3 - 1], &newlen, 1, NULL,
                        NULL)) == NULL)
        return SNMP_ERR_NOSUCHNAME;     /* remove if you support creation here */


    switch (action) {
    case RESERVE1:
        if (var_val_type != ASN_INTEGER) {
            snmp_log(LOG_ERR,
                     "write to expObjectConditionalWildcard not ASN_INTEGER\n");
            return SNMP_ERR_WRONGTYPE;
        }
        if (StorageTmp->storageType != ST_NONVOLATILE)
            return SNMP_ERR_NOTWRITABLE;
        break;


    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        break;


    case FREE:
        /*
         * Release any resources that have been allocated 
         */
        break;


    case ACTION:
        /*
         * The variable has been stored in long_ret for
         * you to use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in the UNDO case 
         */
        tmpvar = StorageTmp->expObjectConditionalWildcard;
        StorageTmp->expObjectConditionalWildcard = *((long *) var_val);
        break;


    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        StorageTmp->expObjectConditionalWildcard = tmpvar;
        break;


    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}




int
write_expObjectEntryStatus(int action,
                           u_char * var_val,
                           u_char var_val_type,
                           size_t var_val_len,
                           u_char * statP, oid * name, size_t name_len)
{
    struct expObjectTable_data *StorageTmp = NULL;
    static struct expObjectTable_data *StorageNew, *StorageDel;
    size_t          newlen =
        name_len - (sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                    3 - 1);
    static int      old_value;
    int             set_value;
    static netsnmp_variable_list *vars, *vp;
    struct header_complex_index *hciptr;

    StorageTmp =
        header_complex(expObjectTableStorage, NULL,
                       &name[sizeof(expObjectTable_variables_oid) /
                             sizeof(oid) + 3 - 1], &newlen, 1, NULL, NULL);




    if (var_val_type != ASN_INTEGER || var_val == NULL) {
        snmp_log(LOG_ERR,
                 "write to expObjectEntryStatus not ASN_INTEGER\n");
        return SNMP_ERR_WRONGTYPE;
    }
    set_value = *((long *) var_val);


    /*
     * check legal range, and notReady is reserved for us, not a user 
     */
    if (set_value < 1 || set_value > 6 || set_value == RS_NOTREADY)
        return SNMP_ERR_INCONSISTENTVALUE;


    switch (action) {
    case RESERVE1:
        /*
         * stage one: test validity 
         */
        if (StorageTmp == NULL) {
            /*
             * create the row now? 
             */


            /*
             * ditch illegal values now 
             */
            if (set_value == RS_ACTIVE || set_value == RS_NOTINSERVICE)
                return SNMP_ERR_INCONSISTENTVALUE;


            /*
             * destroying a non-existent row is actually legal 
             */
            if (set_value == RS_DESTROY) {
                return SNMP_ERR_NOERROR;
            }


            /*
             * illegal creation values 
             */
            if (set_value == RS_ACTIVE || set_value == RS_NOTINSERVICE) {
                return SNMP_ERR_INCONSISTENTVALUE;
            }
        } else {
            /*
             * row exists.  Check for a valid state change 
             */
            if (set_value == RS_CREATEANDGO
                || set_value == RS_CREATEANDWAIT) {
                /*
                 * can't create a row that exists 
                 */
                return SNMP_ERR_INCONSISTENTVALUE;
            }

            if (StorageTmp->expObjectEntryStatus == RS_ACTIVE &&
                set_value != RS_DESTROY) {
                /*
                 * "Once made active an entry may not be modified except to 
                 * delete it."  XXX: doesn't this in fact apply to ALL
                 * columns of the table and not just this one?  
                 */
                return SNMP_ERR_INCONSISTENTVALUE;
            }
            if (StorageTmp->storageType != ST_NONVOLATILE)
                return SNMP_ERR_NOTWRITABLE;
        }
        break;




    case RESERVE2:
        /*
         * memory reseveration, final preparation... 
         */
        if (StorageTmp == NULL) {
            /*
             * creation 
             */
            vars = NULL;


            snmp_varlist_add_variable(&vars, NULL, 0, ASN_OCTET_STR, NULL, 0);  /* expExpressionOwner */
            snmp_varlist_add_variable(&vars, NULL, 0, ASN_OCTET_STR, NULL, 0);  /* expExpressionName */
            snmp_varlist_add_variable(&vars, NULL, 0, ASN_UNSIGNED, NULL, 0);   /* expObjectIndex */



            if (header_complex_parse_oid
                (&
                 (name
                  [sizeof(expObjectTable_variables_oid) / sizeof(oid) +
                   2]), newlen, vars) != SNMPERR_SUCCESS) {
                /*
                 * XXX: free, zero vars 
                 */
                return SNMP_ERR_INCONSISTENTNAME;
            }
            vp = vars;


            StorageNew = create_expObjectTable_data();

            StorageNew->expExpressionOwner = malloc(vp->val_len + 1);
            memcpy(StorageNew->expExpressionOwner, vp->val.string,
                   vp->val_len);
            StorageNew->expExpressionOwner[vp->val_len] = '\0';
            StorageNew->expExpressionOwnerLen = vp->val_len;

            vp = vp->next_variable;
            StorageNew->expExpressionName = malloc(vp->val_len + 1);
            memcpy(StorageNew->expExpressionName, vp->val.string,
                   vp->val_len);

            StorageNew->expExpressionName[vp->val_len] = '\0';
            StorageNew->expExpressionNameLen = vp->val_len;

            vp = vp->next_variable;
            StorageNew->expObjectIndex = *vp->val.integer;

            StorageNew->expObjectEntryStatus = set_value;

        }


        break;




    case FREE:
        /*
         * XXX: free, zero vars 
         */
        /*
         * Release any resources that have been allocated 
         */
        break;




    case ACTION:
        /*
         * The variable has been stored in set_value for you to
         * use, and you have just been asked to do something with
         * it.  Note that anything done here must be reversable in
         * the UNDO case 
         */


        if (StorageTmp == NULL) {
            /*
             * row creation, so add it 
             */
            if (StorageNew != NULL)
                expObjectTable_add(StorageNew);
            /*
             * XXX: ack, and if it is NULL? 
             */
        } else if (set_value != RS_DESTROY) {
            /*
             * set the flag? 
             */
            old_value = StorageTmp->expObjectEntryStatus;
            StorageTmp->expObjectEntryStatus = *((long *) var_val);
        } else {
            /*
             * destroy...  extract it for now 
             */
            hciptr =
                header_complex_find_entry(expObjectTableStorage,
                                          StorageTmp);
            StorageDel =
                header_complex_extract_entry(&expObjectTableStorage,
                                             hciptr);
        }
        break;




    case UNDO:
        /*
         * Back out any changes made in the ACTION case 
         */
        if (StorageTmp == NULL) {
            /*
             * row creation, so remove it again 
             */
            hciptr =
                header_complex_find_entry(expObjectTableStorage,
                                          StorageTmp);
            StorageDel =
                header_complex_extract_entry(&expObjectTableStorage,
                                             hciptr);
            /*
             * XXX: free it 
             */
        } else if (StorageDel != NULL) {
            /*
             * row deletion, so add it again 
             */
            expObjectTable_add(StorageDel);
        } else {
            StorageTmp->expObjectEntryStatus = old_value;
        }
        break;




    case COMMIT:
        /*
         * Things are working well, so it's now safe to make the change
         * permanently.  Make sure that anything done here can't fail! 
         */
        if (StorageDel != NULL) {
            StorageDel = 0;
            /*
             * XXX: free it, its dead 
             */
        } else {
            if (StorageTmp
                && StorageTmp->expObjectEntryStatus == RS_CREATEANDGO) {
                StorageTmp->expObjectEntryStatus = RS_ACTIVE;
            } else if (StorageTmp &&
                       StorageTmp->expObjectEntryStatus ==
                       RS_CREATEANDWAIT) {
                StorageTmp->expObjectEntryStatus = RS_NOTINSERVICE;
            }
        }
        snmp_store_needed(NULL);
        break;
    }
    return SNMP_ERR_NOERROR;
}
