/*
 * Decompiled with CFR 0.152.
 */
package com.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.Context;
import android.os.SystemClock;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.robotium.solo.ActivityUtils;
import com.robotium.solo.Sleeper;
import com.robotium.solo.ViewFetcher;

class DialogUtils {
    private final Instrumentation instrumentation;
    private final ActivityUtils activityUtils;
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;
    private static final int TIMEOUT_DIALOG_TO_CLOSE = 1000;
    private final int MINISLEEP = 200;

    public DialogUtils(Instrumentation instrumentation, ActivityUtils activityUtils, ViewFetcher viewFetcher, Sleeper sleeper) {
        this.instrumentation = instrumentation;
        this.activityUtils = activityUtils;
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public boolean waitForDialogToClose(long timeout) {
        this.waitForDialogToOpen(1000L, false);
        long endTime = SystemClock.uptimeMillis() + timeout;
        while (SystemClock.uptimeMillis() < endTime) {
            if (!this.isDialogOpen()) {
                return true;
            }
            this.sleeper.sleep(200);
        }
        return false;
    }

    public boolean waitForDialogToOpen(long timeout, boolean sleepFirst) {
        long endTime = SystemClock.uptimeMillis() + timeout;
        boolean dialogIsOpen = this.isDialogOpen();
        if (sleepFirst) {
            this.sleeper.sleep();
        }
        if (dialogIsOpen) {
            return true;
        }
        while (SystemClock.uptimeMillis() < endTime) {
            if (this.isDialogOpen()) {
                return true;
            }
            this.sleeper.sleepMini();
        }
        return false;
    }

    private boolean isDialogOpen() {
        View[] views;
        View view;
        Activity activity = this.activityUtils.getCurrentActivity(false);
        if (!this.isDialog(activity, view = this.viewFetcher.getRecentDecorView(views = this.viewFetcher.getWindowDecorViews()))) {
            for (View v : views) {
                if (!this.isDialog(activity, v)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean isDialog(Activity activity, View decorView) {
        if (decorView == null || !decorView.isShown() || activity == null) {
            return false;
        }
        Context viewContext = null;
        if (decorView != null) {
            viewContext = decorView.getContext();
        }
        if (viewContext instanceof ContextThemeWrapper) {
            ContextThemeWrapper ctw = (ContextThemeWrapper)viewContext;
            viewContext = ctw.getBaseContext();
        }
        Activity activityContext = activity;
        Context activityBaseContext = activity.getBaseContext();
        return (activityContext.equals(viewContext) || activityBaseContext.equals(viewContext)) && decorView != activity.getWindow().getDecorView();
    }

    public void hideSoftKeyboard(EditText editText, boolean shouldSleepFirst, boolean shouldSleepAfter) {
        EditText freshestEditText;
        Activity activity = this.activityUtils.getCurrentActivity(shouldSleepFirst);
        InputMethodManager inputMethodManager = activity == null ? (InputMethodManager)this.instrumentation.getTargetContext().getSystemService("input_method") : (InputMethodManager)activity.getSystemService("input_method");
        if (editText != null) {
            inputMethodManager.hideSoftInputFromWindow(editText.getWindowToken(), 0);
            return;
        }
        View focusedView = activity.getCurrentFocus();
        if (!(focusedView instanceof EditText) && (freshestEditText = this.viewFetcher.getFreshestView(this.viewFetcher.getCurrentViews(EditText.class, true))) != null) {
            focusedView = freshestEditText;
        }
        if (focusedView != null) {
            inputMethodManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
        if (shouldSleepAfter) {
            this.sleeper.sleep();
        }
    }
}

