<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_authz_owner - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_authz_owner</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_owner.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_owner.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_authz_owner.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_authz_owner.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Autorisation base sur l'appartenance des
fichiers</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>authz_owner_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_authz_owner.c</td></tr>
<tr><th><a href="module-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis les versions 2.1 et suprieures
d'Apache</td></tr></table>
<h3>Sommaire</h3>

    <p>Ce module permet de contrler l'accs aux fichiers en comparant
    l'identifiant utilisateur ayant servi  l'authentification HTTP
    (l'identifiant utilisateur web) avec le propritaire ou le groupe
    du fichier demand du point de vue du systme de fichiers. Le nom
    d'utilisateur et le mot de passe doivent dj avoir t vrifis par
    un module d'authentification comme <code class="module"><a href="../mod/mod_auth_basic.html">mod_auth_basic</a></code>
    ou <code class="module"><a href="../mod/mod_auth_digest.html">mod_auth_digest</a></code>.
    <code class="module"><a href="../mod/mod_authz_owner.html">mod_authz_owner</a></code> reconnat deux arguments pour la
    directive <code class="directive"><a href="../mod/core.html#require">Require</a></code> :
    <code>file-owner</code> et <code>file-group</code> :</p>

    <dl>
      <dt><code>file-owner</code></dt>
      <dd>Le nom d'utilisateur web utilis pour l'authentification doit
      correspondre au nom systme du propritaire du fichier demand. En
      d'autres termes, si le systme indique <code>jones</code> comme
      propritaire du fichier demand, le nom d'utilisateur fourni pour
      l'authentification HTTP doit aussi tre <code>jones</code>.</dd>

      <dt><code>file-group</code></dt>
      <dd>Le nom du groupe systme du fichier demand doit tre prsent
      dans une base de donnes de groupes fournie, par exemple, par
      <code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code> ou
      <code class="module"><a href="../mod/mod_authz_dbm.html">mod_authz_dbm</a></code>, et le nom d'utilisateur web fourni
      pour l'authentification doit tre un membre de ce groupe. Par
      exemple, si le systme indique que le groupe (systme) du fichier
      demand est <code>accounts</code>, le groupe <code>accounts</code>
      doit apparatre dans la base de donnes des groupes, et le nom
      d'utilisateur web utilis pour l'authentification doit tre un
      membre de ce groupe.</dd>
    </dl>

    <div class="note"><h3>Note</h3>
      <p>Si le module <code class="module"><a href="../mod/mod_authz_owner.html">mod_authz_owner</a></code> est utilis pour
      vrifier l'autorisation d'accs  une ressource qui n'est pas
      vraiment prsente dans le systme de fichiers (en d'autres termes
      une ressource virtuelle), il refusera l'accs.</p>

      <p>En particulier, il n'accordera jamais l'accs  une ressource
      du type <a href="../content-negotiation.html#multiviews">"Vues
      multiples" (MultiViews) d'un contenu ngoci</a>.</p>
    </div>
</div>
<div id="quickview"><h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples de configuration</a></li>
</ul><h3 class="directives">Directives</h3>
<p>Ce module ne fournit aucune directive.</p>
<h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples de configuration</a></h2>

    <h3><a name="examples.file-owner" id="examples.file-owner">Require file-owner</a></h3>
      <p>Considrons un serveur Web Apache fonctionnant sous un systme
      multi-utilisateurs, o les fichiers de chaque utilisateur sont
      stocks dans <code>~/public_html/private</code>. En supposant
      qu'il n'existe qu'une seule base de donnes contenant les noms
      d'utilisateurs web, et que ces noms d'utilisateurs correspondent
      aux noms d'utilisateurs systme qui sont les propritaires
      effectifs des fichiers, la configuration de l'exemple suivant
      n'accordera l'autorisation d'accs aux fichiers qu' leur
      propritaire. L'utilisateur <code>jones</code> ne sera pas
      autoris  accder aux fichiers situs dans
      <code>/home/smith/public_html/private</code>,  moins que leur
      propritaire ne soit <code>jones</code> au lieu de
      <code>smith</code>.</p>

      <pre class="prettyprint lang-config">&lt;Directory "/home/*/public_html/private"&gt;
    AuthType Basic
    AuthName MyPrivateFiles
    AuthBasicProvider dbm
    AuthDBMUserFile "/usr/local/apache2/etc/.htdbm-all"
    Require file-owner
&lt;/Directory&gt;</pre>

    

    <h3><a name="examples.file-group" id="examples.file-group">Require file-group</a></h3>
      <p>Considrons un systme similaire  celui dcrit ci-dessus, mais
      o certains utilisateurs partagent leurs fichiers de projets dans
      <code>~/public_html/project-foo</code>. Le groupe systme des
      fichiers est <code>foo</code>, et il n'existe qu'une seule base de
      donnes <code class="directive"><a href="../mod/mod_authz_dbm.html#authdbmgroupfile">AuthDBMGroupFile</a></code> qui contient
      tous les noms d'utilisateurs web et leurs groupes d'appartenance.
      Ces noms d'utilisateurs web doivent alors appartenir au moins au
      groupe <code>foo</code>. En d'autres termes, si <code>jones</code>
      et <code>smith</code> sont tous deux membres du groupe
      <code>foo</code>, ils seront autoriss  accder aux
      rpertoires <code>project-foo</code> de chacun d'entre eux.</p>

      <pre class="prettyprint lang-config">&lt;Directory "/home/*/public_html/project-foo"&gt;
    AuthType Basic
    AuthName "Project Foo Files"
    AuthBasicProvider dbm
    
    # combined user/group database
    AuthDBMUserFile  "/usr/local/apache2/etc/.htdbm-all"
    AuthDBMGroupFile "/usr/local/apache2/etc/.htdbm-all"
    
    Satisfy All
    Require file-group
&lt;/Directory&gt;</pre>

    
</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_authz_owner.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_authz_owner.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_authz_owner.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/mod/mod_authz_owner.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_authz_owner.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>