#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include "ptt.h"

static int pttfd = -1;
static int pttinv = 0;

void init_ptt(char *path, int inverted)
{
	if (pttfd != -1) {
		set_ptt(0);
		close(pttfd);
		pttfd = -1;
	}

	pttinv = inverted;

	if (!strcasecmp(path, "none"))
		return;

	if ((pttfd = open(path, O_RDWR, 0)) < 0) {
		fprintf(stderr, "Cannot open PTT device '%s': %s\n",
			path, strerror(errno));
		return;
	}

	set_ptt(0);
}

void set_ptt(int ptt)
{
	int arg = TIOCM_RTS | TIOCM_DTR;

	if (pttfd == -1)
		return;

	if (pttinv)
		ptt = !ptt;

	if (ioctl(pttfd, ptt ? TIOCMBIS : TIOCMBIC, &arg) < 0)
		perror("ptt: ioctl");
}

