/*
 * fifo.h - include file for FIFO handling
 * Based on material from 'diald.h' 
 */
#ifndef FIFO_H
#define FIFO_H
#define fifo_h_RCS_ID $Id: fifo.h,v 1.6 2001/03/04 17:10:31 oz6bl Exp $

#include <stdio.h>
#include <string.h>
#include <unistd.h> 
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#include <sys/stat.h>
#include <sys/time.h>

extern char FIFOname[];

typedef struct monitors {
    struct monitors *next;
    int fd;			/* monitor output fp. */
    char *name;
} MONITORS;

typedef struct pipe {
    struct pipe *next;
    char *name;		/* the name given to this channel */
    int fd;		/* file descriptor */
    int count;		/* number of characters in the buffer now */
    char buf[1024];
} PIPE;

/* Debug variables */
#define DEBUG_FROM_KEYB 0x0001
#define DEBUG_TO_FIFO   0x0010
#define DEBUG_FROM_FIFO 0x0100
#define DEBUG_IN_TAG    0x0200
char debugline [2048] ;

/* Prototypes */
/* FIFO routines */

void pipe_init(PIPE *, char *, int, PIPE *, int) ;
int pipe_read(PIPE *) ;
void ctrl_read(PIPE *) ;
void mon_write(char *) ;
void pipe_flush(PIPE *,int) ;

/* XML routines*/

int getTag (PIPE *, char *, int) ;
int getTagWithValue (PIPE *, const char *, char *, int) ;
int getAnyTag (PIPE *, char *) ;
int putTag (FILE *, char *) ;
int putTagWithValue (FILE *, char *, char *) ;
int getValue (PIPE *, const char *, char *, int) ;
void encodePCData (char *, char *) ;
void decodePCData (char *, char *) ;

/* other routines */

void WriteToLog (char *) ;

#define TAGSIZE 1024

#endif FIFO_H
