/*
	duplicate.c
	Duplicate CD functions
	15.5.99 tn
*/

#include "largefile.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "xcdrdata.h"
#include "xcdroast.h"
#include "main.h"
#include "xpms/minidata.xpm"
#include "xpms/miniaudio.xpm"
#include "xpms/mininodata.xpm"
#include "xpms/mininoaudio.xpm"
#include "xpms/minitoc.xpm"
#include "xpms/disc_eject.xpm"
#include "xpms/disc_load.xpm"

GList *imagelist;
extern GtkWidget *toplevel;
extern GtkWidget *sidespace;
extern GtkWidget *workspace;

track_read_set_t trackreadset;
extern setup_data_t setupdata;
extern current_set_t curset;
extern cd_info_t cdinfo;
extern track_info_t **trackinfo;
extern gint wav_in;
extern GtkWidget *wav_quit_button;
extern gint wavplay_quit;
extern gint submenu;

GtkWidget *actionspace;
GtkCList *cdlist, *imglist, *play_clist;
GtkWidget *cdlist_l1, *cdlist_l2, *cdlist_l3, *cdlist_l4;
GtkWidget *vrylist_l1, *vrylist_l2, *vrylist_l3, *vrylist_l4;
GtkWidget *imglist_l1, *imglist_l2, *imglist_l3;
GtkWidget *write_toc_menu;
GtkWidget *edit_cdtext_btn;
GList *tocfiles;

void fill_read_menu();
void fill_verify_menu();
void fill_write_menu();
void fill_delete_menu();
void set_image_prefix_callback(GtkWidget *widget, gpointer data);
void tocwrite_selected(GtkWidget *item, gpointer val);

/* some stuff for the select-functions of the sidebar buttons */
guint side_handlers[7];
GtkWidget *side_widgets[7];
GtkWidget *locked_button;
extern guint side_handlers2[8];
extern GtkWidget *side_widgets2[8];
extern void fill_read_tracks(gint dontupdatecd);
extern void fill_verify_tracks(gint dontupdateimglist);
extern void fill_write_tracks();
extern void fill_master_write_menu();

void reset_duplicate_buttons(GtkWidget *exclude);
extern void reset_duplicate_buttons2(GtkWidget *exclude, gint fromunlock);


/* lock complete sidebar when doing stuff that takes a while (e.g. reload) */

void do_lock(gint plusgrab) {
int i;

	if (submenu == 1) {
		/* lock all and save currently selected button */
		for (i = 0; i < 7; i++) {
			gtk_signal_handler_block(GTK_OBJECT(side_widgets[i]),
				side_handlers[i]);
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(
				side_widgets[i])) == 1) {
				locked_button = side_widgets[i];
			}
		}
	}
	if (submenu == 2) {
		/* lock all and save currently selected button */
		for (i = 0; i < 8; i++) {
			gtk_signal_handler_block(GTK_OBJECT(side_widgets2[i]),
				side_handlers2[i]);
			if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(
				side_widgets2[i])) == 1) {
				locked_button = side_widgets2[i];
			}
		}
	}

	/* grab the button, so everything else is not active */
	if (plusgrab) {
		gtk_grab_add(locked_button);
	}
}


/* free the lock after we are done */

void do_unlock(gint plusgrab) {
int i;

	if (plusgrab) {
		gtk_grab_remove(locked_button);
	}

	if (submenu == 1) {
		for (i = 0; i < 7; i++) {
			gtk_signal_handler_unblock(GTK_OBJECT(side_widgets[i]),
				side_handlers[i]);
		}
		reset_duplicate_buttons(locked_button);
	}
	if (submenu == 2) {
		for (i = 0; i < 8; i++) {
			gtk_signal_handler_unblock(GTK_OBJECT(side_widgets2[i]),
				side_handlers2[i]);
		}
		reset_duplicate_buttons2(locked_button, 1);
	}
}


/* fill the cd-info-list with data */

void fill_cdlist() {
GtkStyle *style;
gchar *data[2];
GdkPixmap *pixmap1, *pixmap2;
GdkBitmap *mask1, *mask2;
gint i, lcount;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];

	/* clean up first */
	gtk_clist_clear(cdlist);

	/* cd loaded? */
	if (cdinfo.nr_tracks == -1) {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l1), text(156));	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l3),"");	
		return;
	}
	if (cdinfo.nr_tracks == -2) {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l1), text(196));	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l3),"");	
		return;
	}

	style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(cdlist)));
	pixmap1 = gdk_pixmap_create_from_xpm_d(cdlist->clist_window,
		&mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
	pixmap2 = gdk_pixmap_create_from_xpm_d(cdlist->clist_window,
		&mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);

	data[0] = NULL;
	lcount = 0;

	for (i = 0; i < cdinfo.nr_tracks; i++) {
		if (trackinfo[i]->type == 0) {
			convert_frames2mbstring(trackinfo[i]->size,tmp2);
			g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
				trackinfo[i]->track_nr,
				text(109), tmp2);
			data[1] = tmp;
			gtk_clist_append(cdlist,data);
			gtk_clist_set_pixmap(cdlist,lcount,0,pixmap1,mask1);
			lcount++;
		} else {
			convert_frames2minstring(trackinfo[i]->size,tmp2);
			g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
				trackinfo[i]->track_nr,
				text(110), tmp2);
			data[1] = tmp;
			gtk_clist_append(cdlist,data);
			gtk_clist_set_pixmap(cdlist,lcount,0,pixmap2,mask2);
			lcount++;
		}

		/* we have cd-text for this track? */
		if (setupdata.option_displaycdtext) {
			if (trackinfo[i]->title != NULL && 
			    trackinfo[i]->title[0] != '\0' ) {
				g_snprintf(tmp,MAXLINE,"  CD-Text: %s", 
					trackinfo[i]->title);
				data[1] = tmp;
				gtk_clist_append(cdlist,data);
				set_clist_row_font(cdlist,lcount, SLANTFONT);
				lcount++;
			}
		}

		/* have we a cddb-title for this track? */
		if (trackinfo[i]->cddb_ttitle != NULL) {
			g_snprintf(tmp,MAXLINE,"     CDDB: %s", 
				trackinfo[i]->cddb_ttitle);
			data[1] = tmp;
			gtk_clist_append(cdlist,data);
			set_clist_row_font(cdlist,lcount, SLANTFONT);
			lcount++;	
		} else
		if (trackinfo[i]->volname != NULL) {
			convert_kbytes2mbstring(trackinfo[i]->isosize*2,tmp2);
			g_snprintf(tmp,MAXLINE,"     ISO9660: %s [%s]", 
				trackinfo[i]->volname,tmp2);
			data[1] = tmp;
			gtk_clist_append(cdlist,data);
			set_clist_row_font(cdlist,lcount, SLANTFONT);
			lcount++;	
		} 

	}

	/* get cd-type */
	determine_cd_type(tmp,0);
	gtk_entry_set_text(GTK_ENTRY(cdlist_l1), tmp);	

	/* cd-label */
	if (cdinfo.title && cdinfo.artist && 
		cdinfo.title[0] != '\0' && setupdata.option_displaycdtext) {
		g_snprintf(tmp,MAXLINE,"%s / %s", cdinfo.title, cdinfo.artist);
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2), tmp);
		gtk_entry_set_position(GTK_ENTRY(cdlist_l2),0);
	} else 
	if (cdinfo.cddb_dtitle != NULL) {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2), cdinfo.cddb_dtitle);	
		gtk_entry_set_position(GTK_ENTRY(cdlist_l2),0);
	} else {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");	
	}

	/* cd-size */
	convert_frames2mbminstring(cdinfo.total_size, tmp);
	gtk_entry_set_text(GTK_ENTRY(cdlist_l3), tmp);	
	
}


/* fill the image-info-list with data */

void fill_imglist() {
GtkStyle *style;
gchar *data[2];
GdkPixmap *pixmap1, *pixmap2, *pixmap3, *pixmap4, *pixmap5;
GdkBitmap *mask1, *mask2, *mask3, *mask4, *mask5;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar basename[MAXLINE], oldbase[MAXLINE], fname[MAXLINE], *p;
GList *loop;
image_files_t *entry;
gint lcount, count;
gint sizecount;

	/* clean up first */
	gtk_clist_clear(imglist);

	style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(imglist)));
	pixmap1 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
	pixmap2 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
	pixmap3 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask3, &style->bg[GTK_STATE_NORMAL],(gchar **)mininodata_xpm);
	pixmap4 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask4, &style->bg[GTK_STATE_NORMAL],(gchar **)mininoaudio_xpm);
	pixmap5 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask5, &style->bg[GTK_STATE_NORMAL],(gchar **)minitoc_xpm);

	data[0] = NULL;
	strcpy(oldbase,"");
	lcount = 0;
	count = 1;
	sizecount = 0;

	loop = g_list_first(imagelist);
	while (loop) {
		entry = loop->data;

		/* get the base-dirname */
		strncpy(basename,entry->path,MAXLINE);	
		p = rindex(basename,'/');
		*p = '\0';
		if (strcmp(basename,"") == 0) {
			strcpy(basename,"/");
		}
		strcpy(fname,p+1);

		/* new path found? */
		if (strcmp(basename,oldbase) != 0) {
			g_snprintf(tmp,MAXLINE,"%s: %s",text(41), basename);
			data[1] = tmp;
			gtk_clist_append(imglist,data);
			set_clist_row_font(imglist,lcount, BOLDFONT);
			lcount++;
			strcpy(oldbase,basename);
		}

		/* iso9600-track/ unknown  */
		if (entry->type == 0 || entry->type == 3) {
			convert_frames2mbstring((gint)((off_t)entry->size/DATASECTORSIZE),
				tmp2);
			g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
				count, fname, tmp2);
			data[1] = tmp;
			gtk_clist_append(imglist,data);
			if (entry->readable == 1 && entry->type == 0) {
				gtk_clist_set_pixmap(imglist,lcount,0,pixmap1,mask1);	
			} else {
				gtk_clist_set_pixmap(imglist,lcount,0,pixmap3,mask3);	
			}
			lcount++;
			sizecount+=(gint)((off_t)entry->size >> 10);
			count++;
		}

		/* valid/invalid wav-file */
		if (entry->type == 1 || entry->type == 2) {
			convert_frames2minstring((gint)((off_t)entry->size/CDDAFRAME), tmp2);
			g_snprintf(tmp,MAXLINE,"%2d. %s [%s]",
				count, fname, tmp2);
			data[1] = tmp;
			gtk_clist_append(imglist,data);
			if (entry->readable == 1 && entry->type == 1) {
				gtk_clist_set_pixmap(imglist,lcount,0,pixmap2,mask2);	
			} else {
				gtk_clist_set_pixmap(imglist,lcount,0,pixmap4,mask4);	
			}
			lcount++;
			sizecount+=(gint)((off_t)entry->size >> 10);
			count++;
		}	

		/* toc-file */
		if (entry->type == 4) {
			g_snprintf(tmp,MAXLINE,"--. %s",fname);
			data[1] = tmp;
			gtk_clist_append(imglist,data);
			gtk_clist_set_pixmap(imglist,lcount,0,pixmap5, mask5);
			lcount++;
		}

		/* cd-text */
		if (entry->title && entry->artist && 
		    strcmp(entry->title,"") && strcmp(entry->artist,"")) {
			g_snprintf(tmp,MAXLINE,"     (%s / %s)",
				entry->title, entry->artist);
			data[1] = tmp;
			gtk_clist_append(imglist,data);
			set_clist_row_font(imglist,lcount, SLANTFONT);
			lcount++;	
		} else 
		if (entry->title && strcmp(entry->title,"")) {
			g_snprintf(tmp,MAXLINE,"     (%s)",
				entry->title);
			data[1] = tmp;
			gtk_clist_append(imglist,data);
			set_clist_row_font(imglist,lcount, SLANTFONT);
			lcount++;	
		} else 
		if (entry->cddb_ttitle && strcmp(entry->cddb_ttitle,"")) {
			g_snprintf(tmp,MAXLINE,"     (%s)",
				entry->cddb_ttitle);
			data[1] = tmp;
			gtk_clist_append(imglist,data);
			set_clist_row_font(imglist,lcount, SLANTFONT);
			lcount++;	
		} else 
		if (entry->volname && strcmp(entry->volname,"")) {
			if (entry->next_session_start > 0) {
				g_snprintf(tmp,MAXLINE,
					"     (%s / ISO9660-multisession)",
					entry->volname);
			} else {
				g_snprintf(tmp,MAXLINE,"     (%s / ISO9660)",
					entry->volname);
			}
			data[1] = tmp;
			gtk_clist_append(imglist,data);
			set_clist_row_font(imglist,lcount, SLANTFONT);
			lcount++;	
		} else 
		if (entry->type == 0 && entry->next_session_start > 0) {
			data[1] = "     (ISO9660-multisession)"; 
			gtk_clist_append(imglist,data);
			set_clist_row_font(imglist,lcount, SLANTFONT);
			lcount++;	
		}

		loop = loop->next;
	}

	/* total size of files */
	convert_kbytes2mbminstring(sizecount, tmp);
	gtk_entry_set_text(GTK_ENTRY(imglist_l1), tmp);	
}


/* callbacks for button in info-screen */

void cddb_clicked(GtkWidget *widget, gpointer data) {

	/* no cd loaded */
	if (cdinfo.nr_tracks < 0) {
		show_dialog(ICO_WARN,text(266),T_OK,NULL,NULL,0);
		return;
	}

	if (show_cddb_query() == 0) {
		/* new data received - update display */
		fill_cdlist();
	}
}

void edit_cdtext_clicked(GtkWidget *widget, gpointer data) {
gint mode;

	mode = GPOINTER_TO_INT(data);

	if (mode == 0) 
		show_edit_cdtext(mode, NULL);
	else if (mode == 1)
		show_edit_cdtext(mode, write_toc_menu);
	else if (mode == 2) 
		show_edit_cdtext(mode, NULL);
}


void update_clicked(GtkWidget *widget, gpointer data) {
GdkWindowAttr *win_attr;
GdkCursor *cursor,*normal_cursor;

	do_lock(1);
	/* change cursor to watch */
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
		(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
	while (gtk_events_pending())
		gtk_main_iteration();

	if (curset.reader_devnr != -1) {
		get_cd_toc_and_volid(curset.reader_devnr);
		fill_cdlist();
	}
	scan_imagedirs();
	fill_imglist();

	/* reset cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);
	do_unlock(1);

}

/* the update-button in the read menu */

void update_readvrfy_clicked(GtkWidget *widget, gpointer read) {
GdkWindowAttr *win_attr;
GdkCursor *cursor,*normal_cursor;
gint isread;

	isread = GPOINTER_TO_INT(read);

	do_lock(1);
	/* change cursor to watch */
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
		(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
	while (gtk_events_pending())
		gtk_main_iteration();

	if (curset.reader_devnr != -1) {
		get_cd_toc_and_volid(curset.reader_devnr);
	}
	if (isread) {
		fill_read_menu();
	} else {
		fill_verify_menu();
	}
	/* reset cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);
	do_unlock(1);
}


void eject_clicked(GtkWidget *widget, gpointer load) {
GdkWindowAttr *win_attr;
GdkCursor *cursor,*normal_cursor;

	do_lock(1);
	/* change cursor to watch */
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
		(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
	while (gtk_events_pending())
		gtk_main_iteration();

	if (curset.reader_devnr != -1) {
		if (GPOINTER_TO_INT(load)) 
			load_cd(curset.reader_devnr);
		else
			eject_cd(curset.reader_devnr);
	}

	/* reset cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* after we ejected or loaded automatically update screen */

	/* in which menu are we right now? */
	/* info menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[0])) == 1) {
		update_clicked(widget,0);
	}
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[0])) == 1) {
		update_clicked(widget,0);
	}
	do_unlock(1);
}


/* callbacks for devices_setup_read */

void readdev_selected(GtkWidget *item, gpointer devnr) {
GdkWindowAttr *win_attr;
GdkCursor *cursor,*normal_cursor;

	do_lock(1);
	/* change cursor to watch */
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
		(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
	while (gtk_events_pending())
		gtk_main_iteration();

	curset.reader_devnr = GPOINTER_TO_INT(devnr);
	if (curset.reader_devnr != -1) {
		get_cd_toc_and_volid(curset.reader_devnr);
	}

	/* in which menu are we right now? */
	/* info menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[0])) == 1) {
		fill_cdlist();
	}
	/* info menu 2? */
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[0])) == 1) {
		fill_cdlist();
	}
	/* read menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[1])) == 1) {
		fill_read_menu();
	}
	/* read menu 2? */
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[1])) == 1) {
		fill_read_tracks(0);
	}
	/* verify menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[2])) == 1) {
		fill_verify_menu();
	}
	/* verify menu2? */
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[2])) == 1) {
		fill_verify_tracks(1);
	}
	/* write menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[4])) == 1) {
		fill_write_menu();
	}
	/* write menu2? */
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[5])) == 1) {
		fill_write_tracks();
	}

	/* reset cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);
	do_unlock(1);
}


void readdev_speed(GtkWidget *item, GtkSpinButton *spin) {

	curset.audioread_speed = gtk_spin_button_get_value_as_int(spin);
}


/* draw the device-setup-read line */

void devices_setup_read(gint row, GtkWidget *tbl, gint showspeed) {
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *l1;
GtkWidget *eject_btn, *eject_xpm;
GtkWidget *load_btn, *load_xpm;
GdkPixmap *pmap;
GdkBitmap *mask;
GtkStyle *style;
gchar tmp[MAXLINE];
GtkWidget *speed1;
GtkObject *adj;
gint menuidx, menuhistory;

	/* no reader so far selected? set default primary reader */
	if (curset.reader_devnr == -1) {
		curset.reader_devnr = setupdata.readdev1_devnr;
	}	
	if (curset.audioread_speed == -1) {
		curset.audioread_speed = setupdata.audioread_speed;
	}

	/* read device */
	l1 = rightjust_gtk_label_new(text(133));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4*4,row,row+1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();
	menuidx = 0; menuhistory = -1;

	if (setupdata.readdev1_devnr != -1) {
		if (convert_devnr2devstring(setupdata.readdev1_devnr,tmp) == 0) {
			menu_item = gtk_menu_item_new_with_label(tmp);
			gtk_signal_connect(GTK_OBJECT(menu_item),
				"activate", GTK_SIGNAL_FUNC(readdev_selected),
				GINT_TO_POINTER(setupdata.readdev1_devnr));
			gtk_menu_append (GTK_MENU (menu), menu_item);
			if (curset.reader_devnr == setupdata.readdev1_devnr) {
				 menuhistory = menuidx;
			}
			menuidx++;
			gtk_widget_show (menu_item);
		}
	}
	if (setupdata.readdev2_devnr != -1 && 
	    setupdata.readdev2_devnr != setupdata.readdev1_devnr) {
		if (convert_devnr2devstring(setupdata.readdev2_devnr,tmp) == 0) {
			menu_item = gtk_menu_item_new_with_label(tmp);
			gtk_signal_connect(GTK_OBJECT(menu_item),
				"activate", GTK_SIGNAL_FUNC(readdev_selected),
				GINT_TO_POINTER(setupdata.readdev2_devnr));
			gtk_menu_append (GTK_MENU (menu), menu_item);
			if (curset.reader_devnr == setupdata.readdev2_devnr) {
				 menuhistory = menuidx;
			}
			menuidx++;
			gtk_widget_show (menu_item);
		}
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), menuhistory);
	} else {
		/* if we are here we have an invalid reader setting */
		/* set to default */
		curset.reader_devnr = setupdata.readdev1_devnr;
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), 0);
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,4*4,12*4,row,row+1);
	gtk_widget_show(omenu);
	define_tooltip(omenu, help(42));

	if (showspeed) { 
		l1 = rightjust_gtk_label_new(text(136));
		gtk_table_attach_defaults(GTK_TABLE(tbl),l1,12*4,15*4-1,row,row+1);
		gtk_widget_show(l1);

		adj = gtk_adjustment_new(0.0,0.0,64.0,1.0,1.0,1.0);
		speed1 = gtk_spin_button_new(GTK_ADJUSTMENT(adj),0,0);
		gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			GTK_SIGNAL_FUNC (readdev_speed),GINT_TO_POINTER(speed1));
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(speed1),1);
		gtk_table_attach_defaults(GTK_TABLE(tbl),speed1,15*4-1,16*4,row,row+1);
		if (curset.audioread_speed != -1) {
			gtk_spin_button_set_value(GTK_SPIN_BUTTON(speed1),
				(gfloat)curset.audioread_speed);
		}

		gtk_widget_show(speed1);
		define_tooltip(speed1, help(43));

        	if (!isroot() && !setupdata.root_option_change_readparam) {
                	gtk_widget_set_sensitive(speed1,FALSE);
		}
	} else {
		/* if not showing speed, show eject/load buttons */
		gtk_widget_realize(tbl);
		style = gtk_widget_get_style(tbl);

		pmap = gdk_pixmap_create_from_xpm_d(tbl->window, &mask,
			&style->bg[GTK_STATE_NORMAL], (gchar **) disc_eject);
		eject_xpm = gtk_pixmap_new(pmap,mask);
		eject_btn = gtk_button_new();
		gtk_signal_connect (GTK_OBJECT (eject_btn), "clicked",
			GTK_SIGNAL_FUNC (eject_clicked), GINT_TO_POINTER(0));
		gtk_table_attach_defaults(GTK_TABLE(tbl),eject_btn,
			14*4,15*4,row,row+1);
		gtk_widget_show(eject_btn);
		gtk_container_add(GTK_CONTAINER(eject_btn), eject_xpm);
		gtk_widget_show(eject_xpm);
		define_tooltip(eject_btn, help(78));

		pmap = gdk_pixmap_create_from_xpm_d(tbl->window, &mask,
			&style->bg[GTK_STATE_NORMAL], (gchar **) disc_load);
		load_xpm = gtk_pixmap_new(pmap,mask);
		load_btn = gtk_button_new();
		gtk_signal_connect (GTK_OBJECT (load_btn), "clicked",
			GTK_SIGNAL_FUNC (eject_clicked), GINT_TO_POINTER(1));
		gtk_table_attach_defaults(GTK_TABLE(tbl),load_btn,
			15*4,16*4,row,row+1);
		gtk_widget_show(load_btn);
		gtk_container_add(GTK_CONTAINER(load_btn), load_xpm);
		gtk_widget_show(load_xpm);
		define_tooltip(load_btn, help(79));
	}
}


void imagedir_selected(GtkWidget *item, gpointer val) {
GdkWindowAttr *win_attr;
GdkCursor *cursor,*normal_cursor;

	do_lock(1);
	/* change cursor to watch */
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
		(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
	while (gtk_events_pending())
		gtk_main_iteration();

	curset.image_index = GPOINTER_TO_INT(val);

	/* which sub-menu are we in? */
	/* read menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[1])) == 1) {
		fill_read_menu();
	}
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[1])) == 1) {
		fill_read_tracks(1);
	}
	/* verify menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[2])) == 1) {
		fill_verify_menu();
	}
	/* verify menu2? */
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[2])) == 1) {
		fill_verify_tracks(0);
	}
	/* write menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[4])) == 1) {
		fill_write_menu();
	}
	/* write menu2? */
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[5])) == 1) {
		fill_write_tracks();
	}
	/* delete menu? */
	if (submenu == 1 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets[5])) == 1) {
		fill_delete_menu();
	}
	/* delete menu2? */
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[6])) == 1) {
		fill_delete_menu();
	}
	/* master menu */
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[4])) == 1) {
		fill_master_write_menu();
	}
	/* reset cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);
	do_unlock(1);
}


/* draw the device-setup-image line */

void devices_setup_image(gint row, GtkWidget *tbl) {
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *l1;
GList *loop;
gchar tmp[MAXLINE];
gint i, menuidx, menuhistory;

	/* default curset.image_index is -1...so we are fine here */

	/* image directory */
	l1 = rightjust_gtk_label_new(text(134));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4*4,row,row+1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();

	/* automatic setting */
	menuidx = 0; menuhistory = -1;
	menu_item = gtk_menu_item_new_with_label(text(137));
	gtk_signal_connect(GTK_OBJECT(menu_item),
		"activate", GTK_SIGNAL_FUNC(imagedir_selected),
		GINT_TO_POINTER(-1));
	gtk_menu_append (GTK_MENU (menu), menu_item);
	if (curset.image_index == -1) { menuhistory = menuidx; }
	menuidx++;
	gtk_widget_show (menu_item);

	/* add image dirs */
	i = 0;
	loop = g_list_first(setupdata.image_dirs);
	while(loop) {
		strcpy(tmp,(gchar *)loop->data);

		menu_item = gtk_menu_item_new_with_label(tmp);
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(imagedir_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		if (curset.image_index == i) { menuhistory = menuidx; }
		menuidx++;
		gtk_widget_show (menu_item);

		loop = loop->next;
		i++;
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		/* looks we got an invalid setting...set to default */
		curset.image_index = -1;
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),0);

	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,4*4,12*4,row,row+1);
	gtk_widget_show(omenu);
	define_tooltip(omenu, help(44));
}


/* callbacks for devices_setup_write */

void writedev_selected(GtkWidget *item, GtkWidget *omenu) {
GdkWindowAttr *win_attr;
GdkCursor *cursor,*normal_cursor;

	/* this has no function yet, exept causing an eject on the
	   write device */

	do_lock(1);
	/* change cursor to watch */
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
		(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
	while (gtk_events_pending())
		gtk_main_iteration();

	eject_cd(curset.writer_devnr);

	/* now set the writer-device back to it real setting 
	   (erasing the "Eject text") */
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu), 0);
	
	/* reset cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);
	do_unlock(1);
}


void writedev_speed(GtkWidget *item, GtkSpinButton *spin) {

        curset.writer_speed = gtk_spin_button_get_value_as_int(spin);
}


/* draw the device-setup-write line */

void devices_setup_write(gint row, GtkWidget *tbl) {
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *l1;
GtkWidget *speed1;
GtkObject *adj;
gchar tmp[MAXLINE];

	/* we must have a writer defined here...so just set */
	curset.writer_devnr = setupdata.writer_devnr;
	if (curset.writer_speed == -1) {
		curset.writer_speed = setupdata.writer_speed;
	}
	
	/* write device */
	l1 = rightjust_gtk_label_new(text(135));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,4*4,row,row+1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new ();
	menu = gtk_menu_new();
	if (convert_devnr2devstring(setupdata.writer_devnr,tmp) == 0) {
		menu_item = gtk_menu_item_new_with_label(tmp);
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);

		/* now add eject option here */
		menu_item = gtk_menu_item_new_with_label(text(291));
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(writedev_selected),
			omenu);	
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,4*4,12*4,row,row+1);
	gtk_widget_show(omenu);
	define_tooltip(omenu, help(45));

	l1 = rightjust_gtk_label_new(text(136));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,12*4,15*4-1,row,row+1);
	gtk_widget_show(l1);

	adj = gtk_adjustment_new(0.0,0.0,64.0,1.0,1.0,1.0);
	speed1 = gtk_spin_button_new(GTK_ADJUSTMENT(adj),0,0);
	gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
		GTK_SIGNAL_FUNC (writedev_speed),GINT_TO_POINTER(speed1));
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(speed1),1);
	gtk_table_attach_defaults(GTK_TABLE(tbl),speed1,15*4-1,16*4,row,row+1);
	if (curset.writer_speed != -1) {
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(speed1),
			(gfloat)curset.writer_speed);
	}
	gtk_widget_show(speed1);
	define_tooltip(speed1, help(46));

       	if (!isroot() && !setupdata.root_option_change_writeparam) {
               	gtk_widget_set_sensitive(speed1,FALSE);
	}
}


/* function to remove all selections on a clist */
void undo_selections(GtkWidget *clist, gint row, gint column,
	GdkEventButton *event, gpointer data) {

	gtk_clist_unselect_all(GTK_CLIST(clist));
}


/* draw the cd-info-menu */

void draw_info_menu() {
GtkWidget *hbox, *vbox;
GtkWidget *f1,*f2;
GtkWidget *b1, *b_update;
GtkWidget *e1;
GtkWidget *l1;
GtkWidget *tbl;
GtkWidget *cd_list, *img_list;
gchar *titles[2];
GtkWidget *scrolled_win;

	/* prepare draw area */
	clear_actionspace();

	f1 = gtk_frame_new(text(107));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
	gtk_widget_show(f1);

	tbl = gtk_table_new(1,16*4,TRUE);	
	gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-1,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	devices_setup_read(0, tbl, 0);

	/* left and right info-frames */
	tbl = gtk_table_new(1,2,TRUE);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(actionspace),tbl,TRUE,TRUE,10);
	gtk_widget_show(tbl);
	f1 = gtk_frame_new(text(96));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
	gtk_widget_show(f1);
	f2 = gtk_frame_new(text(97));
	set_font_and_color(f2,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
	gtk_widget_show(f2);

	/* button bar at the bottom */
	hbox = gtk_hbox_new(TRUE,10);
	gtk_box_pack_start(GTK_BOX(actionspace),hbox,FALSE,TRUE,10);
	gtk_widget_show(hbox);
	b1 = gtk_button_new_with_label(text(98));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(cddb_clicked), NULL);
	define_tooltip(b1,help(47));

	b1 = gtk_button_new_with_label(text(472));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(edit_cdtext_clicked), GINT_TO_POINTER(0));
	define_tooltip(b1,help(186));

/*
	b1 = gtk_button_new_with_label(text(99));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(eject_clicked), NULL);
	define_tooltip(b1,help(48));
*/

	b_update = gtk_button_new_with_label(text(100));
	gtk_box_pack_start(GTK_BOX(hbox),b_update,TRUE,TRUE,10);
	gtk_widget_show(b_update);
	gtk_signal_connect(GTK_OBJECT(b_update), "clicked",
		GTK_SIGNAL_FUNC(update_clicked), NULL);
	define_tooltip(b_update,help(49));

	/* left info frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f1),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
	gtk_widget_show(vbox);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);
	
	titles[0] = g_strdup("");
	titles[1] = text(101);
	cd_list = gtk_clist_new_with_titles(2,titles);
	gtk_signal_connect(GTK_OBJECT(cd_list), "select_row",
		GTK_SIGNAL_FUNC(undo_selections), NULL);
	gtk_container_add (GTK_CONTAINER (scrolled_win), cd_list);
	cdlist = GTK_CLIST(cd_list);
	gtk_clist_set_column_width(cdlist, 0, 16);
	gtk_clist_set_column_auto_resize(cdlist, 1, TRUE);
	gtk_widget_show(cd_list);

	tbl = gtk_table_new(3,8,TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(103));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l1 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(104));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,1,2);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(105));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,2,3);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l3 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,2,3);
	gtk_widget_show(e1);


	/* right info frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f2),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
	gtk_widget_show(vbox);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_win,TRUE,TRUE,0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);
	
	titles[0] = g_strdup("");
	titles[1] = text(102);
	img_list = gtk_clist_new_with_titles(2,titles);
	gtk_signal_connect(GTK_OBJECT(img_list), "select_row",
		GTK_SIGNAL_FUNC(undo_selections), NULL);
	gtk_container_add (GTK_CONTAINER (scrolled_win), img_list);
	imglist = GTK_CLIST(img_list);
	gtk_clist_set_column_width(imglist, 0, 16);
	gtk_clist_set_column_auto_resize(imglist, 1, TRUE);
	gtk_widget_show(img_list);

	tbl = gtk_table_new(1,8,TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(106));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	imglist_l1 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,0,1);
	gtk_widget_show(e1);

	gtk_widget_show(actionspace);

	while (gtk_events_pending())
		gtk_main_iteration();

	/* now update screen */
	gtk_button_clicked(GTK_BUTTON(b_update));
}


/* calculate the space that would be recycled on the harddrive
   when reading tracks and overwriting the ones with same names.
   This is used to show the user what space really is free 
   dependant of the name he chooses for his files */

gint get_free_space_by_overwriting_trackfiles(gint *biggest) {
track_read_param_t *trackparam;
gfloat per;
gint i;
gint overwrite;
gint overwritebiggest;

	/* cd loaded? */
	if (cdinfo.nr_tracks < 0) {
		/* no cd in drive - no files to read */
		*biggest = 0;
		return 0;
	}

	/* free structure first */
	clear_trackreadset();

	/* fill structure */
	trackreadset.nrtracks = cdinfo.nr_tracks;

	for(i=0; i<cdinfo.nr_tracks; i++) {

		/* allocate memory */
		trackparam = g_new0(track_read_param_t,1);

		trackparam->trackinfo_index = i;
		trackparam->starttrack = trackinfo[i]->track_nr;
		trackparam->endtrack = 0;
		trackparam->tracktype = trackinfo[i]->type;
		per = (gfloat)trackinfo[i]->size * 100.0  / cdinfo.total_size;
		trackparam->percent = per;
		
		if (trackparam->tracktype == 0) {
			/* data track */
			trackparam->kbyte = trackinfo[i]->size *
				(DATASECTORSIZE/1024);
			trackparam->frames = trackinfo[i]->size;
			trackparam->startoffset = trackinfo[i]->start_sec;
			if (i == cdinfo.nr_tracks-1) {
				/* last track - leadout is track-end */
				trackparam->endoffset = cdinfo.leadout - 2; 	
			} else {
				/* sub 150 (2 sec leadout),
				   sub 2 (2 run out sectors) */
				trackparam->endoffset = 
					trackinfo[i+1]->start_sec -150-2; 	
			}
		} else {
			/* audio */
			trackparam->kbyte = trackinfo[i]->size *
				CDDAFRAME/1024;
			trackparam->frames = trackinfo[i]->size;
		}

		trackreadset.trackparams = g_list_append(
			trackreadset.trackparams, trackparam);
	}

	/* assign diskspace */
	allocate_track_filenames(&overwrite, &overwritebiggest); 

	*biggest = overwritebiggest;
	return overwrite;
}


/* callbacks for button in read-screen */

void readalltracks_clicked(GtkWidget *widget, gpointer data) {
gchar path[MAXLINE];
gchar tmp[MAXLINE];
track_read_param_t *trackparam;
gfloat per;
gint i, ret, tocindex, sectorstoread;
gint overwrite, overwritebiggest, stat;

	/* no cd-reader defined */
	if (curset.reader_devnr == -1) {
		show_dialog(ICO_ERROR,text(203), T_OK, NULL, NULL, 0);
		return;
	}

	/* now check if our cd-information is still valid */
	get_cd_toc_and_volid(curset.reader_devnr);

	/* cd loaded? */
	if (cdinfo.nr_tracks < 0) {
		/* update screen ... */
		fill_read_menu();
		show_dialog(ICO_WARN,text(266),T_OK,NULL,NULL,0);
		return;
	}

	/* now check for cd-extra because we dont handle this 
	   currently */
	if (determine_cd_type(tmp,0) == 3) {
		show_dialog(ICO_INFO,text(286),T_OK,NULL,NULL,0);
		return;
	}
	
	/* ok, the user wants to read all tracks */
	/* lets check if the file-prefix-entry is up to date */
	set_image_prefix_callback(imglist_l1, NULL); 

	/* free structure first */
	clear_trackreadset();

	/* fill structure */
	trackreadset.nrtracks = cdinfo.nr_tracks;

	for(i=0; i<cdinfo.nr_tracks; i++) {

		/* allocate memory */
		trackparam = g_new0(track_read_param_t,1);

		trackparam->trackinfo_index = i;
		trackparam->starttrack = trackinfo[i]->track_nr;
		trackparam->endtrack = 0;
		trackparam->tracktype = trackinfo[i]->type;
		per = (gfloat)trackinfo[i]->size * 100.0  / cdinfo.total_size;
		trackparam->percent = per;
		
		if (trackparam->tracktype == 0) {
			/* data track */
			trackparam->kbyte = trackinfo[i]->size *
				(DATASECTORSIZE/1024);
			trackparam->frames = trackinfo[i]->size;
			trackparam->startoffset = trackinfo[i]->start_sec;
			if (i == cdinfo.nr_tracks-1) {
				/* last track - leadout is track-end */
				trackparam->endoffset = cdinfo.leadout - 2; 	
			} else {
				/* sub 150 (2 sec leadout),
				   sub 2 (2 run out sectors) */
				trackparam->endoffset = 
					trackinfo[i+1]->start_sec -150-2; 	
			}
			/* now do a paranoia check */
			/* in some cases we skip to much of a track */
			sectorstoread = trackparam->endoffset - 
				trackparam->startoffset;
			if (sectorstoread < trackinfo[i]->isosize) {
				trackparam->endoffset =
					trackparam->startoffset + 
						trackinfo[i]->isosize;
				trackparam->kbyte = trackinfo[i]->isosize * 2;
				dodebug(1,"readalltracks_clicked: corrected data track size from %d to %d sectors.\n", sectorstoread, trackinfo[i]->isosize);
			}
		} else {
			/* audio */
			trackparam->kbyte = trackinfo[i]->size *
				CDDAFRAME/1024;
			trackparam->frames = trackinfo[i]->size;
		}

		trackreadset.trackparams = g_list_append(
			trackreadset.trackparams, trackparam);
	}

	/* assign diskspace */
	stat = allocate_track_filenames(&overwrite, &overwritebiggest);

	if (stat == 1) {
		/* not enough space */
		ret = show_dialog(ICO_WARN,text(299), T_ANYWAY, T_CANCEL, NULL, 1);
		if (ret == 1) {
			/* abort */
			return;
		}
	}

        /* no writeable dirs */
        if (stat == 2) {
		show_dialog(ICO_WARN,text(450), T_OK, NULL, NULL, 1);
                return;
        }
	
	/* assign now a toc-file name */
	if (curset.image_index == -1) {
		tocindex = 0;
	} else {
		tocindex = curset.image_index;
	}
	strncpy(path,(gchar *)g_list_nth_data(setupdata.image_dirs,
		tocindex), MAXLINE);
	g_snprintf(tmp,MAXLINE,"%s/%s.toc",path,curset.file_prefix);
	g_free(trackreadset.tocfile);
	trackreadset.tocfile = g_strdup(tmp);

	/* now all parameters for reading are set - lets begin */
	show_and_do_read_tracks(curset.reader_devnr, 1);
}


/* fill the entries in the read_cd_menu */

void fill_read_menu() {
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar tmp3[MAXLINE];
gint overwritefree, normalfree, biggestfree, overwritefreebiggest;

	/* file prefix */
	if (strcmp(curset.file_prefix,"") == 0) {
		g_free(curset.file_prefix);
		curset.file_prefix = g_strdup(IMGFILEPREFIX);
	}
	gtk_entry_set_text(GTK_ENTRY(imglist_l1), curset.file_prefix);
	gtk_entry_set_position(GTK_ENTRY(imglist_l1), 0);
	gtk_entry_select_region(GTK_ENTRY(imglist_l1), 0, 
		GTK_ENTRY(imglist_l1)->text_length);

	/* now check if the current filename has any influence on
	   the available space */
	overwritefree = 
		get_free_space_by_overwriting_trackfiles(&overwritefreebiggest);

	/* free size */
	normalfree = determine_free_space(&biggestfree);
	convert_kbytes2mbminstring(normalfree,tmp3);

	/* additional free space when overwriting files? */
	if (cdinfo.nr_tracks > 0 && overwritefree > 0) {
		convert_kbytes2mbstring(normalfree+overwritefree, tmp2);
		g_snprintf(tmp,MAXLINE,"%s (%s)", tmp3, tmp2);
	} else {
		strcpy(tmp,tmp3);
	}
	gtk_entry_set_text(GTK_ENTRY(imglist_l2), tmp);
	gtk_entry_set_position(GTK_ENTRY(imglist_l2), 0);

	/* biggest free block */
	convert_kbytes2mbminstring(biggestfree,tmp3);

	if (cdinfo.nr_tracks > 0 && overwritefreebiggest > 0) {
		convert_kbytes2mbstring(biggestfree+overwritefreebiggest, tmp2);
		g_snprintf(tmp,MAXLINE,"%s (%s)", tmp3, tmp2);
	} else {
		strcpy(tmp,tmp3);
	}
	gtk_entry_set_text(GTK_ENTRY(imglist_l3), tmp);
	gtk_entry_set_position(GTK_ENTRY(imglist_l3), 0);


	/* cd loaded? */
	if (cdinfo.nr_tracks == -1) {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l1), text(156));    
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l3),"");	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l4),"");	
		return;
        }
	if (cdinfo.nr_tracks == -2) {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l1), text(196));    
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l3),"");	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l4),"");	
		return;
        }

	/* cd-type */
	determine_cd_type(tmp,0);
	gtk_entry_set_text(GTK_ENTRY(cdlist_l1), tmp); 

	/* cd-label */
	if (cdinfo.title && cdinfo.artist && 
		cdinfo.title[0] != '\0' && setupdata.option_displaycdtext) {
		g_snprintf(tmp,MAXLINE,"%s / %s", cdinfo.title, cdinfo.artist);
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2), tmp);
		gtk_entry_set_position(GTK_ENTRY(cdlist_l2),0);
	} else 
	if (cdinfo.cddb_dtitle != NULL) {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2), cdinfo.cddb_dtitle);   
		gtk_entry_set_position(GTK_ENTRY(cdlist_l2),0);
	} else {
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");    
	}

	/* cd-size */
	convert_frames2mbminstring(cdinfo.total_size, tmp);
	gtk_entry_set_text(GTK_ENTRY(cdlist_l3), tmp);

	/* nr tracks */	
	g_snprintf(tmp,MAXLINE,"%d",cdinfo.nr_tracks);
	gtk_entry_set_text(GTK_ENTRY(cdlist_l4), tmp);
}


void set_image_prefix_callback(GtkWidget *widget, gpointer data) {
gchar tmp[MAXLINE];

	g_free(curset.file_prefix);
	strcpy(tmp,gtk_entry_get_text(GTK_ENTRY(widget)));
	/* now check for illegal chars */
	if (remove_illegal_chars(tmp) == 1) {
		gtk_entry_set_text(GTK_ENTRY(widget), tmp);
		show_dialog(ICO_WARN,text(265),T_OK,NULL,NULL, 0);
	}
	curset.file_prefix = g_strdup(tmp);

	/* empty-file? */
	if (strcmp(curset.file_prefix,"") == 0) {
		g_free(curset.file_prefix);
		curset.file_prefix = g_strdup(IMGFILEPREFIX);
		gtk_entry_set_text(GTK_ENTRY(widget), curset.file_prefix);
	}
	gtk_entry_select_region(GTK_ENTRY(widget), 0,
		GTK_ENTRY(widget)->text_length);

	/* update free overwrite size */
	if (submenu == 1) {
		fill_read_menu();
	}

	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[1])) == 1) {
		fill_read_tracks(1);
	}
	if (submenu == 2 && gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(side_widgets2[4])) == 1) {
		fill_master_write_menu();
	}

}

void readoptions_selected(GtkWidget *item, gpointer nr) {
gint sel;

	sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	switch(GPOINTER_TO_INT(nr)) {
		case 0:
			curset.indexscan = sel;
			break;
	}
}


/* draw the read-menu */

void draw_read_menu() {
GtkWidget *hbox, *vbox;
GtkWidget *f1,*f2, *f3;
GtkWidget *b1, *b_update;
GtkWidget *e1;
GtkWidget *l1;
GtkWidget *tbl, *check;

	/* prepare draw area */
	clear_actionspace();

	f1 = gtk_frame_new(text(107));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
	gtk_widget_show(f1);

	tbl = gtk_table_new(2,16*4,TRUE);	
	gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-2 ,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	devices_setup_read(0, tbl, 1);
	devices_setup_image(1, tbl);
	/* devices_setup_write(2, tbl); */

	/* left and right info-frames */
	tbl = gtk_table_new(1,2,TRUE);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(actionspace),tbl,TRUE,TRUE,10);
	gtk_widget_show(tbl);
	vbox = gtk_vbox_new(FALSE,10);
	gtk_table_attach_defaults(GTK_TABLE(tbl),vbox,0,1,0,1);
	f1 = gtk_frame_new(text(96));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);
	f3 = gtk_frame_new(text(296));
	set_font_and_color(f3,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f3,FALSE,FALSE,0);
	gtk_widget_show(f3);
	f2 = gtk_frame_new(text(97));
	set_font_and_color(f2,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
	gtk_widget_show(f2);
	gtk_widget_show(vbox);

	/* button bar at the bottom */
	hbox = gtk_hbox_new(TRUE,10);
	gtk_box_pack_start(GTK_BOX(actionspace),hbox,FALSE,TRUE,10);
	gtk_widget_show(hbox);
	b1 = gtk_button_new_with_label(text(148));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(readalltracks_clicked), NULL);
	define_tooltip(b1, help(50));

	b_update = gtk_button_new_with_label(text(100));
	gtk_box_pack_start(GTK_BOX(hbox),b_update,TRUE,TRUE,10);
	gtk_widget_show(b_update);
	gtk_signal_connect(GTK_OBJECT(b_update), "clicked",
		GTK_SIGNAL_FUNC(update_readvrfy_clicked), GINT_TO_POINTER(1));
	define_tooltip(b_update,help(49));

	/*
	b1 = gtk_button_new_with_label(text(149));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(eject_clicked), NULL);
	*/

	/* left info frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f1),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
	gtk_widget_show(vbox);

	tbl = gtk_table_new(4,8,TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(103));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l1 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(104));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,1,2);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(105));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,2,3);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l3 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,2,3);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(145));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,3,4);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l4 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,3,4);
	gtk_widget_show(e1);

	/* options frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f3),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
	gtk_widget_show(vbox);

	tbl = gtk_table_new(1,8,TRUE);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
	gtk_widget_show(tbl);

	check = gtk_check_button_new_with_label(text(297));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(readoptions_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,8,0,1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
                curset.indexscan);
	define_tooltip(check, help(80));
	gtk_widget_show(check);


	/* right info frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f2),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
	gtk_widget_show(vbox);

	tbl = gtk_table_new(4,8,TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(146));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	imglist_l1 = e1;
	gtk_signal_connect(GTK_OBJECT(e1), "activate",
		GTK_SIGNAL_FUNC(set_image_prefix_callback),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,0,1);
	gtk_widget_show(e1);
	define_tooltip(e1, help(51));

	l1 = rightjust_gtk_label_new(text(147));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	imglist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,1,2);
	gtk_widget_show(e1);

	l1 = leftjust_gtk_label_new(text(272));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,8,2,3);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	imglist_l3 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,3,4);
	gtk_widget_show(e1);

	gtk_widget_show(actionspace);

	/* fill entries */
	fill_read_menu();
}


/* fill the entries in the verify_cd_menu */

void fill_verify_menu() {
gchar tmp[MAXLINE];
GList *loop;
GtkWidget *menu;
GtkWidget *menu_item, *menuselitem;
gint menuidx, menuhistory;
gint i,len;

	/* get list of toc-files (save in tocfiles var) */
	scan_for_toc_files();

	/* clear out the old menu first (if any) */
	gtk_option_menu_remove_menu(GTK_OPTION_MENU (write_toc_menu));

	menu = gtk_menu_new();
	menuselitem = NULL;
	menu_item = NULL;
	menuidx = 0; menuhistory = 0;
	i = 0;
	loop = g_list_first(tocfiles);	
	while (loop) {
		/* a bug in gtk wont allow longer option-menus...
		   well, then strip the strings down (not nice, but 
		   so far the only way I can think of */
		len = strlen((gchar *)loop->data);
		if (len > 24) {
			strcpy(tmp, ".. ");
			strcat(tmp, (gchar *)loop->data + len - 24);
		} else {
			strcpy(tmp, (gchar *)loop->data);
		}
		menu_item = gtk_menu_item_new_with_label(tmp);
		if (menuselitem == NULL) {
			/* default first element */
			menuselitem = menu_item;
		} 
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(tocwrite_selected),
			GINT_TO_POINTER(i));
		if (strcmp(curset.tocfile, (gchar *)loop->data) == 0) {
			menuhistory = menuidx;
			menuselitem = menu_item;
		}
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);
		loop = loop->next;
		menuidx++;
		i++;
	}

	/* no toc file found? */
	if (i == 0) {
	
		menu_item = gtk_menu_item_new_with_label(text(235));
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(tocwrite_selected),
			GINT_TO_POINTER(-2));
		if (strcmp(curset.tocfile, "-") == 0) {
			menuhistory = menuidx;
			menuselitem = menu_item;
		}
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (write_toc_menu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (write_toc_menu),menuhistory);
	/* toggle currently active menu */ 
	if (menuselitem != NULL) {
		gtk_menu_item_activate(GTK_MENU_ITEM (menuselitem));
	} else {
		/* if no active menu, activate the last set */
		/* (one the fly in this case) */
		gtk_menu_item_activate(GTK_MENU_ITEM (menu_item));
	}	


	/* ---------------- */

	/* cd loaded? */
	if (cdinfo.nr_tracks == -1) {
		gtk_entry_set_text(GTK_ENTRY(vrylist_l1), text(156));    
		gtk_entry_set_text(GTK_ENTRY(vrylist_l2),"");	
		gtk_entry_set_text(GTK_ENTRY(vrylist_l3),"");	
		gtk_entry_set_text(GTK_ENTRY(vrylist_l4),"");	
		return;
        }
	if (cdinfo.nr_tracks == -2) {
		gtk_entry_set_text(GTK_ENTRY(vrylist_l1), text(196));    
		gtk_entry_set_text(GTK_ENTRY(vrylist_l2),"");	
		gtk_entry_set_text(GTK_ENTRY(vrylist_l3),"");	
		gtk_entry_set_text(GTK_ENTRY(vrylist_l4),"");	
		return;
        }

	/* cd-type */
	determine_cd_type(tmp,0);
	gtk_entry_set_text(GTK_ENTRY(vrylist_l1), tmp); 

	/* cd-label */
	if (cdinfo.title && cdinfo.artist && 
		cdinfo.title[0] != '\0' && setupdata.option_displaycdtext) {
		g_snprintf(tmp,MAXLINE,"%s / %s", cdinfo.title, cdinfo.artist);
		gtk_entry_set_text(GTK_ENTRY(vrylist_l2), tmp);
		gtk_entry_set_position(GTK_ENTRY(vrylist_l2),0);
	} else 
	if (cdinfo.cddb_dtitle != NULL) {
		gtk_entry_set_text(GTK_ENTRY(vrylist_l2), cdinfo.cddb_dtitle);
		gtk_entry_set_position(GTK_ENTRY(vrylist_l2),0);
	} else {
		gtk_entry_set_text(GTK_ENTRY(vrylist_l2),"");    
	}

	/* cd-size */
	convert_frames2mbminstring(cdinfo.total_size, tmp);
	gtk_entry_set_text(GTK_ENTRY(vrylist_l3), tmp);

	/* nr tracks */	
	g_snprintf(tmp,MAXLINE,"%d",cdinfo.nr_tracks);
	gtk_entry_set_text(GTK_ENTRY(vrylist_l4), tmp);

}


/* callbacks for verify-screen */

void verify_clicked(GtkWidget *widget, gpointer data) {
gint stat;
gint ret;
track_read_param_t *trackparam;
GList *loop;
gint i, sectorstoread;
gint datat,audio;
gint datasize;

	/* no cd-reader defined */
	if (curset.reader_devnr == -1) {
		show_dialog(ICO_ERROR,text(203), T_OK, NULL, NULL, 0);
		return;
	}

        /* now check if our cd-information is still valid */
        get_cd_toc_and_volid(curset.reader_devnr);

	/* cd loaded? */
	if (cdinfo.nr_tracks < 0) {
		fill_verify_menu();
		show_dialog(ICO_WARN,text(266),T_OK,NULL,NULL,0);
		return;
	}

	/* no tocfile selected */
	if (strcmp(curset.tocfile,"-") == 0) {
		show_dialog(ICO_WARN,text(237),T_OK,NULL,NULL,0);
		return;
	}
	
	/* first check if all tracks we need are available on hd */
	stat = check_write_files(0);
	switch(stat) {
	/* files with wrong size */
	case 1:
		ret = show_dialog(ICO_QUEST,text(198),T_ANYWAY,T_CANCEL, 
			NULL, 1);
		if (ret == 1) {
			/* aborted */
			return;
		}	
		break;
	/* files missing */
	case 2:
		show_dialog(ICO_ERROR,text(200),T_OK,NULL,NULL,0);
		return;

	/* no permission/invalid */
	case 3:
		show_dialog(ICO_ERROR,text(201),T_OK,NULL,NULL,0);
		return;

	}

	/* now check if we have the correct cd to verify in the drive */
	/* allow an offset of 15 sectors (padding) */
	if (trackreadset.nrtracks != cdinfo.nr_tracks ||
	    (cdinfo.total_size-trackreadset.cdsize) > 15) {

		show_dialog(ICO_WARN,text(238),T_OK,NULL,NULL,0);
		return;
	}


	datat = 0;
	audio = 0;
	datasize = 0;

	/* fill some additional data in the trackreadset-structure */
	loop = g_list_first(trackreadset.trackparams);
	for(i=0; i<cdinfo.nr_tracks; i++) {

		if (loop == NULL) {
			/* should never happen */
			show_dialog(ICO_WARN,text(238),T_OK,NULL,NULL,0);
			return;
		}
		trackparam = loop->data;
		
		trackparam->trackinfo_index = i;

		/* does the tracktypes match? */
		if (trackparam->tracktype != trackinfo[i]->type) {
			show_dialog(ICO_WARN,text(238),T_OK,NULL,NULL,0);
			return;
		}

		if (trackparam->tracktype == 0) {
			/* data track */
			trackparam->kbyte = trackinfo[i]->size *
				(DATASECTORSIZE/1024);
			trackparam->startoffset = trackinfo[i]->start_sec;
			if (i == cdinfo.nr_tracks-1) {
				/* last track - leadout is track-end */
				trackparam->endoffset = cdinfo.leadout - 2;
			} else {
				/* sub 150 (2 sec leadout),
				   sub 2 (2 run out sectors) */
				trackparam->endoffset =
					trackinfo[i+1]->start_sec -150-2;
			}
			/* now do a paranoia check */
			/* in some cases we skip to much of a track */
			sectorstoread = trackparam->endoffset - 
				trackparam->startoffset;
			if (sectorstoread < trackinfo[i]->isosize) {
				trackparam->endoffset =
					trackparam->startoffset + 
						trackinfo[i]->isosize;
				trackparam->kbyte = trackinfo[i]->isosize * 2;
				dodebug(1,"verify_clicked: corrected data track size from %d to %d sectors.\n", sectorstoread, trackinfo[i]->isosize);
			}

			datat++;
			datasize += trackparam->frames;
		} else {
			/* audio */
			trackparam->kbyte = trackinfo[i]->size *
				CDDAFRAME/1024;
			audio++;
		}	
		loop = loop->next;
	}


	/* OK...now we know we have the correct CD in the drive and a fully 
	   functional set of image-files on the HD. All set for verifying */

	/* check if are allowed to verify audio */
	if (curset.noaudioverify == 1 && datat == 0 && audio > 0) {
		show_dialog(ICO_WARN,text(248), T_OK, NULL, NULL, 0);
		return;
	}

	/* do we have to recalc the percentages because we dont want
	   to verify audio? */
	if (curset.noaudioverify == 1 && audio > 0 && datat > 0) {
		loop = g_list_first(trackreadset.trackparams);
		while(loop) {
			trackparam = loop->data;
			/* only take data-tracks in account */
			trackparam->percent = 
				(gfloat)trackparam->frames / datasize;
			loop = loop->next; 
		}
	}

	show_and_do_verify_tracks(curset.reader_devnr);
}


void verifyoptions_selected(GtkWidget *item, gpointer nr) {
gint sel;

	sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	switch(GPOINTER_TO_INT(nr)) {
		case 0:
			curset.noaudioverify = sel;
			break;
		case 1:
			curset.verifyfailabort = sel;
			break;
	}
}


/* draw the verify-info-menu */

void draw_verify_menu() {
GtkWidget *hbox, *vbox;
GtkWidget *f1, *f2, *f3;
GtkWidget *b1, *b_update;
GtkWidget *e1;
GtkWidget *l1;
GtkWidget *tbl, *omenu, *check;

	/* prepare draw area */
	clear_actionspace();

	edit_cdtext_btn = NULL;

	f1 = gtk_frame_new(text(107));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
	gtk_widget_show(f1);

	tbl = gtk_table_new(2,16*4,TRUE);	
	gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-2,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	devices_setup_read(0, tbl, 1);
	devices_setup_image(1, tbl);

	/* left and right info-frames */
	tbl = gtk_table_new(1,2,TRUE);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(actionspace),tbl,TRUE,TRUE,10);
	gtk_widget_show(tbl);
	vbox = gtk_vbox_new(FALSE,10);
	gtk_table_attach_defaults(GTK_TABLE(tbl),vbox,0,1,0,1);
	f1 = gtk_frame_new(text(96));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);
	f3 = gtk_frame_new(text(233));
	set_font_and_color(f3,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(vbox),f3,FALSE,FALSE,0);
	gtk_widget_show(f3);
	f2 = gtk_frame_new(text(232));
	set_font_and_color(f2,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
	gtk_widget_show(f2);
	gtk_widget_show(vbox);

	/* button bar at the bottom */
	hbox = gtk_hbox_new(TRUE,10);
	gtk_box_pack_start(GTK_BOX(actionspace),hbox,FALSE,TRUE,10);
	gtk_widget_show(hbox);
	b1 = gtk_button_new_with_label(text(231));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(verify_clicked), NULL);
	define_tooltip(b1, help(52));

	b_update = gtk_button_new_with_label(text(100));
	gtk_box_pack_start(GTK_BOX(hbox),b_update,TRUE,TRUE,10);
	gtk_widget_show(b_update);
	gtk_signal_connect(GTK_OBJECT(b_update), "clicked",
		GTK_SIGNAL_FUNC(update_readvrfy_clicked), GINT_TO_POINTER(0));
	define_tooltip(b_update,help(49));

	/*
	b1 = gtk_button_new_with_label(text(149));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(eject_clicked), NULL);
	*/

	/* left info frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f1),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
	gtk_widget_show(vbox);

	tbl = gtk_table_new(4,8,TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(103));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	vrylist_l1 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,0,1);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(104));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	vrylist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,1,2);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(105));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,2,3);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	vrylist_l3 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,2,3);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(145));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,3,4);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	vrylist_l4 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,8,3,4);
	gtk_widget_show(e1);

	/* options frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f3),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
	gtk_widget_show(vbox);

	tbl = gtk_table_new(2,8,TRUE);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,10);
	gtk_widget_show(tbl);

	check = gtk_check_button_new_with_label(text(234));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(verifyoptions_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,8,0,1);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.noaudioverify);
	gtk_widget_show(check);
	define_tooltip(check, help(53));
	
	check = gtk_check_button_new_with_label(text(236));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(verifyoptions_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,1,8,1,2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.verifyfailabort);
	gtk_widget_show(check);
	define_tooltip(check, help(54));
	
	/* right info frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f2),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
	gtk_widget_show(vbox);

	tbl = gtk_table_new(5,8,FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(172));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new();
	write_toc_menu = omenu;
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,8,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu, help(55));

	l1 = rightjust_gtk_label_new(text(103));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l1 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,1,2);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(104));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,2,3);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,2,3);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(105));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,3,4);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l3 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,3,4);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(145));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,4,5);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l4 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,4,5);
	gtk_widget_show(e1);


	gtk_widget_show(actionspace);

	/* fill entries */
	fill_verify_menu();
}


/* what do to when user selects a track from the list */

void playlist_select_row(GtkWidget *clist, gint row, gint col,
	GdkEventButton *event, gpointer data) {

	/* double click? */
	if (event && event->type == GDK_2BUTTON_PRESS) {
		/* stop current song and play selected */
		wavplay_dodouble();
	}
}


/* draw the play-tracks-menu */

void draw_play_tracks_menu() {
GtkWidget *scrolled_win;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar tmp3[MAXLINE];
gchar *titles[5];
gchar *data[5];
GtkWidget *list;
GtkCList *clist;
GdkPixmap *pixmap1;
GdkBitmap *mask1;
GtkStyle *style;
GList *loop;
image_files_t *entry;
gint count;

	/* prepare draw area */
	clear_actionspace();

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_box_pack_start(GTK_BOX(actionspace),scrolled_win,TRUE,TRUE,5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);
	
	titles[0] = "";
	titles[1] = text(139);
	titles[2] = text(140);
	titles[3] = text(141);
	titles[4] = text(142);

	list = gtk_clist_new_with_titles(5,titles);
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	gtk_widget_realize(list);
	clist = GTK_CLIST(list);
	gtk_clist_set_column_auto_resize(clist, 4, TRUE);
	play_clist = clist;
	gtk_signal_connect(GTK_OBJECT(list), "select_row",
		GTK_SIGNAL_FUNC(playlist_select_row), NULL);

	style = gtk_style_copy(gtk_widget_get_style(list));
	pixmap1 = gdk_pixmap_create_from_xpm_d(clist->clist_window,
		&mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
	data[0] = NULL;

	gtk_clist_set_row_height(clist, tbf(20));
	gtk_clist_set_column_width(clist, 0, tbf(20));
	gtk_clist_set_column_width(clist, 1, tbf(30));
	gtk_clist_set_column_justification(clist, 1, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_width(clist, 2, tbf(250));
	gtk_clist_set_column_width(clist, 3, tbf(80));
	gtk_widget_show(list);

	/* fill clist with valid audio-tracks */
	count = 1;
	loop = g_list_first(imagelist);
	while (loop) {
		entry = loop->data;
		if (entry->type == 1) {
			g_snprintf(tmp,MAXLINE,"%d.",count);
			data[1] = tmp;
			if (entry->title && entry->artist &&
			    strcmp(entry->title,"") && strcmp(entry->artist,"")) {
				g_snprintf(tmp3,MAXLINE,"%s / %s",
					entry->title, entry->artist);
				data[2] = tmp3;
			} else 
			if (entry->title && strcmp(entry->title,"")) {
				data[2] = entry->title;
			} else 
			if (entry->cddb_ttitle && strcmp(entry->cddb_ttitle,"")) {
				data[2] = entry->cddb_ttitle;
			} else {
				data[2] = NULL;
			} 
			convert_frames2minstring((gint)((off_t)entry->size/CDDAFRAME), tmp2);
			data[3] = tmp2;
			data[4] = entry->path;
			gtk_clist_append(clist,data);
			gtk_clist_set_pixmap(clist,count-1,0,pixmap1,mask1);

			count++;
		}
		loop = loop->next;
	}

	/* add wavplayer */
	wavplay_frontend(actionspace);

	gtk_widget_show(actionspace);
}


/* callbacks for buttons in write-screen */

void blankcd_clicked(GtkWidget *widget, gpointer data) {
	
	/* no cd-writer defined */
	if (curset.writer_devnr == -1) {
		show_dialog(ICO_ERROR,text(204), T_OK, NULL, NULL, 0);
		return;
	}

	display_blank_cdrw(curset.writer_devnr);
}

void show_atip_info(GtkWidget *widget, gpointer data) {

	display_atip_info(curset.writer_devnr);
}

void cdrtype_selected(GtkWidget *item, gpointer mode) {

	curset.cdrtype = GPOINTER_TO_INT(mode);
}

void writemode_selected(GtkWidget *item, gpointer data) {

	curset.writemode = GPOINTER_TO_INT(data);
}

void writeoptions_selected(GtkWidget *item, gpointer nr) {
gint sel;

	sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	switch(GPOINTER_TO_INT(nr)) {
		case 0:
			curset.writesimul = sel;
			break;
		case 1:
			curset.writeeject = sel;
			break;
		case 2:
			curset.writepad = sel;
			break;
		case 3:
			curset.writeswap = sel;
			break;
		case 4:
			curset.nofixate = sel;
			break;
		case 5:
			curset.multisession = sel;
/*
			show_dialog(ICO_INFO,text(394), T_OK, NULL, NULL, 0);
			curset.multisession = 0;
*/
			break;
		case 6: 
			curset.writecdtext = sel;
			break;
		case 7:
			curset.writeoverburn = sel;
			break;
		case 8:
			curset.writeburnfree = sel;
			break;	
	}
}


/* call back for toc-selector in write menu */

void tocwrite_selected(GtkWidget *item, gpointer val) {
GList *lelement;
gchar tmp[MAXLINE];
GdkWindowAttr *win_attr;
GdkCursor *cursor,*normal_cursor;

	strcpy(tmp,"");
	if (GPOINTER_TO_INT(val) >= 0) {
		lelement = g_list_nth(tocfiles, GPOINTER_TO_INT(val));
		if (lelement != NULL) {
			strcpy(tmp,(gchar *)lelement->data);
		}
	} else
	if (GPOINTER_TO_INT(val) == -1)  {
		/* on the fly setting */
		strcpy(tmp,"-");
	} else {
	 	/* empty setting (verify menu) */
		g_free(curset.tocfile);
		curset.tocfile = g_strdup("-");
		gtk_entry_set_text(GTK_ENTRY(cdlist_l1),"");
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");
		gtk_entry_set_text(GTK_ENTRY(cdlist_l3),"");
		gtk_entry_set_text(GTK_ENTRY(cdlist_l4),"");
		return;
	}

	/* save current setting */
	/* use full path string here because the index-number can get
	   lost too easily */
	g_free(curset.tocfile);
	curset.tocfile = g_strdup(tmp);

	do_lock(1);
	/* ok, now do some work - change cursor to watch */
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
		(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
	cursor = gdk_cursor_new(GDK_WATCH);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);
	while (gtk_events_pending())
		gtk_main_iteration();

	if (strcmp(curset.tocfile,"-") != 0) {
		read_copy_cd_toc_file(curset.tocfile);
	
		/* cd type */
		determine_cd_type(tmp,1);
		gtk_entry_set_text(GTK_ENTRY(cdlist_l1), tmp);	

		/* cd title */
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2), 
			trackreadset.cdtitle);
		
		/* cd-size */
		convert_frames2mbminstring(trackreadset.cdsize, tmp);
		gtk_entry_set_text(GTK_ENTRY(cdlist_l3), tmp);
	
		/* nr tracks */
		g_snprintf(tmp,MAXLINE,"%d",trackreadset.nrtracks);	
		gtk_entry_set_text(GTK_ENTRY(cdlist_l4), tmp);

		if (edit_cdtext_btn) 
			gtk_widget_set_sensitive(edit_cdtext_btn, TRUE);
	} else {
		/* we copy on the fly... */
		gtk_entry_set_text(GTK_ENTRY(cdlist_l2),"");
		gtk_entry_set_text(GTK_ENTRY(cdlist_l3),"");
		gtk_entry_set_text(GTK_ENTRY(cdlist_l4),"");
		if (cdinfo.nr_tracks == -1) {
			gtk_entry_set_text(GTK_ENTRY(cdlist_l1), text(156));
		} else 
		if (cdinfo.nr_tracks == -2) {
			gtk_entry_set_text(GTK_ENTRY(cdlist_l1), text(196));
		} else {
			/* cd is inserted - show info */
			determine_cd_type(tmp,0);
			gtk_entry_set_text(GTK_ENTRY(cdlist_l1), tmp);

			/* cd-label */
			if (cdinfo.title && cdinfo.artist && 
				cdinfo.title[0] != '\0' && 
				setupdata.option_displaycdtext) {
				g_snprintf(tmp,MAXLINE,"%s / %s", 
					cdinfo.title, cdinfo.artist);
				gtk_entry_set_text(GTK_ENTRY(cdlist_l2), tmp);
				gtk_entry_set_position(GTK_ENTRY(cdlist_l2),0);
			} else 
				if (cdinfo.cddb_dtitle != NULL) {
				gtk_entry_set_text(GTK_ENTRY(cdlist_l2), 
					cdinfo.cddb_dtitle);   
				gtk_entry_set_position(GTK_ENTRY(cdlist_l2),0);
			}

			/* cd-size */
			convert_frames2mbminstring(cdinfo.total_size, tmp);
			gtk_entry_set_text(GTK_ENTRY(cdlist_l3), tmp);

			/* nr tracks */	
			g_snprintf(tmp,MAXLINE,"%d",cdinfo.nr_tracks);
			gtk_entry_set_text(GTK_ENTRY(cdlist_l4), tmp);
		}

		/* on the fly copy, disable "Edit CD-Text" button */
		if (edit_cdtext_btn) {
			gtk_widget_set_sensitive(edit_cdtext_btn, FALSE);
		}
	}

	/* reset cursor */
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);
	do_unlock(1);
}


/* write button in write menu */

void writetracks_clicked(GtkWidget *widget, gpointer data) {
gint stat;
gint ret;
gint onthefly;
gint spaceneededoncd;
gint outofspace;
GList *loop;
track_read_param_t *trackparam;
	
	/* no cd-writer defined */
	if (curset.writer_devnr == -1) {
		show_dialog(ICO_ERROR,text(204), T_OK, NULL, NULL, 0);
		return;
	}

	/* on the fly setting? */
	if (strcmp(curset.tocfile,"-") == 0) {
		onthefly = 1;

		spaceneededoncd = cdinfo.total_size;

		if (cdinfo.nr_tracks < 0) {
			show_dialog(ICO_WARN,text(266),T_OK,NULL,NULL,0);
			return;
		}
		/* now check if read device is different from write device */
		if (curset.reader_devnr == curset.writer_devnr) {
			show_dialog(ICO_WARN,text(268),T_OK,NULL,NULL,0);
			return;
		}

		/* now check if we have a pure data cd (other we cannot
		   copy currently on the fly) */
		if (cdinfo.nr_tracks != 1 || trackinfo[0]->type != 0) {
			show_dialog(ICO_WARN,text(269),T_OK,NULL,NULL,0);
			return;
		}

		/* ok...everything seems to be fine */

	} else {
		onthefly = 0;
		spaceneededoncd = trackreadset.cdsize;

		/* first check if all tracks we need are available on hd */
		stat = check_write_files(0);
		switch(stat) {
		/* files with wrong size */
		case 1:
			ret = show_dialog(ICO_QUEST,text(198),T_ANYWAY,T_CANCEL, 
				NULL, 1);
			if (ret == 1) {
				/* aborted */
				return;
			}	
			break;
		/* files missing */
		case 2:
			show_dialog(ICO_ERROR,text(200),T_OK,NULL,NULL,0);
			return;

		/* no permission/invalid */
		case 3:
			show_dialog(ICO_ERROR,text(201),T_OK,NULL,NULL,0);
			return;

		}
	}

	/* check if enough space on cd-r? */
	dodebug(2,"Sectors required: %d, Mediatype = %d\n", spaceneededoncd,
		curset.cdrtype);
	outofspace = 0;
	if (curset.cdrtype < 1000) {
		/* minutes to check */
		if (spaceneededoncd > (curset.cdrtype*60*75)) {
			outofspace = 1;
		}
	} else {
		/* dvd sizes in MB */
		if (spaceneededoncd > (curset.cdrtype*512)) {
			outofspace = 1;
		}
	}
	if (outofspace) {
		ret = show_dialog(ICO_WARN,text(278),T_ANYWAY,T_CANCEL,NULL,1);
		if (ret == 1) {
			/* aborted */
			return;
		}	
	}

	/* ok, now we are sure that all tracks are fine ...prompt for CD-R */
	ret = show_dialog(ICO_INFO,text(202),T_OK,T_CANCEL,NULL,0);
	if (ret != 0) {
		return;
	}

	/* if we should write CD-Text then edit the .inf files from cdda2wav */
	if (curset.writecdtext) {
		loop = g_list_first(trackreadset.trackparams);
		while(loop) {
			trackparam = loop->data;
			if (trackparam->trackfile != NULL) {
				edit_xinf_for_cdtext(trackparam->trackfile,
					curset.tocfile);
			}
			loop = loop->next;
		}	

	}

	show_and_do_write_tracks(curset.writer_devnr, curset.reader_devnr, 
		onthefly);
}


/* fill the entries in the write_cd-menu */

void fill_write_menu() {
GList *loop;
GtkWidget *menu;
GtkWidget *menu_item, *menuselitem;
gchar tmp[MAXLINE];
gint menuidx, menuhistory;
gint i, len;

	/* get list of toc-files (save in tocfiles var) */
	scan_for_toc_files();

	/* clear out the old menu first (if any) */
	gtk_option_menu_remove_menu(GTK_OPTION_MENU (write_toc_menu));

	menu = gtk_menu_new();
	menuselitem = NULL;
	menuidx = 0; menuhistory = 0;
	i = 0;
	loop = g_list_first(tocfiles);	
	while (loop) {
		/* a bug in gtk wont allow longer option-menus...
		   well, then strip the strings down (not nice, but 
		   so far the only way I can think of */
		len = strlen((gchar *)loop->data);
		if (len > 24) {
			strcpy(tmp, ".. ");
			strcat(tmp, (gchar *)loop->data + len - 24);
		} else {
			strcpy(tmp, (gchar *)loop->data);
		}
		menu_item = gtk_menu_item_new_with_label(tmp);
		if (menuselitem == NULL) {
			/* default first element */
			menuselitem = menu_item;
		} 
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(tocwrite_selected),
			GINT_TO_POINTER(i));
		if (strcmp(curset.tocfile, (gchar *)loop->data) == 0) {
			menuhistory = menuidx;
			menuselitem = menu_item;
		}
		gtk_menu_append (GTK_MENU (menu), menu_item);
		gtk_widget_show (menu_item);
		loop = loop->next;
		menuidx++;
		i++;
	}
	/* on the fly setting */
	menu_item = gtk_menu_item_new_with_label(text(197));
	gtk_signal_connect(GTK_OBJECT(menu_item),
		"activate", GTK_SIGNAL_FUNC(tocwrite_selected),
		GINT_TO_POINTER(-1));
	if (strcmp(curset.tocfile, "-") == 0) {
		menuhistory = menuidx;
		menuselitem = menu_item;
	}
	gtk_menu_append (GTK_MENU (menu), menu_item);
	gtk_widget_show (menu_item);

	gtk_option_menu_set_menu (GTK_OPTION_MENU (write_toc_menu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (write_toc_menu),menuhistory);
	/* toggle currently active menu */ 
	if (menuselitem != NULL) {
		gtk_menu_item_activate(GTK_MENU_ITEM (menuselitem));
	} else {
		/* if no active menu, activate the last set */
		/* (one the fly in this case) */
		gtk_menu_item_activate(GTK_MENU_ITEM (menu_item));
	}	

}


/* draw the write-tracks menu */

void draw_write_menu() {
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
GtkWidget *hbox, *vbox;
GtkWidget *f1,*f2;
GtkWidget *b1;
GtkWidget *e1, *check;
GtkWidget *l1;
GtkWidget *tbl;
GtkWidget *sep;
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
gint cdrtypes[] = CDR_TYPES_MIN;
gint dvdtypes[] = DVD_TYPES_MB;
gint writemodes[] = WRITE_MODES;
gint helpwritemodes[] = HELP_WRITE_MODES;
gint i, tmpval;
gint menuidx, menuhistory;

	/* prepare draw area */
	clear_actionspace();

	f1 = gtk_frame_new(text(107));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
	gtk_widget_show(f1);

	tbl = gtk_table_new(3,16*4,TRUE);	
	gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-2,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	devices_setup_read(0, tbl, 1);
	devices_setup_image(1, tbl);
	devices_setup_write(2, tbl);

	/* left and right info-frames */
	tbl = gtk_table_new(1,2,TRUE);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(actionspace),tbl,TRUE,TRUE,10);
	gtk_widget_show(tbl);
	f1 = gtk_frame_new(text(168));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
	gtk_widget_show(f1);
	f2 = gtk_frame_new(text(169));
	set_font_and_color(f2,BOLDFONT,NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f2,1,2,0,1);
	gtk_widget_show(f2);

	/* button bar at the bottom */
	hbox = gtk_hbox_new(TRUE,10);
	gtk_box_pack_start(GTK_BOX(actionspace),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);
	b1 = gtk_button_new_with_label(text(170));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(writetracks_clicked), NULL);
	define_tooltip(b1,help(63));

	b1 = gtk_button_new_with_label(text(171));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1), "clicked",
		GTK_SIGNAL_FUNC(blankcd_clicked), NULL);
	define_tooltip(b1,help(64));


	/* left info frame */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f1),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
	gtk_widget_show(vbox);

	tbl = gtk_table_new(5,8,FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(172));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new();
	write_toc_menu = omenu;
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,8,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,help(65));

	l1 = rightjust_gtk_label_new(text(103));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,1,2);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l1 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,1,2);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(104));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,2,3);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,2,3);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(105));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,3,4);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l3 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,3,4);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(145));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,4,5);
	gtk_widget_show(l1);

	e1 = gtk_entry_new();
	cdlist_l4 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,3,8,4,5);
	gtk_widget_show(e1);


	/* right info frame */
	/* write-parameters */
	vbox = gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(f2),vbox);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 7);
	gtk_widget_show(vbox);

	tbl = gtk_table_new(10,16,FALSE);
	gtk_table_set_row_spacing(GTK_TABLE(tbl),0,2);
	gtk_table_set_row_spacing(GTK_TABLE(tbl),1,5);
	gtk_table_set_row_spacing(GTK_TABLE(tbl),2,5);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(vbox),tbl,FALSE,FALSE,0);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(173));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new();
	menu = gtk_menu_new();
	menuidx = 0; menuhistory = 0;

	i = 0;
	tmpval = curset.cdrtype;
	while (cdrtypes[i] != 0) {
		/* contruct minute-list */
		g_snprintf(tmp,MAXLINE,"%d min",abs(cdrtypes[i]));

		menu_item = gtk_menu_item_new_with_label(tmp);
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(cdrtype_selected),
			GINT_TO_POINTER(abs(cdrtypes[i])));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		if (tmpval == abs(cdrtypes[i])) { 
			menuhistory = menuidx;
		}
		/* default set defined by negativ value */
		if (tmpval == 0 && cdrtypes[i] < 0) {
			menuhistory = menuidx;
			curset.cdrtype = abs(cdrtypes[i]);
		}
		menuidx++;
		gtk_widget_show (menu_item);
		i++;
	}
	if (curset.isProDVD) {
		i = 0;
		tmpval = curset.cdrtype;
		while (dvdtypes[i] != 0) {
			/* contruct GB-list */
			g_snprintf(tmp2,MAXLINE,"%.2f", (gfloat)dvdtypes[i]/1000);
			/* strip last 0 */
			if (tmp2[strlen(tmp2)-1] == '0') {
				tmp2[strlen(tmp2)-1] = '\0';
			}
			g_snprintf(tmp,MAXLINE,"%s GB",tmp2);

			menu_item = gtk_menu_item_new_with_label(tmp);
			gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(cdrtype_selected),
			GINT_TO_POINTER(dvdtypes[i]));
			gtk_menu_append (GTK_MENU (menu), menu_item);
			if (tmpval == abs(dvdtypes[i])) { 
				menuhistory = menuidx;
			}
			menuidx++;
			gtk_widget_show (menu_item);
			i++;
		}
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,6,11,0,1);
	gtk_widget_show(omenu);
	define_tooltip(omenu,help(66));

	b1 = gtk_button_new_with_label(text(175));
	gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(show_atip_info),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),b1,11,16,0,1);
	gtk_widget_show(b1);
	define_tooltip(b1,help(67));


	/* write-mode */
	l1 = rightjust_gtk_label_new(text(174));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,1,2);
	gtk_widget_show(l1);


        omenu = gtk_option_menu_new ();
        menu = gtk_menu_new();

        i = 0;
        while (writemodes[i]) {
                menu_item = gtk_menu_item_new_with_label(text(writemodes[i]));
                gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                        GTK_SIGNAL_FUNC(writemode_selected),
                        GINT_TO_POINTER(i));
                gtk_menu_append (GTK_MENU (menu), menu_item);
                gtk_widget_show (menu_item);
                if (helpwritemodes[i])
                        define_tooltip(menu_item,help(helpwritemodes[i]));
                i++;
        }

/*
	btn = gtk_radio_button_new_with_label(NULL,text(178));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(writemode_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,6,16,1,2);
	gtk_widget_show(btn);
	if (curset.writemode == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);
	define_tooltip(btn,help(68));

        if (!isroot() && !setupdata.root_option_change_writeparam) {
                gtk_widget_set_sensitive(btn,FALSE);
        }


	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,text(179));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(writemode_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,6,16,2,3);
	gtk_widget_show(btn);
	if (curset.writemode == 1) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);
	define_tooltip(btn,help(69));

        if (!isroot() && !setupdata.root_option_change_writeparam) {
                gtk_widget_set_sensitive(btn,FALSE);
        }

	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	btn = gtk_radio_button_new_with_label(group,text(276));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(writemode_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,6,16,3,4);
	gtk_widget_show(btn);
	if (curset.writemode == 2) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 1);
	define_tooltip(btn,help(70));

        if (!isroot() && !setupdata.root_option_change_writeparam) {
                gtk_widget_set_sensitive(btn,FALSE);
        }
*/

        gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
        gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),
                curset.writemode);
        gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,6,16,1,2);
        gtk_widget_show(omenu);
        /* concat 2 help strings */
        g_snprintf(tmp,MAXLINE,"%s %s",help(180), help(182));
        define_tooltip(omenu,tmp);

        if (!isroot() && !setupdata.root_option_change_writeparam) {
                gtk_widget_set_sensitive(omenu,FALSE);
        }

	sep = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(tbl),sep,0,16,2,3);
	gtk_widget_show(sep);

	check = gtk_check_button_new_with_label(text(180));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,3,4);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.writesimul);
	gtk_widget_show(check);
	define_tooltip(check,help(71));

	check = gtk_check_button_new_with_label(text(181));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,4,5);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.writeeject);
	gtk_widget_show(check);
	define_tooltip(check,help(72));
	
	check = gtk_check_button_new_with_label(text(182));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(2));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,5,6);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.writepad);
	gtk_widget_show(check);
	define_tooltip(check,help(152));
	
	check = gtk_check_button_new_with_label(text(183));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(3));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,6,7);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.writeswap);
	gtk_widget_show(check);
	define_tooltip(check,help(74));

	check = gtk_check_button_new_with_label(text(470));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(7));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,7,8);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.writeoverburn);
	gtk_widget_show(check);
	define_tooltip(check,help(184));

	check = gtk_check_button_new_with_label(text(471));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(8));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,16,8,9);
	if (does_support_burnproof()) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
			curset.writeburnfree);
	}
	gtk_widget_show(check);
	define_tooltip(check,help(185));

	if (!does_support_burnproof())
                gtk_widget_set_sensitive(check,FALSE);

	check = gtk_check_button_new_with_label(text(469));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(writeoptions_selected),GINT_TO_POINTER(6));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,2,9,9,10);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.writecdtext);
	gtk_widget_show(check);
	define_tooltip(check,help(183));

        b1 = gtk_button_new_with_label(text(473));
	edit_cdtext_btn = b1;
        gtk_signal_connect (GTK_OBJECT (b1), "clicked",
                GTK_SIGNAL_FUNC(edit_cdtext_clicked), GINT_TO_POINTER(1));
        gtk_table_attach_defaults(GTK_TABLE(tbl),b1,9,16,9,10);
        gtk_widget_show(b1);
        define_tooltip(b1,help(187));

	
	gtk_widget_show(actionspace);


	/* fill entries */
	fill_write_menu();

}


/* fill the list with the tracks to delete */

void fill_delete_menu() {
GtkStyle *style;
gchar *data[5];
GdkPixmap *pixmap1, *pixmap2, *pixmap3, *pixmap4, *pixmap5;
GdkBitmap *mask1, *mask2, *mask3, *mask4, *mask5;
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
gchar tmp3[MAXLINE];
gchar basename[MAXLINE], imgdir[MAXLINE], *p;
GList *loop;
image_files_t *entry;
gint lcount, count;
gint sizecount;
gint dummy;

	/* clean up first */
	gtk_clist_clear(imglist);

	style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(imglist)));
	pixmap1 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
	pixmap2 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
	pixmap3 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask3, &style->bg[GTK_STATE_NORMAL],(gchar **)mininodata_xpm);
	pixmap4 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask4, &style->bg[GTK_STATE_NORMAL],(gchar **)mininoaudio_xpm);
	pixmap5 = gdk_pixmap_create_from_xpm_d(imglist->clist_window,
		&mask5, &style->bg[GTK_STATE_NORMAL],(gchar **)minitoc_xpm);

	data[0] = NULL;
	strcpy(imgdir,"");
	lcount = 0;
	count = 1;
	sizecount = 0;

	/* check image-selector */
	if (curset.image_index != -1) {
		/* no automatic setting? */
		strncpy(imgdir,(gchar *)g_list_nth_data(setupdata.image_dirs,
			curset.image_index), MAXLINE);
	}

	loop = g_list_first(imagelist);
	while (loop) {
		entry = loop->data;

		/* get the base-dirname */
		strncpy(basename,entry->path,MAXLINE);	
		p = rindex(basename,'/');
		*p = '\0';
		if (strcmp(basename,"") == 0) {
			strcpy(basename,"/");
		}
		if (strcmp(basename,imgdir) != 0 && imgdir[0] != '\0') {
			/* skip not selected dirs */
			loop = loop->next;
			continue;
		}

		/* count */
		g_snprintf(tmp,MAXLINE,"%d.",count);
		data[1] = tmp;

		/* title */
		if (entry->title && entry->artist &&
			strcmp(entry->title,"") && strcmp(entry->artist,"")) {
			g_snprintf(tmp3,MAXLINE,"%s / %s",
				entry->title, entry->artist);
				data[2] = tmp3;
		} else 
		if (entry->title && strcmp(entry->title,"")) {
			data[2] = entry->title;
		} else 
		 if (entry->cddb_ttitle && strcmp(entry->cddb_ttitle,"")) {
			data[2] = entry->cddb_ttitle;
		} else 
		if (entry->volname && strcmp(entry->volname,"")) {
			g_snprintf(tmp3,MAXLINE,"%s / ISO9660",
				entry->volname);
			data[2] = tmp3;
		} else {
			data[2] = NULL;
		}

		/* path */
		data[4] = entry->path;

		/* iso9600-track/ unknown  */
		if (entry->type == 0 || entry->type == 3) {
			convert_frames2mbstring((gint)((off_t)entry->size/DATASECTORSIZE),
				tmp2);
			data[3] = tmp2;
			gtk_clist_append(imglist,data);
			if (entry->readable == 1 && entry->type == 0) {
				gtk_clist_set_pixmap(imglist,lcount,0,pixmap1,mask1);	
			} else {
				gtk_clist_set_pixmap(imglist,lcount,0,pixmap3,mask3);	
			}
			lcount++;
			sizecount+=(gint)((off_t)entry->size >> 10);
			count++;
		}

		/* valid/invalid wav-file */
		if (entry->type == 1 || entry->type == 2) {
			convert_frames2minstring((gint)((off_t)entry->size/CDDAFRAME), tmp2);
			data[3] = tmp2;
			gtk_clist_append(imglist,data);
			if (entry->readable == 1 && entry->type == 1) {
				gtk_clist_set_pixmap(imglist,lcount,0,pixmap2,mask2);	
			} else {
				gtk_clist_set_pixmap(imglist,lcount,0,pixmap4,mask4);	
			}
			lcount++;
			sizecount+=(gint)((off_t)entry->size >> 10);
			count++;
		}	

		/* toc-file */
		if (entry->type == 4) {
			data[3] = NULL; 
			gtk_clist_append(imglist,data);
			gtk_clist_set_pixmap(imglist,lcount,0,pixmap5, mask5);
			count++;
			lcount++;
		}

		loop = loop->next;
	}

	/* nothing selected - no size of files */
	convert_kbytes2mbminstring(0, tmp);
	gtk_entry_set_text(GTK_ENTRY(imglist_l1), tmp);	 

	/* free size */
	convert_kbytes2mbminstring(determine_free_space(&dummy),tmp);
	gtk_entry_set_text(GTK_ENTRY(imglist_l2), tmp);
}


/* select a row with a given filename */

void select_delete_row_by_filename(gchar *fname) {
gint i;
gchar *cell;

	/* loop through all rows */
	for (i = 0; i < imglist->rows; i++) {
		gtk_clist_get_text(imglist,i,4,&cell);
		if (strcmp(cell, fname) == 0) {
			/* match found - select row */
			gtk_clist_select_row(imglist, i, 0);
		}
	}
}


/* update currently selected track-size */

void update_delete_size(gint doubleclick, gint clickrow) {
GList *sel;
gint row,type;
gchar *cell;
off_t size;
gint sizecount;
gchar tmp[MAXLINE];
GList *loop;
track_read_param_t *trackparam;

	sizecount = 0;

	/* check for doubleclick on list */
	if (doubleclick) {
		gtk_clist_get_text(imglist,clickrow,4,&cell);
		type = get_type_from_imagelist(cell);
		/* is it a toc-file? (type 4) */
		if (type == 4) {
			/* now scan toc file */
			read_copy_cd_toc_file(cell);

			/* select all files to delete which are in the 
			   toc-file */
			loop = g_list_first(trackreadset.trackparams);
			while(loop) {
				trackparam = loop->data;
				select_delete_row_by_filename(
					trackparam->trackfile);

				loop = loop->next;
			}
		}
	}

	/* loop through all selected tracks */
	sel = imglist->selection;
	while (sel) {
		row = GPOINTER_TO_INT(sel->data);		
		gtk_clist_get_text(imglist,row,4,&cell);
		size = get_size_from_imagelist(cell);
		sizecount += (gint)((off_t)size >> 10);
		sel = sel->next;
	}

	convert_kbytes2mbminstring(sizecount, tmp);
	gtk_entry_set_text(GTK_ENTRY(imglist_l1), tmp);
}


/* start the delete job */

void do_delete_press(GtkWidget *widget, gpointer data) {
GList *sel;
gint row;
gchar *cell;
gint count,ret;
gchar tmp[MAXLINE];
GList *delfiles;

	delfiles = NULL;
	count = 0;
	/* loop through all selected tracks */
	/* create a glist containing all files names to delete */
	sel = imglist->selection;
	while (sel) {
		row = GPOINTER_TO_INT(sel->data);		
		gtk_clist_get_text(imglist,row,4,&cell);
		delfiles = g_list_append(delfiles,g_strdup(cell));
		count++;
		sel = sel->next;
	}

	if (count == 0) {
		show_dialog(ICO_WARN,text(224), T_OK, NULL, NULL, 0);
		return;
	} else 
	if (count == 1) {
		ret = show_dialog(ICO_QUEST,text(225),T_YES,T_NO,NULL,0);
	} else {
		g_snprintf(tmp,MAXLINE,text(226),count);
		ret = show_dialog(ICO_QUEST,tmp,T_YES,T_NO,NULL,0);
	}

	if (ret == 1) {
		/* not sure - abort */
		return;
	}

	/* create menu showing deletion */
	show_and_do_delete(delfiles);

	free_glist(&delfiles);

	/* now update image-list */
	scan_imagedirs();
	fill_delete_menu();
}

void delete_select_all(GtkWidget *widget, gpointer data) {

	gtk_clist_select_all(imglist);
}

void delete_select_none(GtkWidget *widget, gpointer data) {

	gtk_clist_unselect_all(imglist);
}

void delete_select_row(GtkWidget *clist, gint row, gint col,
	GdkEventButton *event, gpointer data) {

	/* double click? */
	if (event && event->type == GDK_2BUTTON_PRESS) {
		update_delete_size(1, row);
	} else {
		update_delete_size(0, row);
	}
}


/* draw the delete-tracks menu */

void draw_delete_menu() {
GtkWidget *hbox;
GtkWidget *f1;
GtkWidget *b1;
GtkWidget *list;
gchar *titles[5];
GtkCList *clist;
GtkWidget *e1;
GtkWidget *l1;
GtkWidget *tbl;
GtkWidget *sep;
GtkWidget *scrolled_win;

	/* prepare draw area */
	clear_actionspace();

	f1 = gtk_frame_new(text(107));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(actionspace),f1,FALSE,FALSE,5);
	gtk_widget_show(f1);

	tbl = gtk_table_new(1,16*4,TRUE);	
	gtk_table_set_col_spacing(GTK_TABLE(tbl),4*4-1,5);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),15*4-2,5);
	gtk_container_set_border_width(GTK_CONTAINER (tbl),5);
	gtk_container_add(GTK_CONTAINER(f1),tbl);
	gtk_widget_show(tbl);

	devices_setup_image(0, tbl);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 10);
	gtk_box_pack_start(GTK_BOX(actionspace),scrolled_win,TRUE,TRUE,0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
	gtk_widget_show(scrolled_win);
	
	titles[0] = "";
	titles[1] = text(139);
	titles[2] = text(140);
	titles[3] = text(141);
	titles[4] = text(142);

	list = gtk_clist_new_with_titles(5,titles);
	gtk_container_add (GTK_CONTAINER (scrolled_win), list);
	gtk_widget_realize(list);
	clist = GTK_CLIST(list);
	imglist = clist;
	gtk_clist_set_column_auto_resize(clist, 4, TRUE);
	gtk_signal_connect(GTK_OBJECT(clist), "select_row",
		GTK_SIGNAL_FUNC(delete_select_row),NULL);
	gtk_signal_connect(GTK_OBJECT(clist), "unselect_row",
		GTK_SIGNAL_FUNC(delete_select_row),NULL);

	gtk_clist_set_row_height(clist, tbf(20));
	gtk_clist_set_column_width(clist, 0, tbf(20));
	gtk_clist_set_column_width(clist, 1, tbf(30));
	gtk_clist_set_column_justification(clist, 1, GTK_JUSTIFY_CENTER);
	gtk_clist_set_column_width(clist, 2, tbf(250));
	gtk_clist_set_column_width(clist, 3, tbf(80));
	if (setupdata.option_selectionmode == 0) {
		gtk_clist_set_selection_mode (clist, GTK_SELECTION_MULTIPLE);
	} else {
		gtk_clist_set_selection_mode (clist, GTK_SELECTION_EXTENDED);
	}
	gtk_widget_show(list);

	tbl = gtk_table_new(2,16,TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),10);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(actionspace),tbl,FALSE,FALSE,10);
	gtk_widget_show(tbl);
	
	l1 = rightjust_gtk_label_new(text(219));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,0,1);
	gtk_widget_show(l1);
	e1 = gtk_entry_new();
	imglist_l1 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,6,10,0,1);
	gtk_widget_show(e1);

	l1 = rightjust_gtk_label_new(text(220));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,6,1,2);
	gtk_widget_show(l1);
	e1 = gtk_entry_new();
	imglist_l2 = e1;
	gtk_entry_set_editable(GTK_ENTRY(e1),FALSE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,6,10,1,2);
	gtk_widget_show(e1);

	sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(actionspace),sep,FALSE,FALSE,10);
	gtk_widget_show(sep);

	/* button bar at the bottom */
	hbox = gtk_hbox_new(TRUE,10);
	gtk_box_pack_start(GTK_BOX(actionspace),hbox,FALSE,TRUE,10);
	gtk_widget_show(hbox);

	b1 = gtk_button_new_with_label(text(221));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1),"clicked",
		GTK_SIGNAL_FUNC(delete_select_all), NULL);
	define_tooltip(b1,help(76));

	b1 = gtk_button_new_with_label(text(222));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1),"clicked",
		GTK_SIGNAL_FUNC(delete_select_none), NULL);
	define_tooltip(b1,help(77));

	b1 = gtk_button_new_with_label(text(223));
	gtk_box_pack_start(GTK_BOX(hbox),b1,TRUE,TRUE,10);
	gtk_widget_show(b1);
	gtk_signal_connect(GTK_OBJECT(b1),"clicked",
		GTK_SIGNAL_FUNC(do_delete_press), NULL);
	define_tooltip(b1,help(75));

	gtk_widget_show(actionspace);

	/* fill entries */
	fill_delete_menu();
}


/* unselects all buttons on the sidebar (except the one given)
   So there is always only one selected */

void reset_duplicate_buttons(GtkWidget *exclude) {
int i;

	for (i = 0; i < 7; i++) {
		if (side_widgets[i] != exclude) {
			gtk_signal_handler_block(GTK_OBJECT(side_widgets[i]),side_handlers[i]);
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(side_widgets[i]),0);
			gtk_signal_handler_unblock(GTK_OBJECT(side_widgets[i]),side_handlers[i]);
		}
	}

	/* because this is called whenever somebody clicks on a
	   sidebar button, we can here check if the wav-player
	   process from "play track" is still running, when the
	   user quits this menu. So lets care here that it is
	   terminated in a nice way */

	if (wav_in != -1) {
		do_lock(0);

		/* we want to quit the wavplayer.. */
		wavplay_quit = 1;

		/* simulate quit-button-press */
		gtk_button_clicked(GTK_BUTTON(wav_quit_button));

		/* now wait until we are really finished */
		while (wav_in != -1) {
			wait_and_process_events();
		}

		/* now give gtk some extra time to initialize */
		for (i = 0; i < 3; i++) {
			wait_and_process_events();
		}

		do_unlock(0);
	}
} 

void menu_duplicate_info(GtkWidget *widget, gpointer data) {

	/* if button already pressed ignore and undo click */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
		gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers[0]);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
		gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers[0]);
		return;
	}
	reset_duplicate_buttons(widget);

	dolog(2, "Entering duplicate: info menu\n");
	draw_info_menu();
}

void menu_duplicate_read(GtkWidget *widget, gpointer data) {

	/* if button already pressed ignore and undo click */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
		gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers[1]);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
		gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers[1]);
		return;
	}
	reset_duplicate_buttons(widget);

	dolog(2, "Entering duplicate: read menu\n");
	draw_read_menu();
}

void menu_duplicate_verify(GtkWidget *widget, gpointer data) {

	/* if button already pressed ignore and undo click */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
		gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers[2]);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
		gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers[2]);
		return;
	}
	reset_duplicate_buttons(widget);

	dolog(2, "Entering duplicate: verify menu\n");
	draw_verify_menu();
}

void menu_duplicate_play(GtkWidget *widget, gpointer data) {

	/* if button already pressed ignore and undo click */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
		gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers[3]);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
		gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers[3]);
		return;
	}
	reset_duplicate_buttons(widget);

	dolog(2, "Entering duplicate: play menu\n");
	draw_play_tracks_menu();
}

void menu_duplicate_write(GtkWidget *widget, gpointer data) {

	/* if button already pressed ignore and undo click */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
		gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers[4]);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
		gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers[4]);
		return;
	}
	reset_duplicate_buttons(widget);

	dolog(2, "Entering duplicate: write menu\n");
	draw_write_menu();
}

void menu_duplicate_delete(GtkWidget *widget, gpointer data) {

	/* if button already pressed ignore and undo click */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget)) == 0) {
		gtk_signal_handler_block(GTK_OBJECT(widget),side_handlers[5]);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget),1);
		gtk_signal_handler_unblock(GTK_OBJECT(widget),side_handlers[5]);
		return;
	}

	reset_duplicate_buttons(widget);

	dolog(2, "Entering duplicate: delete menu\n");
	draw_delete_menu();
}

void menu_duplicate_back(GtkWidget *widget, gpointer data) {

	reset_duplicate_buttons(widget);
	create_main(0);
}


/* called by the duplicate-button */

void create_duplicate() {
GtkWidget *side_t;
GtkWidget *head,*head_l;
GtkWidget *b1;

	submenu = 1;
	clear_sidespace();
	clear_workspace();

	side_t = gtk_table_new(10,10, TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(side_t),10);
	gtk_box_pack_start(GTK_BOX(sidespace), side_t,TRUE,TRUE,0);

	b1 = gtk_toggle_button_new_with_label(text(92));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,1,2);
	/* preselect the first button */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(b1),1);
	gtk_widget_show(b1);
	side_handlers[0] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_duplicate_info),NULL);	
	side_widgets[0] = b1;
	define_tooltip(b1,help(35));

	b1 = gtk_toggle_button_new_with_label(text(93));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,2,3);
	gtk_widget_show(b1);
	side_handlers[1] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_duplicate_read),NULL);	
	side_widgets[1] = b1;
	define_tooltip(b1,help(36));

	b1 = gtk_toggle_button_new_with_label(text(94));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,3,4);
	gtk_widget_show(b1);
	side_handlers[2] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_duplicate_verify),NULL);	
	side_widgets[2] = b1;
	define_tooltip(b1,help(37));

	b1 = gtk_toggle_button_new_with_label(text(138));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,4,5);
	gtk_widget_show(b1);
	side_handlers[3] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_duplicate_play),NULL);	
	side_widgets[3] = b1;
	define_tooltip(b1,help(38));

	b1 = gtk_toggle_button_new_with_label(text(95));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,5,6);
	gtk_widget_show(b1);
	side_handlers[4] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_duplicate_write),NULL);	
	side_widgets[4] = b1;
	define_tooltip(b1,help(39));

	b1 = gtk_toggle_button_new_with_label(text(184));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,6,7);
	gtk_widget_show(b1);
	side_handlers[5] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_duplicate_delete),NULL);	
	side_widgets[5] = b1;
	define_tooltip(b1,help(40));

	b1 = gtk_toggle_button_new_with_label(text(91));
	gtk_table_attach_defaults(GTK_TABLE(side_t), b1, 0,10,8,9);
	gtk_widget_show(b1);
	side_handlers[6] = gtk_signal_connect (GTK_OBJECT (b1), "clicked",
		GTK_SIGNAL_FUNC(menu_duplicate_back),NULL);	
	side_widgets[6] = b1;
	define_tooltip(b1,help(41));

	gtk_widget_show(side_t);
	gtk_widget_show(sidespace);

	/* draw workspace */

	head = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(head),GTK_SHADOW_IN);
	gtk_widget_set_usize(head,0,45);
	gtk_box_pack_start(GTK_BOX(workspace), head,FALSE,FALSE,0);
	gtk_widget_show(head);
	head_l = gtk_label_new(text(5));
	set_font_and_color(head_l,BIGFONT,NULL);
	gtk_container_add(GTK_CONTAINER(head),head_l);
	gtk_widget_show(head_l);

	/* space where sub-windows are placed */
	actionspace = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(workspace), actionspace,TRUE,FALSE,0);

	gtk_widget_show(workspace);

	/* the default submenu for a start */
 	draw_info_menu();	
}

