#include <iostream.h>

#include "xfdata.h"

void GraphicsCard::dump() const
{
    cout << "<graphicscard>" << endl;
    cout << "  <devicesection>" << endl << deviceSection.latin1() << "  </devicesection>" << endl;
    cout << "  <modulesection>" << endl << moduleSection.latin1() << "  </modulesection>" << endl;
    cout << "  <drivername>" << driverName.latin1() << "</drivername>" << endl;
    cout << "  <pixelclock type=\"" << (fixedClock ? "fixed" : "max") << "\">" << endl;
    if ( fixedClock ) {
        cout << "    <clocks>" << fixedClocks.latin1() << "</clocks>" << endl;
    } else {
        cout << "    <clocks>" << maxClock << "</clocks>" << endl;
    }
    cout << "  </pixelclock>" << endl;
    cout << "  <videoram>" << ram << "</videoram>" << endl;
    cout << "</graphicscard>" << endl;
}

void LCDMonitor::dump() const
{
    cout << "<lcdmonitor>" << endl;
    cout << "  <model>" << model.latin1() << "</model>" << endl;
    cout << "  <horizsync>" << horizSync.latin1() << "</horizsync>" << endl;
    cout << "</lcdmonitor>" << endl;
}

void Monitor::dump() const
{
    cout << "<monitor>" << endl;
    cout << "  <vendor>" << vendor.latin1() << "</vendor>" << endl;
    cout << "  <model>" << model.latin1() << "</model>" << endl;
    cout << "  <hmin>" << hMin << "</hmin>" << endl;
    cout << "  <hmax>" << hMax << "</hmax>" << endl;
    cout << "  <vmin>" << vMin << "</vmin>" << endl;
    cout << "  <vmax>" << vMax << "</vmax>" << endl;
    cout << "  <hsynctoken>" << hSyncToken.latin1() << "</hsynctoken>" << endl;
    cout << "  <vsynctoken>" << vSyncToken.latin1() << "</vsynctoken>" << endl;
    cout << "  <modelines>" << endl << modeLines.latin1() << endl << "  </modelines>" << endl;
    cout << "</monitor>" << endl;
}
