/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.properties;

import java.beans.PropertyEditorSupport;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePropertyEditor
extends PropertyEditorSupport {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ValueFactory valueFactory;

    public ResourcePropertyEditor(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public String getAsText() {
        String result = null;
        Resource resource = (Resource)this.getValue();
        if (resource != null) {
            result = Protocol.encodeValue(resource);
            this.logger.debug("Getting resource as " + result);
        }
        return result;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (!"".equals(text)) {
            Resource result = Protocol.decodeResource(text, this.valueFactory);
            this.logger.debug("Setting resource to " + result);
            this.setValue(result);
        } else {
            this.setValue(null);
        }
    }
}

