/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.properties;

import java.beans.PropertyEditorSupport;
import org.openrdf.http.protocol.Protocol;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValuePropertyEditor
extends PropertyEditorSupport {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ValueFactory valueFactory;

    public ValuePropertyEditor(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public String getAsText() {
        String result = null;
        Value value = (Value)this.getValue();
        if (value != null) {
            result = Protocol.encodeValue(value);
            this.logger.debug("Getting value as " + result);
        }
        return result;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        if (!"".equals(text)) {
            Value value = Protocol.decodeValue(text, this.valueFactory);
            this.logger.debug("Setting value to " + value);
            this.setValue(value);
        } else {
            this.setValue(null);
        }
    }
}

