.\" Copyright 1999 Sun Microsystems, Inc.  All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetKeySyms __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetKeySyms \- Obtain the symbols for a subset of the keys in a keyboard 
description
.SH SYNOPSIS
.HP
.B Status XkbGetKeySyms
.BI "(\^Display *" "dpy" "\^,"
.BI "unsigned int " "first" "\^,"
.BI "unsigned int " "num" "\^,"
.BI "XkbDescPtr " "xkb" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- dpy
connection to X server
.TP
.I \- first
keycode of first key to get
.TP
.I \- num
number of keycodes for which syms desired 
.TP
.I \- xkb
Xkb description to be updated
.SH DESCRIPTION
.LP
.I XkbGetKeySyms 
sends a request to the server to obtain the set of keysyms bound to 
.I num 
keys starting with the key whose keycode is 
.I first. 
It waits for a reply and returns the keysyms in the 
.I map.syms 
field of 
.I xkb. 
If successful, 
.I XkbGetKeySyms 
returns Success. The 
.I xkb 
parameter must be a pointer to a valid Xkb keyboard description.

If the client 
.I map 
in the xkb parameter has not been allocated, 
.I XkbGetKeySyms 
allocates and initializes it before obtaining the symbols. 

If a compatible version of Xkb is not available in the server or the Xkb 
extension has not been properly initialized, 
.I XkbGetKeySyms 
returns BadAccess. If 
.I num 
is less than 1 or greater than XkbMaxKeyCount, 
.I XkbGetKeySyms 
returns BadValue. If any allocation errors occur, 
.I XkbGetKeySyms 
returns BadAlloc.
.SH "RETURN VALUES"
.TP 15
Success
The 
.I XkbGetKeySyms 
function returns Success if it gets a reply to a request to the server to obtain the set of keysyms bound to 
.I num 
keys starting with the key whose keycode is 
.I first. 
.SH DIAGNOSTICS
.TP 15
.B BadAccess
The Xkb extension has not been properly initialized
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadValue
An argument is out of range
