#!/bin/sh

unset ZONE KTAG ALGO DTYPE DIGEST

export IFS="="
xml2 | while read -r KEY VAL; do
    case "$KEY" in
	"/TrustAnchor/Zone") ZONE="$VAL";;
	"/TrustAnchor/KeyDigest/KeyTag") KTAG="$VAL";;
	"/TrustAnchor/KeyDigest/Algorithm") ALGO="$VAL";;
	"/TrustAnchor/KeyDigest/DigestType") DTYPE="$VAL";;
	"/TrustAnchor/KeyDigest/Digest")
	    DIGEST="$(echo "$VAL" | tr "[:upper:]" "[:lower:]")"
	    if [ -z "$ZONE" ] || [ -z "$KTAG" ] || [ -z "$ALGO" ] || [ -z "$DTYPE" ]; then
		echo "Missing some KeyDigest parameter"
		exit 1
	    fi
	    printf "%s IN DS %s %s %s %s\n" "$ZONE" "$KTAG" "$ALGO" "$DTYPE" "$DIGEST"
	    unset KTAG ALGO DTYPE DIGEST
	    ;;
    esac
done
exit 0
